/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.transport;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.neuralsearch.stats.common.StatSnapshot;
import org.opensearch.neuralsearch.stats.events.EventStatName;
import org.opensearch.neuralsearch.stats.events.EventStatsManager;
import org.opensearch.neuralsearch.stats.events.TimestampedEventStatSnapshot;
import org.opensearch.neuralsearch.stats.info.InfoStatName;
import org.opensearch.neuralsearch.stats.info.InfoStatsManager;
import org.opensearch.neuralsearch.transport.NeuralStatsNodeRequest;
import org.opensearch.neuralsearch.transport.NeuralStatsNodeResponse;
import org.opensearch.neuralsearch.transport.NeuralStatsRequest;
import org.opensearch.neuralsearch.transport.NeuralStatsResponse;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class NeuralStatsTransportAction
extends TransportNodesAction<NeuralStatsRequest, NeuralStatsResponse, NeuralStatsNodeRequest, NeuralStatsNodeResponse> {
    private final EventStatsManager eventStatsManager;
    private final InfoStatsManager infoStatsManager;

    @Inject
    public NeuralStatsTransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, EventStatsManager eventStatsManager, InfoStatsManager infoStatsManager) {
        super("cluster:admin/neural_stats_action", threadPool, clusterService, transportService, actionFilters, NeuralStatsRequest::new, NeuralStatsNodeRequest::new, "management", NeuralStatsNodeResponse.class);
        this.eventStatsManager = eventStatsManager;
        this.infoStatsManager = infoStatsManager;
    }

    protected NeuralStatsResponse newResponse(NeuralStatsRequest request, List<NeuralStatsNodeResponse> responses, List<FailedNodeException> failures) {
        HashMap resultStats = new HashMap();
        Map<String, Map<String, StatSnapshot<?>>> nodeIdToEventStats = this.processorNodeEventStatsIntoMap(responses);
        Map<String, StatSnapshot<?>> aggregatedNodeStats = this.aggregateNodesResponses(responses, request.getNeuralStatsInput().getEventStatNames());
        Map<InfoStatName, StatSnapshot<?>> infoStats = this.infoStatsManager.getStats(request.getNeuralStatsInput().getInfoStatNames());
        Map<String, StatSnapshot<?>> flatInfoStats = infoStats.entrySet().stream().collect(Collectors.toMap(entry -> ((InfoStatName)entry.getKey()).getFullPath(), Map.Entry::getValue));
        return new NeuralStatsResponse(this.clusterService.getClusterName(), responses, failures, flatInfoStats, aggregatedNodeStats, nodeIdToEventStats, request.getNeuralStatsInput().isFlatten(), request.getNeuralStatsInput().isIncludeMetadata());
    }

    protected NeuralStatsNodeRequest newNodeRequest(NeuralStatsRequest request) {
        return new NeuralStatsNodeRequest(request);
    }

    protected NeuralStatsNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new NeuralStatsNodeResponse(in);
    }

    protected NeuralStatsNodeResponse nodeOperation(NeuralStatsNodeRequest request) {
        EnumSet<EventStatName> eventStatsToRetrieve = request.getRequest().getNeuralStatsInput().getEventStatNames();
        Map<EventStatName, TimestampedEventStatSnapshot> eventStatDataMap = this.eventStatsManager.getTimestampedEventStatSnapshots(eventStatsToRetrieve);
        return new NeuralStatsNodeResponse(this.clusterService.localNode(), eventStatDataMap);
    }

    private Map<String, StatSnapshot<?>> aggregateNodesResponses(List<NeuralStatsNodeResponse> responses, EnumSet<EventStatName> statsToRetrieve) {
        if (responses == null || responses.isEmpty()) {
            return new HashMap();
        }
        List<Map> nodeEventStatsList = responses.stream().map(NeuralStatsNodeResponse::getStats).map(map -> map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).toList();
        HashMap aggregatedMap = new HashMap();
        for (EventStatName eventStatName : statsToRetrieve) {
            HashSet<TimestampedEventStatSnapshot> timestampedEventStatSnapshotCollection = new HashSet<TimestampedEventStatSnapshot>();
            for (Map eventStats : nodeEventStatsList) {
                timestampedEventStatSnapshotCollection.add((TimestampedEventStatSnapshot)eventStats.get(eventStatName));
            }
            TimestampedEventStatSnapshot aggregatedEventSnapshots = TimestampedEventStatSnapshot.aggregateEventStatSnapshots(timestampedEventStatSnapshotCollection);
            if (aggregatedEventSnapshots == null) continue;
            aggregatedMap.put(eventStatName.getFullPath(), aggregatedEventSnapshots);
        }
        return aggregatedMap;
    }

    private Map<String, Map<String, StatSnapshot<?>>> processorNodeEventStatsIntoMap(List<NeuralStatsNodeResponse> nodeResponses) {
        HashMap results = new HashMap();
        for (NeuralStatsNodeResponse nodesResponse : nodeResponses) {
            String nodeId = nodesResponse.getNode().getId();
            Map<String, StatSnapshot> resultNodeStatsMap = nodesResponse.getStats().entrySet().stream().collect(Collectors.toMap(entry -> ((EventStatName)entry.getKey()).getFullPath(), Map.Entry::getValue));
            results.put(nodeId, resultNodeStatsMap);
        }
        return results;
    }
}

