/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.stats.info;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.opensearch.neuralsearch.stats.common.StatName;
import org.opensearch.neuralsearch.stats.info.InfoStatType;

public enum InfoStatName implements StatName
{
    CLUSTER_VERSION("cluster_version", "", InfoStatType.INFO_STRING),
    TEXT_EMBEDDING_PROCESSORS("text_embedding_processors_in_pipelines", "processors.ingest", InfoStatType.INFO_COUNTER);

    private final String nameString;
    private final String path;
    private final InfoStatType statType;
    private static final Map<String, InfoStatName> BY_NAME;

    private InfoStatName(String nameString, String path, InfoStatType statType) {
        this.nameString = nameString;
        this.path = path;
        this.statType = statType;
    }

    public static InfoStatName from(String value) {
        if (!BY_NAME.containsKey(value)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Info stat not found: %s", value));
        }
        return BY_NAME.get(value);
    }

    @Override
    public String getFullPath() {
        if (StringUtils.isBlank((String)this.path)) {
            return this.nameString;
        }
        return String.join((CharSequence)".", this.path, this.nameString);
    }

    public String toString() {
        return this.getNameString();
    }

    @Override
    @Generated
    public String getNameString() {
        return this.nameString;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Override
    @Generated
    public InfoStatType getStatType() {
        return this.statType;
    }

    static {
        BY_NAME = Arrays.stream(InfoStatName.values()).collect(Collectors.toMap(stat -> stat.nameString, stat -> stat));
    }
}

