/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.neuralsearch.stats.events.EventStatName;
import org.opensearch.neuralsearch.stats.info.InfoStatName;

public class NeuralStatsInput
implements ToXContentObject,
Writeable {
    public static final String NODE_IDS_FIELD = "node_ids";
    public static final String EVENT_STAT_NAMES_FIELD = "event_stats";
    public static final String STATE_STAT_NAMES_FIELD = "state_stats";
    private List<String> nodeIds;
    private EnumSet<EventStatName> eventStatNames;
    private EnumSet<InfoStatName> infoStatNames;
    private boolean includeMetadata;
    private boolean flatten;

    public NeuralStatsInput(List<String> nodeIds, EnumSet<EventStatName> eventStatNames, EnumSet<InfoStatName> infoStatNames, boolean includeMetadata, boolean flatten) {
        this.nodeIds = nodeIds;
        this.eventStatNames = eventStatNames;
        this.infoStatNames = infoStatNames;
        this.includeMetadata = includeMetadata;
        this.flatten = flatten;
    }

    public NeuralStatsInput() {
        this.nodeIds = new ArrayList<String>();
        this.eventStatNames = EnumSet.noneOf(EventStatName.class);
        this.infoStatNames = EnumSet.noneOf(InfoStatName.class);
        this.includeMetadata = false;
        this.flatten = false;
    }

    public NeuralStatsInput(StreamInput input) throws IOException {
        this.nodeIds = input.readOptionalStringList();
        this.eventStatNames = input.readOptionalEnumSet(EventStatName.class);
        this.infoStatNames = input.readOptionalEnumSet(InfoStatName.class);
        this.includeMetadata = input.readBoolean();
        this.flatten = input.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalStringCollection(this.nodeIds);
        out.writeOptionalEnumSet(this.eventStatNames);
        out.writeOptionalEnumSet(this.infoStatNames);
        out.writeBoolean(this.includeMetadata);
        out.writeBoolean(this.flatten);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.nodeIds != null) {
            builder.field(NODE_IDS_FIELD, this.nodeIds);
        }
        if (this.eventStatNames != null) {
            builder.field(EVENT_STAT_NAMES_FIELD, this.eventStatNames);
        }
        if (this.infoStatNames != null) {
            builder.field(STATE_STAT_NAMES_FIELD, this.infoStatNames);
        }
        builder.field("include_metadata", this.includeMetadata);
        builder.field("flat_stat_paths", this.flatten);
        builder.endObject();
        return builder;
    }

    @Generated
    public static NeuralStatsInputBuilder builder() {
        return new NeuralStatsInputBuilder();
    }

    @Generated
    public List<String> getNodeIds() {
        return this.nodeIds;
    }

    @Generated
    public EnumSet<EventStatName> getEventStatNames() {
        return this.eventStatNames;
    }

    @Generated
    public EnumSet<InfoStatName> getInfoStatNames() {
        return this.infoStatNames;
    }

    @Generated
    public boolean isIncludeMetadata() {
        return this.includeMetadata;
    }

    @Generated
    public boolean isFlatten() {
        return this.flatten;
    }

    @Generated
    public void setIncludeMetadata(boolean includeMetadata) {
        this.includeMetadata = includeMetadata;
    }

    @Generated
    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    @Generated
    public static class NeuralStatsInputBuilder {
        @Generated
        private List<String> nodeIds;
        @Generated
        private EnumSet<EventStatName> eventStatNames;
        @Generated
        private EnumSet<InfoStatName> infoStatNames;
        @Generated
        private boolean includeMetadata;
        @Generated
        private boolean flatten;

        @Generated
        NeuralStatsInputBuilder() {
        }

        @Generated
        public NeuralStatsInputBuilder nodeIds(List<String> nodeIds) {
            this.nodeIds = nodeIds;
            return this;
        }

        @Generated
        public NeuralStatsInputBuilder eventStatNames(EnumSet<EventStatName> eventStatNames) {
            this.eventStatNames = eventStatNames;
            return this;
        }

        @Generated
        public NeuralStatsInputBuilder infoStatNames(EnumSet<InfoStatName> infoStatNames) {
            this.infoStatNames = infoStatNames;
            return this;
        }

        @Generated
        public NeuralStatsInputBuilder includeMetadata(boolean includeMetadata) {
            this.includeMetadata = includeMetadata;
            return this;
        }

        @Generated
        public NeuralStatsInputBuilder flatten(boolean flatten) {
            this.flatten = flatten;
            return this;
        }

        @Generated
        public NeuralStatsInput build() {
            return new NeuralStatsInput(this.nodeIds, this.eventStatNames, this.infoStatNames, this.includeMetadata, this.flatten);
        }

        @Generated
        public String toString() {
            return "NeuralStatsInput.NeuralStatsInputBuilder(nodeIds=" + String.valueOf(this.nodeIds) + ", eventStatNames=" + String.valueOf(this.eventStatNames) + ", infoStatNames=" + String.valueOf(this.infoStatNames) + ", includeMetadata=" + this.includeMetadata + ", flatten=" + this.flatten + ")";
        }
    }
}

