/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.query;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.lucene.search.Query;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.knn.index.query.KNNQueryBuilder;
import org.opensearch.knn.index.query.parser.KNNQueryBuilderParser;
import org.opensearch.knn.index.query.rescore.RescoreContext;
import org.opensearch.knn.index.util.IndexUtil;
import org.opensearch.neuralsearch.query.NeuralKNNQuery;

public class NeuralKNNQueryBuilder
extends AbstractQueryBuilder<NeuralKNNQueryBuilder> {
    private final KNNQueryBuilder knnQueryBuilder;
    private final String originalQueryText;

    public static Builder builder() {
        return new Builder();
    }

    public String fieldName() {
        return this.knnQueryBuilder.fieldName();
    }

    public int k() {
        return this.knnQueryBuilder.getK();
    }

    private NeuralKNNQueryBuilder(KNNQueryBuilder knnQueryBuilder, String originalQueryText) {
        this.knnQueryBuilder = knnQueryBuilder;
        this.originalQueryText = originalQueryText;
    }

    public void doWriteTo(StreamOutput out) throws IOException {
        KNNQueryBuilderParser.streamOutput((StreamOutput)out, (KNNQueryBuilder)this.knnQueryBuilder, IndexUtil::isClusterOnOrAfterMinRequiredVersion);
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.knnQueryBuilder.doXContent(builder, params);
    }

    protected QueryBuilder doRewrite(QueryRewriteContext context) throws IOException {
        QueryBuilder rewritten = this.knnQueryBuilder.rewrite(context);
        if (rewritten == this.knnQueryBuilder) {
            return this;
        }
        return new NeuralKNNQueryBuilder((KNNQueryBuilder)rewritten, this.originalQueryText);
    }

    protected Query doToQuery(QueryShardContext context) throws IOException {
        Query knnQuery = this.knnQueryBuilder.toQuery(context);
        return new NeuralKNNQuery(knnQuery, this.originalQueryText);
    }

    protected boolean doEquals(NeuralKNNQueryBuilder other) {
        return Objects.equals(this.knnQueryBuilder, other.knnQueryBuilder) && Objects.equals(this.originalQueryText, other.originalQueryText);
    }

    protected int doHashCode() {
        return Objects.hash(this.knnQueryBuilder, this.originalQueryText);
    }

    public String getWriteableName() {
        return this.knnQueryBuilder.getWriteableName();
    }

    @Generated
    public KNNQueryBuilder getKnnQueryBuilder() {
        return this.knnQueryBuilder;
    }

    @Generated
    public String getOriginalQueryText() {
        return this.originalQueryText;
    }

    public static class Builder {
        private String fieldName;
        private float[] vector;
        private Integer k;
        private QueryBuilder filter;
        private Float maxDistance;
        private Float minScore;
        private Boolean expandNested;
        private Map<String, ?> methodParameters;
        private RescoreContext rescoreContext;
        private String originalQueryText;

        private Builder() {
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder vector(float[] vector) {
            this.vector = vector;
            return this;
        }

        public Builder k(Integer k) {
            this.k = k;
            return this;
        }

        public Builder filter(QueryBuilder filter) {
            this.filter = filter;
            return this;
        }

        public Builder maxDistance(Float maxDistance) {
            this.maxDistance = maxDistance;
            return this;
        }

        public Builder minScore(Float minScore) {
            this.minScore = minScore;
            return this;
        }

        public Builder expandNested(Boolean expandNested) {
            this.expandNested = expandNested;
            return this;
        }

        public Builder methodParameters(Map<String, ?> methodParameters) {
            this.methodParameters = methodParameters;
            return this;
        }

        public Builder rescoreContext(RescoreContext rescoreContext) {
            this.rescoreContext = rescoreContext;
            return this;
        }

        public Builder originalQueryText(String originalQueryText) {
            this.originalQueryText = originalQueryText;
            return this;
        }

        public NeuralKNNQueryBuilder build() {
            KNNQueryBuilder knnBuilder = KNNQueryBuilder.builder().fieldName(this.fieldName).vector(this.vector).k(this.k).filter(this.filter).maxDistance(this.maxDistance).minScore(this.minScore).expandNested(this.expandNested).methodParameters(this.methodParameters).rescoreContext(this.rescoreContext).build();
            return new NeuralKNNQueryBuilder(knnBuilder, this.originalQueryText);
        }
    }
}

