/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.combination;

import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.neuralsearch.processor.combination.ScoreCombinationTechnique;
import org.opensearch.neuralsearch.processor.explain.ExplainableTechnique;
import org.opensearch.neuralsearch.processor.explain.ExplanationUtils;

public class RRFScoreCombinationTechnique
implements ScoreCombinationTechnique,
ExplainableTechnique {
    @Generated
    private static final Logger log = LogManager.getLogger(RRFScoreCombinationTechnique.class);
    public static final String TECHNIQUE_NAME = "rrf";

    @Override
    public float combine(float[] scores) {
        if (Objects.isNull(scores)) {
            throw new IllegalArgumentException("scores array cannot be null");
        }
        float sumScores = 0.0f;
        for (float score : scores) {
            sumScores += score;
        }
        return sumScores;
    }

    @Override
    public String techniqueName() {
        return TECHNIQUE_NAME;
    }

    @Override
    public String describe() {
        return ExplanationUtils.describeCombinationTechnique(TECHNIQUE_NAME, List.of());
    }

    @Generated
    public String toString() {
        return "RRFScoreCombinationTechnique(TECHNIQUE_NAME=rrf)";
    }
}

