/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.function_calling;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.output.model.ModelTensorOutput;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.engine.algorithms.agent.AgentUtils;
import org.opensearch.ml.engine.function_calling.FunctionCalling;
import org.opensearch.ml.engine.function_calling.LLMMessage;
import org.opensearch.ml.engine.function_calling.OpenaiMessage;

public class OpenaiV1ChatCompletionsFunctionCalling
implements FunctionCalling {
    public static final String FINISH_REASON_PATH = "$.choices[0].finish_reason";
    public static final String FINISH_REASON = "tool_calls";
    public static final String CALL_PATH = "$.choices[0].message.tool_calls";
    public static final String NAME = "function.name";
    public static final String INPUT = "function.arguments";
    public static final String ID_PATH = "id";
    public static final String OPENAI_V1_CHAT_COMPLETION_TEMPLATE = "{\"type\": \"function\", \"function\": { \"name\": \"${tool.name}\", \"description\": \"${tool.description}\", \"parameters\": ${tool.attributes.input_schema}, \"strict\": ${tool.attributes.strict:-false} } }";

    @Override
    public void configure(Map<String, String> params) {
        params.put("tool_template", OPENAI_V1_CHAT_COMPLETION_TEMPLATE);
    }

    @Override
    public List<Map<String, String>> handle(ModelTensorOutput tmpModelTensorOutput, Map<String, String> parameters) {
        String llmFinishReason;
        ArrayList<Map<String, String>> output = new ArrayList<Map<String, String>>();
        Map<String, ?> dataAsMap = ((ModelTensor)((ModelTensors)tmpModelTensorOutput.getMlModelOutputs().get(0)).getMlModelTensors().get(0)).getDataAsMap();
        String llmResponseExcludePath = parameters.get("llm_response_exclude_path");
        if (llmResponseExcludePath != null) {
            dataAsMap = AgentUtils.removeJsonPath(dataAsMap, llmResponseExcludePath, true);
        }
        if (!(llmFinishReason = (String)JsonPath.read(dataAsMap, (String)FINISH_REASON_PATH, (Predicate[])new Predicate[0])).contentEquals(FINISH_REASON)) {
            return output;
        }
        List toolCalls = (List)JsonPath.read(dataAsMap, (String)CALL_PATH, (Predicate[])new Predicate[0]);
        if (CollectionUtils.isEmpty((Collection)toolCalls)) {
            return output;
        }
        for (Object call : toolCalls) {
            String toolName = (String)JsonPath.read(call, (String)NAME, (Predicate[])new Predicate[0]);
            String toolInput = StringUtils.toJson((Object)JsonPath.read(call, (String)INPUT, (Predicate[])new Predicate[0]));
            String toolCallId = (String)JsonPath.read(call, (String)ID_PATH, (Predicate[])new Predicate[0]);
            output.add(Map.of("tool_name", toolName, "tool_input", toolInput, "tool_call_id", toolCallId));
        }
        return output;
    }

    @Override
    public List<LLMMessage> supply(List<Map<String, Object>> toolResults) {
        ArrayList<LLMMessage> messages = new ArrayList<LLMMessage>();
        OpenaiMessage toolMessage = new OpenaiMessage();
        for (Map<String, Object> toolResult : toolResults) {
            String toolUseId = (String)toolResult.get("tool_call_id");
            if (toolUseId == null) continue;
            toolMessage.setToolCallId(toolUseId);
            toolMessage.setContent((String)toolResult.get("tool_result"));
            messages.add(toolMessage);
        }
        return messages;
    }
}

