/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.agent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLAgentType;
import org.opensearch.ml.common.MLTask;
import org.opensearch.ml.common.MLTaskState;
import org.opensearch.ml.common.MLTaskType;
import org.opensearch.ml.common.agent.MLAgent;
import org.opensearch.ml.common.agent.MLMemorySpec;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.input.Input;
import org.opensearch.ml.common.input.execute.agent.AgentMLInput;
import org.opensearch.ml.common.output.MLTaskOutput;
import org.opensearch.ml.common.output.Output;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.output.model.ModelTensorOutput;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.common.settings.SettingsChangeListener;
import org.opensearch.ml.common.spi.memory.Memory;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.engine.Executable;
import org.opensearch.ml.engine.algorithms.agent.MLAgentRunner;
import org.opensearch.ml.engine.algorithms.agent.MLChatAgentRunner;
import org.opensearch.ml.engine.algorithms.agent.MLConversationalFlowAgentRunner;
import org.opensearch.ml.engine.algorithms.agent.MLFlowAgentRunner;
import org.opensearch.ml.engine.algorithms.agent.MLPlanExecuteAndReflectAgentRunner;
import org.opensearch.ml.engine.annotation.Function;
import org.opensearch.ml.engine.memory.ConversationIndexMemory;
import org.opensearch.ml.engine.memory.ConversationIndexMessage;
import org.opensearch.ml.memory.action.conversation.GetInteractionAction;
import org.opensearch.ml.memory.action.conversation.GetInteractionRequest;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.PutDataObjectRequest;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.transport.client.Client;

@Function(value=FunctionName.AGENT)
public class MLAgentExecutor
implements Executable,
SettingsChangeListener {
    @Generated
    private static final Logger log = LogManager.getLogger(MLAgentExecutor.class);
    public static final String MEMORY_ID = "memory_id";
    public static final String QUESTION = "question";
    public static final String PARENT_INTERACTION_ID = "parent_interaction_id";
    public static final String REGENERATE_INTERACTION_ID = "regenerate_interaction_id";
    public static final String MESSAGE_HISTORY_LIMIT = "message_history_limit";
    public static final String ERROR_MESSAGE = "error_message";
    public static final ImmutableSet<MLTaskState> TASK_DONE_STATES = ImmutableSet.of((Object)MLTaskState.COMPLETED, (Object)MLTaskState.COMPLETED_WITH_ERROR, (Object)MLTaskState.FAILED, (Object)MLTaskState.CANCELLED);
    private Client client;
    private SdkClient sdkClient;
    private Settings settings;
    private ClusterService clusterService;
    private NamedXContentRegistry xContentRegistry;
    private Map<String, Tool.Factory> toolFactories;
    private Map<String, Memory.Factory> memoryFactoryMap;
    private volatile Boolean isMultiTenancyEnabled;

    public MLAgentExecutor(Client client, SdkClient sdkClient, Settings settings, ClusterService clusterService, NamedXContentRegistry xContentRegistry, Map<String, Tool.Factory> toolFactories, Map<String, Memory.Factory> memoryFactoryMap, Boolean isMultiTenancyEnabled) {
        this.client = client;
        this.sdkClient = sdkClient;
        this.settings = settings;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.toolFactories = toolFactories;
        this.memoryFactoryMap = memoryFactoryMap;
        this.isMultiTenancyEnabled = isMultiTenancyEnabled;
    }

    public void onMultiTenancyEnabledChanged(boolean isEnabled) {
        this.isMultiTenancyEnabled = isEnabled;
    }

    @Override
    public void execute(Input input, ActionListener<Output> listener) {
        if (!(input instanceof AgentMLInput)) {
            throw new IllegalArgumentException("wrong input");
        }
        AgentMLInput agentMLInput = (AgentMLInput)input;
        String agentId = agentMLInput.getAgentId();
        String tenantId = agentMLInput.getTenantId();
        Boolean isAsync = agentMLInput.getIsAsync();
        RemoteInferenceInputDataSet inputDataSet = (RemoteInferenceInputDataSet)agentMLInput.getInputDataset();
        if (inputDataSet == null || inputDataSet.getParameters() == null) {
            throw new IllegalArgumentException("Agent input data can not be empty.");
        }
        if (this.isMultiTenancyEnabled.booleanValue() && tenantId == null) {
            throw new OpenSearchStatusException("You don't have permission to access this resource", RestStatus.FORBIDDEN, new Object[0]);
        }
        ArrayList<ModelTensors> outputs = new ArrayList<ModelTensors>();
        ArrayList modelTensors = new ArrayList();
        outputs.add(ModelTensors.builder().mlModelTensors(modelTensors).build());
        FetchSourceContext fetchSourceContext = new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
        GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-agent")).id(agentId)).tenantId(tenantId)).fetchSourceContext(fetchSourceContext).build();
        if (this.clusterService.state().metadata().hasIndex(".plugins-ml-agent")) {
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                this.sdkClient.getDataObjectAsync(getDataObjectRequest, (Executor)this.client.threadPool().executor("opensearch_ml_general")).whenComplete((response, throwable) -> {
                    block19: {
                        context.restore();
                        log.debug("Completed Get Agent Request, Agent id:{}", (Object)agentId);
                        if (throwable != null) {
                            Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                            if (ExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
                                log.error("Failed to get Agent index", (Throwable)cause);
                                listener.onFailure((Exception)new OpenSearchStatusException("Failed to get agent index", RestStatus.NOT_FOUND, new Object[0]));
                            } else {
                                log.error("Failed to get ML Agent {}", (Object)agentId, (Object)cause);
                                listener.onFailure(cause);
                            }
                        } else {
                            try {
                                GetResponse getAgentResponse;
                                GetResponse getResponse = getAgentResponse = response.parser() == null ? null : GetResponse.fromXContent((XContentParser)response.parser());
                                if (getAgentResponse != null && getAgentResponse.isExists()) {
                                    try (XContentParser parser = JsonXContent.jsonXContent.createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, getAgentResponse.getSourceAsString());){
                                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                        MLAgent mlAgent = MLAgent.parse((XContentParser)parser);
                                        if (this.isMultiTenancyEnabled.booleanValue() && !Objects.equals(tenantId, mlAgent.getTenantId())) {
                                            listener.onFailure((Exception)new OpenSearchStatusException("You don't have permission to access this resource", RestStatus.FORBIDDEN, new Object[0]));
                                        }
                                        MLMemorySpec memorySpec = mlAgent.getMemory();
                                        String memoryId = (String)inputDataSet.getParameters().get(MEMORY_ID);
                                        String parentInteractionId = (String)inputDataSet.getParameters().get(PARENT_INTERACTION_ID);
                                        String regenerateInteractionId = (String)inputDataSet.getParameters().get(REGENERATE_INTERACTION_ID);
                                        String appType = mlAgent.getAppType();
                                        String question = (String)inputDataSet.getParameters().get(QUESTION);
                                        MLTask mlTask = MLTask.builder().taskType(MLTaskType.AGENT_EXECUTION).functionName(FunctionName.AGENT).state(MLTaskState.CREATED).workerNodes((List)ImmutableList.of((Object)this.clusterService.localNode().getId())).createTime(Instant.now()).lastUpdateTime(Instant.now()).async(false).tenantId(tenantId).build();
                                        if (memoryId == null && regenerateInteractionId != null) {
                                            throw new IllegalArgumentException("A memory ID must be provided to regenerate.");
                                        }
                                        if (memorySpec != null && memorySpec.getType() != null && this.memoryFactoryMap.containsKey(memorySpec.getType()) && (memoryId == null || parentInteractionId == null)) {
                                            ConversationIndexMemory.Factory conversationIndexMemoryFactory = (ConversationIndexMemory.Factory)this.memoryFactoryMap.get(memorySpec.getType());
                                            conversationIndexMemoryFactory.create(question, memoryId, appType, (ActionListener<ConversationIndexMemory>)ActionListener.wrap(memory -> {
                                                inputDataSet.getParameters().put(MEMORY_ID, memory.getConversationId());
                                                if (regenerateInteractionId != null) {
                                                    log.info("Regenerate for existing interaction {}", (Object)regenerateInteractionId);
                                                    this.client.execute((ActionType)GetInteractionAction.INSTANCE, (ActionRequest)new GetInteractionRequest(regenerateInteractionId), ActionListener.wrap(interactionRes -> {
                                                        inputDataSet.getParameters().putIfAbsent(QUESTION, interactionRes.getInteraction().getInput());
                                                        this.saveRootInteractionAndExecute(listener, (ConversationIndexMemory)memory, inputDataSet, mlTask, isAsync, outputs, modelTensors, mlAgent);
                                                    }, e -> {
                                                        log.error("Failed to get existing interaction for regeneration", (Throwable)e);
                                                        listener.onFailure(e);
                                                    }));
                                                } else {
                                                    this.saveRootInteractionAndExecute(listener, (ConversationIndexMemory)memory, inputDataSet, mlTask, isAsync, outputs, modelTensors, mlAgent);
                                                }
                                            }, ex -> {
                                                log.error("Failed to read conversation memory", (Throwable)ex);
                                                listener.onFailure(ex);
                                            }));
                                        } else {
                                            this.executeAgent(inputDataSet, mlTask, isAsync, memoryId, mlAgent, outputs, modelTensors, listener);
                                        }
                                        break block19;
                                    }
                                    catch (Exception e) {
                                        log.error("Failed to parse ml agent {}", (Object)agentId, (Object)e);
                                        listener.onFailure(e);
                                    }
                                    break block19;
                                }
                                listener.onFailure((Exception)new OpenSearchStatusException("Failed to find agent with the provided agent id: " + agentId, RestStatus.NOT_FOUND, new Object[0]));
                            }
                            catch (Exception e) {
                                log.error("Failed to get agent", (Throwable)e);
                                listener.onFailure(e);
                            }
                        }
                    }
                });
            }
        } else {
            listener.onFailure((Exception)new ResourceNotFoundException("Agent index not found", new Object[0]));
        }
    }

    private void saveRootInteractionAndExecute(ActionListener<Output> listener, ConversationIndexMemory memory, RemoteInferenceInputDataSet inputDataSet, MLTask mlTask, boolean isAsync, List<ModelTensors> outputs, List<ModelTensor> modelTensors, MLAgent mlAgent) {
        String appType = mlAgent.getAppType();
        String question = (String)inputDataSet.getParameters().get(QUESTION);
        String regenerateInteractionId = (String)inputDataSet.getParameters().get(REGENERATE_INTERACTION_ID);
        ConversationIndexMessage msg = ConversationIndexMessage.conversationIndexMessageBuilder().type(appType).question(question).response("").finalAnswer(true).sessionId(memory.getConversationId()).build();
        memory.save(msg, null, null, null, ActionListener.wrap(interaction -> {
            log.info("Created parent interaction ID: {}", (Object)interaction.getId());
            inputDataSet.getParameters().put(PARENT_INTERACTION_ID, interaction.getId());
            if (regenerateInteractionId != null) {
                memory.getMemoryManager().deleteInteractionAndTrace(regenerateInteractionId, (ActionListener<Boolean>)ActionListener.wrap(deleted -> this.executeAgent(inputDataSet, mlTask, isAsync, memory.getConversationId(), mlAgent, outputs, modelTensors, listener), e -> {
                    log.error("Failed to regenerate for interaction {}", (Object)regenerateInteractionId, e);
                    listener.onFailure(e);
                }));
            } else {
                this.executeAgent(inputDataSet, mlTask, isAsync, memory.getConversationId(), mlAgent, outputs, modelTensors, listener);
            }
        }, ex -> {
            log.error("Failed to create parent interaction", (Throwable)ex);
            listener.onFailure(ex);
        }));
    }

    private void executeAgent(RemoteInferenceInputDataSet inputDataSet, MLTask mlTask, boolean isAsync, String memoryId, MLAgent mlAgent, List<ModelTensors> outputs, List<ModelTensor> modelTensors, ActionListener<Output> listener) {
        MLAgentRunner mlAgentRunner = this.getAgentRunner(mlAgent);
        if (isAsync) {
            HashMap<String, String> agentResponse = new HashMap<String, String>();
            if (memoryId != null && !memoryId.isEmpty()) {
                agentResponse.put(MEMORY_ID, memoryId);
                mlTask.setResponse(agentResponse);
            }
            this.indexMLTask(mlTask, (ActionListener<IndexResponse>)ActionListener.wrap(indexResponse -> {
                String taskId = indexResponse.getId();
                mlTask.setTaskId(taskId);
                MLTaskOutput outputBuilder = MLTaskOutput.builder().taskId(taskId).status(MLTaskState.RUNNING.toString()).build();
                if (memoryId != null && !memoryId.isEmpty()) {
                    outputBuilder.setResponse(agentResponse);
                }
                listener.onResponse((Object)outputBuilder);
                ActionListener<Object> agentActionListener = this.createAsyncTaskUpdater(mlTask, outputs, modelTensors);
                mlAgentRunner.run(mlAgent, inputDataSet.getParameters(), agentActionListener);
            }, e -> {
                log.error("Failed to create task for agent async execution", (Throwable)e);
                listener.onFailure(e);
            }));
        } else {
            ActionListener<Object> agentActionListener = this.createAgentActionListener(listener, outputs, modelTensors, mlAgent.getType());
            mlAgentRunner.run(mlAgent, inputDataSet.getParameters(), agentActionListener);
        }
    }

    private ActionListener<Object> createAgentActionListener(ActionListener<Output> listener, List<ModelTensors> outputs, List<ModelTensor> modelTensors, String agentType) {
        return ActionListener.wrap(output -> {
            if (output != null) {
                this.processOutput(output, modelTensors);
                listener.onResponse((Object)ModelTensorOutput.builder().mlModelOutputs(outputs).build());
            } else {
                listener.onResponse(null);
            }
        }, ex -> {
            log.error("Failed to run {} agent", (Object)agentType, ex);
            listener.onFailure(ex);
        });
    }

    private ActionListener<Object> createAsyncTaskUpdater(MLTask mlTask, List<ModelTensors> outputs, List<ModelTensor> modelTensors) {
        String taskId = mlTask.getTaskId();
        HashMap agentResponse = new HashMap();
        HashMap updatedTask = new HashMap();
        return ActionListener.wrap(output -> {
            if (output != null) {
                this.processOutput(output, modelTensors);
                agentResponse.put("inference_results", outputs);
            } else {
                agentResponse.put(ERROR_MESSAGE, "No output found from agent execution");
            }
            mlTask.setResponse(agentResponse);
            updatedTask.put("response", agentResponse);
            updatedTask.put("state", MLTaskState.COMPLETED);
            this.updateMLTaskDirectly(taskId, updatedTask, (ActionListener<UpdateResponse>)ActionListener.wrap(response -> log.info("Updated ML task {} with agent execution results", (Object)taskId), e -> log.error("Failed to update ML task {} with agent execution results", (Object)taskId)));
        }, ex -> {
            agentResponse.put(ERROR_MESSAGE, ex.getMessage());
            updatedTask.put("response", agentResponse);
            updatedTask.put("state", MLTaskState.FAILED);
            mlTask.setResponse(agentResponse);
            this.updateMLTaskDirectly(taskId, updatedTask, (ActionListener<UpdateResponse>)ActionListener.wrap(response -> log.info("Updated ML task {} with agent execution failed reason", (Object)taskId), e -> log.error("Failed to update ML task {} with agent execution results", (Object)taskId)));
        });
    }

    @VisibleForTesting
    protected MLAgentRunner getAgentRunner(MLAgent mlAgent) {
        MLAgentType agentType = MLAgentType.from((String)mlAgent.getType().toUpperCase(Locale.ROOT));
        switch (agentType) {
            case FLOW: {
                return new MLFlowAgentRunner(this.client, this.settings, this.clusterService, this.xContentRegistry, this.toolFactories, this.memoryFactoryMap);
            }
            case CONVERSATIONAL_FLOW: {
                return new MLConversationalFlowAgentRunner(this.client, this.settings, this.clusterService, this.xContentRegistry, this.toolFactories, this.memoryFactoryMap);
            }
            case CONVERSATIONAL: {
                return new MLChatAgentRunner(this.client, this.settings, this.clusterService, this.xContentRegistry, this.toolFactories, this.memoryFactoryMap);
            }
            case PLAN_EXECUTE_AND_REFLECT: {
                return new MLPlanExecuteAndReflectAgentRunner(this.client, this.settings, this.clusterService, this.xContentRegistry, this.toolFactories, this.memoryFactoryMap);
            }
        }
        throw new IllegalArgumentException("Unsupported agent type: " + mlAgent.getType());
    }

    public void processOutput(Object output, List<ModelTensor> modelTensors) throws PrivilegedActionException {
        Gson gson = new Gson();
        if (output instanceof ModelTensorOutput) {
            ModelTensorOutput modelTensorOutput = (ModelTensorOutput)output;
            modelTensorOutput.getMlModelOutputs().forEach(outs -> modelTensors.addAll(outs.getMlModelTensors()));
        } else if (output instanceof ModelTensor) {
            modelTensors.add((ModelTensor)output);
        } else if (output instanceof List) {
            if (((List)output).get(0) instanceof ModelTensor) {
                modelTensors.addAll((List)output);
            } else if (((List)output).get(0) instanceof ModelTensors) {
                ((List)output).forEach(outs -> modelTensors.addAll(outs.getMlModelTensors()));
            } else {
                String result = AccessController.doPrivileged(() -> gson.toJson(output));
                modelTensors.add(ModelTensor.builder().name("response").result(result).build());
            }
        } else {
            String result = output instanceof String ? (String)output : AccessController.doPrivileged(() -> gson.toJson(output));
            modelTensors.add(ModelTensor.builder().name("response").result(result).build());
        }
    }

    public void indexMLTask(MLTask mlTask, ActionListener<IndexResponse> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.sdkClient.putDataObjectAsync(((PutDataObjectRequest.Builder)((PutDataObjectRequest.Builder)PutDataObjectRequest.builder().index(".plugins-ml-task")).tenantId(mlTask.getTenantId())).dataObject((ToXContentObject)mlTask).build()).whenComplete((r, throwable) -> {
                context.restore();
                if (throwable != null) {
                    Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                    log.error("Failed to index ML task", (Throwable)cause);
                    listener.onFailure(cause);
                } else {
                    try {
                        IndexResponse indexResponse = IndexResponse.fromXContent((XContentParser)r.parser());
                        log.info("Task creation result: {}, Task id: {}", (Object)indexResponse.getResult(), (Object)indexResponse.getId());
                        listener.onResponse((Object)indexResponse);
                    }
                    catch (Exception e) {
                        listener.onFailure(e);
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to create ML task for {}, {}", (Object)mlTask.getFunctionName(), (Object)mlTask.getTaskType(), (Object)e);
            listener.onFailure(e);
        }
    }

    public void updateMLTaskDirectly(String taskId, Map<String, Object> updatedFields, ActionListener<UpdateResponse> listener) {
        try {
            if (updatedFields == null || updatedFields.isEmpty()) {
                listener.onFailure((Exception)new IllegalArgumentException("Updated fields is null or empty"));
                return;
            }
            UpdateRequest updateRequest = new UpdateRequest(".plugins-ml-task", taskId);
            HashMap<String, Object> updatedContent = new HashMap<String, Object>(updatedFields);
            updatedContent.put("last_update_time", Instant.now().toEpochMilli());
            updateRequest.doc(updatedContent);
            updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            if (updatedFields.containsKey("state") && TASK_DONE_STATES.contains((Object)updatedFields.containsKey("state"))) {
                updateRequest.retryOnConflict(3);
            }
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                this.client.update(updateRequest, ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore()));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }
        catch (Exception e) {
            log.error("Failed to update ML task {}", (Object)taskId, (Object)e);
            listener.onFailure(e);
        }
    }

    @Generated
    public Client getClient() {
        return this.client;
    }

    @Generated
    public SdkClient getSdkClient() {
        return this.sdkClient;
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Generated
    public ClusterService getClusterService() {
        return this.clusterService;
    }

    @Generated
    public NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @Generated
    public Map<String, Tool.Factory> getToolFactories() {
        return this.toolFactories;
    }

    @Generated
    public Map<String, Memory.Factory> getMemoryFactoryMap() {
        return this.memoryFactoryMap;
    }

    @Generated
    public Boolean getIsMultiTenancyEnabled() {
        return this.isMultiTenancyEnabled;
    }

    @Generated
    public void setClient(Client client) {
        this.client = client;
    }

    @Generated
    public void setSdkClient(SdkClient sdkClient) {
        this.sdkClient = sdkClient;
    }

    @Generated
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Generated
    public void setClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    @Generated
    public void setXContentRegistry(NamedXContentRegistry xContentRegistry) {
        this.xContentRegistry = xContentRegistry;
    }

    @Generated
    public void setToolFactories(Map<String, Tool.Factory> toolFactories) {
        this.toolFactories = toolFactories;
    }

    @Generated
    public void setMemoryFactoryMap(Map<String, Memory.Factory> memoryFactoryMap) {
        this.memoryFactoryMap = memoryFactoryMap;
    }

    @Generated
    public void setIsMultiTenancyEnabled(Boolean isMultiTenancyEnabled) {
        this.isMultiTenancyEnabled = isMultiTenancyEnabled;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLAgentExecutor)) {
            return false;
        }
        MLAgentExecutor other = (MLAgentExecutor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isMultiTenancyEnabled = this.getIsMultiTenancyEnabled();
        Boolean other$isMultiTenancyEnabled = other.getIsMultiTenancyEnabled();
        if (this$isMultiTenancyEnabled == null ? other$isMultiTenancyEnabled != null : !((Object)this$isMultiTenancyEnabled).equals(other$isMultiTenancyEnabled)) {
            return false;
        }
        Client this$client = this.getClient();
        Client other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        SdkClient this$sdkClient = this.getSdkClient();
        SdkClient other$sdkClient = other.getSdkClient();
        if (this$sdkClient == null ? other$sdkClient != null : !this$sdkClient.equals(other$sdkClient)) {
            return false;
        }
        Settings this$settings = this.getSettings();
        Settings other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !this$settings.equals(other$settings)) {
            return false;
        }
        ClusterService this$clusterService = this.getClusterService();
        ClusterService other$clusterService = other.getClusterService();
        if (this$clusterService == null ? other$clusterService != null : !this$clusterService.equals(other$clusterService)) {
            return false;
        }
        NamedXContentRegistry this$xContentRegistry = this.getXContentRegistry();
        NamedXContentRegistry other$xContentRegistry = other.getXContentRegistry();
        if (this$xContentRegistry == null ? other$xContentRegistry != null : !this$xContentRegistry.equals(other$xContentRegistry)) {
            return false;
        }
        Map<String, Tool.Factory> this$toolFactories = this.getToolFactories();
        Map<String, Tool.Factory> other$toolFactories = other.getToolFactories();
        if (this$toolFactories == null ? other$toolFactories != null : !((Object)this$toolFactories).equals(other$toolFactories)) {
            return false;
        }
        Map<String, Memory.Factory> this$memoryFactoryMap = this.getMemoryFactoryMap();
        Map<String, Memory.Factory> other$memoryFactoryMap = other.getMemoryFactoryMap();
        return !(this$memoryFactoryMap == null ? other$memoryFactoryMap != null : !((Object)this$memoryFactoryMap).equals(other$memoryFactoryMap));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLAgentExecutor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isMultiTenancyEnabled = this.getIsMultiTenancyEnabled();
        result = result * 59 + ($isMultiTenancyEnabled == null ? 43 : ((Object)$isMultiTenancyEnabled).hashCode());
        Client $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        SdkClient $sdkClient = this.getSdkClient();
        result = result * 59 + ($sdkClient == null ? 43 : $sdkClient.hashCode());
        Settings $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : $settings.hashCode());
        ClusterService $clusterService = this.getClusterService();
        result = result * 59 + ($clusterService == null ? 43 : $clusterService.hashCode());
        NamedXContentRegistry $xContentRegistry = this.getXContentRegistry();
        result = result * 59 + ($xContentRegistry == null ? 43 : $xContentRegistry.hashCode());
        Map<String, Tool.Factory> $toolFactories = this.getToolFactories();
        result = result * 59 + ($toolFactories == null ? 43 : ((Object)$toolFactories).hashCode());
        Map<String, Memory.Factory> $memoryFactoryMap = this.getMemoryFactoryMap();
        result = result * 59 + ($memoryFactoryMap == null ? 43 : ((Object)$memoryFactoryMap).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MLAgentExecutor(client=" + String.valueOf(this.getClient()) + ", sdkClient=" + String.valueOf(this.getSdkClient()) + ", settings=" + String.valueOf(this.getSettings()) + ", clusterService=" + String.valueOf(this.getClusterService()) + ", xContentRegistry=" + String.valueOf(this.getXContentRegistry()) + ", toolFactories=" + String.valueOf(this.getToolFactories()) + ", memoryFactoryMap=" + String.valueOf(this.getMemoryFactoryMap()) + ", isMultiTenancyEnabled=" + this.getIsMultiTenancyEnabled() + ")";
    }

    @Generated
    public MLAgentExecutor() {
    }
}

