/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.admin.indices.rollover.RolloverRequest;
import org.opensearch.action.admin.indices.rollover.RolloverResponse;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.cluster.LocalNodeClusterManagerListener;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.indexmanagement.IndexManagementIndices;
import org.opensearch.indexmanagement.indexstatemanagement.IndexStateManagementHistory;
import org.opensearch.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Step;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepMetaData;
import org.opensearch.indexmanagement.util.OpenForTesting;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.OpenSearchClient;

@OpenForTesting
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001c\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0096@\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020$H\u0012J\u0016\u0010(\u001a\u00020!2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0#H\u0012J\b\u0010+\u001a\u00020!H\u0012J\u0016\u0010+\u001a\u00020!2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0#H\u0012J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020*0#2\u0006\u0010-\u001a\u00020.H\u0012J\b\u0010/\u001a\u00020!H\u0016J\b\u00100\u001a\u00020!H\u0016J\b\u00101\u001a\u00020!H\u0012J\b\u00102\u001a\u00020!H\u0012J\b\u00103\u001a\u00020!H\u0012J\u0010\u00104\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020$H\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0016\u0010\u0011\u001a\n \u000f*\u0004\u0018\u00010\u00120\u0012X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\n \u000f*\u0004\u0018\u00010\u00140\u0014X\u0092\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0018\u0010\u0016\u001a\n \u000f*\u0004\u0018\u00010\u00170\u0017X\u0092\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0018\u0010\u0019\u001a\n \u000f*\u0004\u0018\u00010\u00170\u0017X\u0092\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0016\u0010\u001a\u001a\n \u000f*\u0004\u0018\u00010\u00120\u0012X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n \u000f*\u0004\u0018\u00010\u00120\u0012X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n \u000f*\u0004\u0018\u00010\u001d0\u001dX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/IndexStateManagementHistory;", "Lorg/opensearch/cluster/LocalNodeClusterManagerListener;", "settings", "Lorg/opensearch/common/settings/Settings;", "client", "Lorg/opensearch/transport/client/Client;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "indexManagementIndices", "Lorg/opensearch/indexmanagement/IndexManagementIndices;", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/transport/client/Client;Lorg/opensearch/threadpool/ThreadPool;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/indexmanagement/IndexManagementIndices;)V", "historyEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "historyMaxAge", "Lorg/opensearch/common/unit/TimeValue;", "historyMaxDocs", "", "Ljava/lang/Long;", "historyNumberOfReplicas", "", "Ljava/lang/Integer;", "historyNumberOfShards", "historyRetentionPeriod", "historyRolloverCheckPeriod", "logger", "Lorg/apache/logging/log4j/Logger;", "scheduledRollover", "Lorg/opensearch/threadpool/Scheduler$Cancellable;", "addManagedIndexMetaDataHistory", "", "managedIndexMetaData", "", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createManagedIndexMetaDataHistoryIndexRequest", "Lorg/opensearch/action/index/IndexRequest;", "deleteAllOldHistoryIndices", "indicesToDelete", "", "deleteOldHistoryIndex", "getIndicesToDelete", "clusterStateResponse", "Lorg/opensearch/action/admin/cluster/state/ClusterStateResponse;", "offClusterManager", "onClusterManager", "rescheduleRollover", "rolloverAndDeleteHistoryIndex", "rolloverHistoryIndex", "shouldAddManagedIndexMetaDataToHistory", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nIndexStateManagementHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexStateManagementHistory.kt\norg/opensearch/indexmanagement/indexstatemanagement/IndexStateManagementHistory\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,324:1\n37#2,2:325\n37#2,2:327\n766#3:329\n857#3,2:330\n1549#3:332\n1620#3,3:333\n*S KotlinDebug\n*F\n+ 1 IndexStateManagementHistory.kt\norg/opensearch/indexmanagement/indexstatemanagement/IndexStateManagementHistory\n*L\n227#1:325,2\n250#1:327,2\n282#1:329\n282#1:330,2\n283#1:332\n283#1:333,3\n*E\n"})
public class IndexStateManagementHistory
implements LocalNodeClusterManagerListener {
    @NotNull
    private final Client client;
    @NotNull
    private final ThreadPool threadPool;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final IndexManagementIndices indexManagementIndices;
    private final Logger logger;
    @Nullable
    private Scheduler.Cancellable scheduledRollover;
    private volatile Boolean historyEnabled;
    private volatile Long historyMaxDocs;
    private volatile TimeValue historyMaxAge;
    private volatile TimeValue historyRolloverCheckPeriod;
    private volatile TimeValue historyRetentionPeriod;
    private volatile Integer historyNumberOfShards;
    private volatile Integer historyNumberOfReplicas;

    public IndexStateManagementHistory(@NotNull Settings settings, @NotNull Client client, @NotNull ThreadPool threadPool, @NotNull ClusterService clusterService, @NotNull IndexManagementIndices indexManagementIndices) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)indexManagementIndices, (String)"indexManagementIndices");
        this.client = client;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.indexManagementIndices = indexManagementIndices;
        this.logger = LogManager.getLogger(this.getClass());
        this.historyEnabled = (Boolean)ManagedIndexSettings.Companion.getHISTORY_ENABLED().get(settings);
        this.historyMaxDocs = (Long)ManagedIndexSettings.Companion.getHISTORY_MAX_DOCS().get(settings);
        this.historyMaxAge = (TimeValue)ManagedIndexSettings.Companion.getHISTORY_INDEX_MAX_AGE().get(settings);
        this.historyRolloverCheckPeriod = (TimeValue)ManagedIndexSettings.Companion.getHISTORY_ROLLOVER_CHECK_PERIOD().get(settings);
        this.historyRetentionPeriod = (TimeValue)ManagedIndexSettings.Companion.getHISTORY_RETENTION_PERIOD().get(settings);
        this.historyNumberOfShards = (Integer)ManagedIndexSettings.Companion.getHISTORY_NUMBER_OF_SHARDS().get(settings);
        this.historyNumberOfReplicas = (Integer)ManagedIndexSettings.Companion.getHISTORY_NUMBER_OF_REPLICAS().get(settings);
        this.clusterService.addLocalNodeClusterManagerListener((LocalNodeClusterManagerListener)this);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getHISTORY_ENABLED(), arg_0 -> IndexStateManagementHistory._init_$lambda$0(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getHISTORY_MAX_DOCS(), arg_0 -> IndexStateManagementHistory._init_$lambda$1(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getHISTORY_INDEX_MAX_AGE(), arg_0 -> IndexStateManagementHistory._init_$lambda$2(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getHISTORY_ROLLOVER_CHECK_PERIOD(), arg_0 -> IndexStateManagementHistory._init_$lambda$3(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getHISTORY_RETENTION_PERIOD(), arg_0 -> IndexStateManagementHistory._init_$lambda$4(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getHISTORY_NUMBER_OF_SHARDS(), arg_0 -> IndexStateManagementHistory._init_$lambda$5(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getHISTORY_NUMBER_OF_REPLICAS(), arg_0 -> IndexStateManagementHistory._init_$lambda$6(this, arg_0));
    }

    public void onClusterManager() {
        try {
            Boolean bl = this.historyEnabled;
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"historyEnabled");
            if (bl.booleanValue()) {
                this.rolloverHistoryIndex();
            }
            this.scheduledRollover = this.threadPool.scheduleWithFixedDelay(() -> IndexStateManagementHistory.onClusterManager$lambda$7(this), this.historyRolloverCheckPeriod, "management");
        }
        catch (Exception e) {
            this.logger.error("Error creating ISM history index.", (Throwable)e);
        }
    }

    public void offClusterManager() {
        block0: {
            Scheduler.Cancellable cancellable = this.scheduledRollover;
            if (cancellable == null) break block0;
            cancellable.cancel();
        }
    }

    private void rescheduleRollover() {
        if (this.clusterService.state().getNodes().isLocalNodeElectedClusterManager()) {
            Scheduler.Cancellable cancellable = this.scheduledRollover;
            if (cancellable != null) {
                cancellable.cancel();
            }
            this.scheduledRollover = this.threadPool.scheduleWithFixedDelay(() -> IndexStateManagementHistory.rescheduleRollover$lambda$8(this), this.historyRolloverCheckPeriod, "management");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rolloverAndDeleteHistoryIndex() {
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            if (this.threadPool.getThreadContext().getTransient("_opendistro_security_protected_indices_conf_request") == null) {
                this.threadPool.getThreadContext().putTransient("_opendistro_security_protected_indices_conf_request", (Object)"true");
            }
            Boolean bl = this.historyEnabled;
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"historyEnabled");
            if (bl.booleanValue()) {
                this.rolloverHistoryIndex();
            }
            this.deleteOldHistoryIndex();
        }
    }

    private void rolloverHistoryIndex() {
        if (!this.indexManagementIndices.indexStateManagementIndexHistoryExists()) {
            return;
        }
        RolloverRequest request = new RolloverRequest(".opendistro-ism-managed-index-history-write", null);
        CreateIndexRequest createIndexRequest = request.getCreateIndexRequest().index("<.opendistro-ism-managed-index-history-{now/d{yyyy.MM.dd}}-1>").mapping(IndexManagementIndices.Companion.getIndexStateManagementHistoryMappings());
        Settings.Builder builder = Settings.builder().put("index.hidden", true);
        Integer n = this.historyNumberOfShards;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"historyNumberOfShards");
        Settings.Builder builder2 = builder.put("index.number_of_shards", ((Number)n).intValue());
        Integer n2 = this.historyNumberOfReplicas;
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"historyNumberOfReplicas");
        createIndexRequest.settings(builder2.put("index.number_of_replicas", ((Number)n2).intValue()));
        Long l = this.historyMaxDocs;
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"historyMaxDocs");
        request.addMaxIndexDocsCondition(((Number)l).longValue());
        request.addMaxIndexAgeCondition(this.historyMaxAge);
        this.client.admin().indices().rolloverIndex(request, (ActionListener)new ActionListener<RolloverResponse>(this){
            final /* synthetic */ IndexStateManagementHistory this$0;
            {
                this.this$0 = $receiver;
            }

            public void onResponse(@NotNull RolloverResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                if (response2.isRolledOver()) {
                    IndexStateManagementHistory.access$getLogger$p(this.this$0).info(".opendistro-ism-managed-index-history-write rolled over.");
                } else {
                    IndexStateManagementHistory.access$getLogger$p(this.this$0).info(".opendistro-ism-managed-index-history-write not rolled over. Conditions were: " + response2.getConditionStatus());
                }
            }

            public void onFailure(@NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                IndexStateManagementHistory.access$getLogger$p(this.this$0).error(".opendistro-ism-managed-index-history-write roll over failed.", (Throwable)e);
            }
        });
    }

    private void deleteOldHistoryIndex() {
        String[] stringArray = new String[]{".opendistro-ism-managed-index-history*"};
        ClusterStateRequest clusterStateRequest = ((ClusterStateRequest)new ClusterStateRequest().clear().indices(stringArray).metadata(true).local(true)).indicesOptions(IndicesOptions.strictExpand());
        this.client.admin().cluster().state(clusterStateRequest, (ActionListener)new ActionListener<ClusterStateResponse>(this){
            final /* synthetic */ IndexStateManagementHistory this$0;
            {
                this.this$0 = $receiver;
            }

            public void onResponse(@NotNull ClusterStateResponse clusterStateResponse) {
                Intrinsics.checkNotNullParameter((Object)clusterStateResponse, (String)"clusterStateResponse");
                if (!clusterStateResponse.getState().getMetadata().getIndices().isEmpty()) {
                    List indicesToDelete = IndexStateManagementHistory.access$getIndicesToDelete(this.this$0, clusterStateResponse);
                    IndexStateManagementHistory.access$getLogger$p(this.this$0).info("Deleting old history indices viz " + indicesToDelete);
                    IndexStateManagementHistory.access$deleteAllOldHistoryIndices(this.this$0, indicesToDelete);
                } else {
                    IndexStateManagementHistory.access$getLogger$p(this.this$0).info("No Old History Indices to delete");
                }
            }

            public void onFailure(@NotNull Exception exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                IndexStateManagementHistory.access$getLogger$p(this.this$0).error("Error fetching cluster state " + exception.getMessage());
            }
        });
    }

    private List<String> getIndicesToDelete(ClusterStateResponse clusterStateResponse) {
        List indicesToDelete = new ArrayList();
        Map map = clusterStateResponse.getState().getMetadata().indices();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"indices(...)");
        for (Map.Entry entry : map.entrySet()) {
            Boolean alias;
            IndexMetadata indexMetaData = (IndexMetadata)entry.getValue();
            long creationTime = indexMetaData.getCreationDate();
            if (Instant.now().toEpochMilli() - creationTime <= this.historyRetentionPeriod.getMillis()) continue;
            Map map2 = indexMetaData.getAliases();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getAliases(...)");
            Iterator iterator = map2.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry alias2 = iterator.next();
                boolean bl = false;
                v2 = Intrinsics.areEqual((Object)".opendistro-ism-managed-index-history-write", (Object)((AliasMetadata)alias2.getValue()).getAlias());
            } else {
                v2 = alias = null;
            }
            if (alias != null) {
                Boolean bl = this.historyEnabled;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"historyEnabled");
                if (bl.booleanValue()) continue;
            }
            String string = indexMetaData.getIndex().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            indicesToDelete.add(string);
        }
        return indicesToDelete;
    }

    private void deleteAllOldHistoryIndices(List<String> indicesToDelete) {
        if (!((Collection)indicesToDelete).isEmpty()) {
            Collection $this$toTypedArray$iv = indicesToDelete;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            DeleteIndexRequest deleteRequest = new DeleteIndexRequest(Arrays.copyOf(stringArray, stringArray.length));
            this.client.admin().indices().delete(deleteRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(this, indicesToDelete){
                final /* synthetic */ IndexStateManagementHistory this$0;
                final /* synthetic */ List<String> $indicesToDelete;
                {
                    this.this$0 = $receiver;
                    this.$indicesToDelete = $indicesToDelete;
                }

                public void onResponse(@NotNull AcknowledgedResponse deleteIndicesResponse) {
                    Intrinsics.checkNotNullParameter((Object)deleteIndicesResponse, (String)"deleteIndicesResponse");
                    if (!deleteIndicesResponse.isAcknowledged()) {
                        IndexStateManagementHistory.access$getLogger$p(this.this$0).error("could not delete one or more ISM history index. " + this.$indicesToDelete + ". Retrying one by one.");
                        IndexStateManagementHistory.access$deleteOldHistoryIndex(this.this$0, this.$indicesToDelete);
                    }
                }

                public void onFailure(@NotNull Exception exception) {
                    Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                    IndexStateManagementHistory.access$getLogger$p(this.this$0).error("Error deleting old history indices " + exception.getMessage());
                    IndexStateManagementHistory.access$deleteOldHistoryIndex(this.this$0, this.$indicesToDelete);
                }
            });
        }
    }

    private void deleteOldHistoryIndex(List<String> indicesToDelete) {
        for (String index2 : indicesToDelete) {
            Collection $this$toTypedArray$iv = indicesToDelete;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            DeleteIndexRequest singleDeleteRequest = new DeleteIndexRequest(Arrays.copyOf(stringArray, stringArray.length));
            this.client.admin().indices().delete(singleDeleteRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(this, index2){
                final /* synthetic */ IndexStateManagementHistory this$0;
                final /* synthetic */ String $index;
                {
                    this.this$0 = $receiver;
                    this.$index = $index;
                }

                public void onResponse(@NotNull AcknowledgedResponse singleDeleteResponse) {
                    Intrinsics.checkNotNullParameter((Object)singleDeleteResponse, (String)"singleDeleteResponse");
                    if (!singleDeleteResponse.isAcknowledged()) {
                        IndexStateManagementHistory.access$getLogger$p(this.this$0).error("could not delete one or more ISM history index. " + this.$index + ".");
                    }
                }

                public void onFailure(@NotNull Exception exception) {
                    Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                    IndexStateManagementHistory.access$getLogger$p(this.this$0).debug("Exception " + exception.getMessage() + " while deleting the index " + this.$index);
                }
            });
        }
    }

    @Nullable
    public Object addManagedIndexMetaDataHistory(@NotNull List<ManagedIndexMetaData> managedIndexMetaData, @NotNull Continuation<? super Unit> $completion) {
        return IndexStateManagementHistory.addManagedIndexMetaDataHistory$suspendImpl(this, managedIndexMetaData, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object addManagedIndexMetaDataHistory$suspendImpl(IndexStateManagementHistory var0, List<ManagedIndexMetaData> var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof addManagedIndexMetaDataHistory.1)) ** GOTO lbl-1000
        var15_3 = var2_2;
        if ((var15_3.label & -2147483648) != 0) {
            var15_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ IndexStateManagementHistory this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return IndexStateManagementHistory.addManagedIndexMetaDataHistory$suspendImpl(this.this$0, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var16_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!$this.historyEnabled.booleanValue()) {
                    $this.logger.debug("Index State Management history is not enabled");
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = $this;
                $continuation.L$1 = managedIndexMetaData;
                $continuation.label = 1;
                v0 = $this.indexManagementIndices.checkAndUpdateHistoryIndex((Continuation<? super Boolean>)$continuation);
                if (v0 == var16_5) {
                    return var16_5;
                }
                ** GOTO lbl27
            }
            case 1: {
                managedIndexMetaData = (List)$continuation.L$1;
                $this = (IndexStateManagementHistory)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    $this.logger.error("Failed to create or update the ism history index:");
                    return Unit.INSTANCE;
                }
                $this$filter$iv = managedIndexMetaData;
                $i$f$filter = false;
                var6_10 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (ManagedIndexMetaData)element$iv$iv;
                    $i$a$-filter-IndexStateManagementHistory$addManagedIndexMetaDataHistory$docWriteRequest$1 = false;
                    if (!$this.shouldAddManagedIndexMetaDataToHistory(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (ManagedIndexMetaData)item$iv$iv;
                    var13_17 = destination$iv$iv;
                    $i$a$-map-IndexStateManagementHistory$addManagedIndexMetaDataHistory$docWriteRequest$2 = false;
                    var13_17.add($this.createManagedIndexMetaDataHistoryIndexRequest(it));
                }
                docWriteRequest = (List)destination$iv$iv;
                if (!(((Collection)docWriteRequest).isEmpty() == false)) ** GOTO lbl80
                bulkRequest = new BulkRequest().add((Iterable)docWriteRequest);
                $continuation.L$0 = $this;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v1 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)$this.client, (Function2)new Function2<Client, ActionListener<BulkResponse>, Unit>(bulkRequest){
                    final /* synthetic */ BulkRequest $bulkRequest;
                    {
                        this.$bulkRequest = $bulkRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<BulkResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.bulk(this.$bulkRequest, it);
                    }
                }, $continuation);
                ** if (v1 != var16_5) goto lbl65
lbl64:
                // 1 sources

                return var16_5;
lbl65:
                // 1 sources

                ** GOTO lbl72
            }
            case 2: {
                $this = (IndexStateManagementHistory)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl72:
                    // 2 sources

                    bulkResponse = (BulkResponse)v1;
                    for (BulkItemResponse bulkItemResponse : bulkResponse) {
                        if (!bulkItemResponse.isFailed()) continue;
                        $this.logger.error("Failed to add history. Id: " + bulkItemResponse.getId() + ", failureMessage: " + bulkItemResponse.getFailureMessage());
                    }
                }
                catch (Exception e) {
                    $this.logger.error("failed to index indexMetaData History.", (Throwable)e);
                }
lbl80:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private boolean shouldAddManagedIndexMetaDataToHistory(ManagedIndexMetaData managedIndexMetaData) {
        StepMetaData stepMetaData = managedIndexMetaData.getStepMetaData();
        Object object = stepMetaData != null ? stepMetaData.getStepStatus() : null;
        return switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 1 -> false;
            case 2 -> false;
            default -> true;
        };
    }

    private IndexRequest createManagedIndexMetaDataHistoryIndexRequest(ManagedIndexMetaData managedIndexMetaData) {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("managed_index_meta_data");
        Intrinsics.checkNotNull((Object)builder);
        ToXContent.Params params = ToXContent.EMPTY_PARAMS;
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"EMPTY_PARAMS");
        managedIndexMetaData.toXContent(builder, params);
        builder.field("history_timestamp", Instant.now().toEpochMilli()).endObject().endObject();
        IndexRequest indexRequest = new IndexRequest(".opendistro-ism-managed-index-history-write").source(builder);
        Intrinsics.checkNotNullExpressionValue((Object)indexRequest, (String)"source(...)");
        return indexRequest;
    }

    private static final void _init_$lambda$0(IndexStateManagementHistory this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.historyEnabled = it;
    }

    private static final void _init_$lambda$1(IndexStateManagementHistory this$0, Long it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.historyMaxDocs = it;
    }

    private static final void _init_$lambda$2(IndexStateManagementHistory this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.historyMaxAge = it;
    }

    private static final void _init_$lambda$3(IndexStateManagementHistory this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.historyRolloverCheckPeriod = it;
        this$0.rescheduleRollover();
    }

    private static final void _init_$lambda$4(IndexStateManagementHistory this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.historyRetentionPeriod = it;
    }

    private static final void _init_$lambda$5(IndexStateManagementHistory this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.historyNumberOfShards = it;
    }

    private static final void _init_$lambda$6(IndexStateManagementHistory this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.historyNumberOfReplicas = it;
    }

    private static final void onClusterManager$lambda$7(IndexStateManagementHistory this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.rolloverAndDeleteHistoryIndex();
    }

    private static final void rescheduleRollover$lambda$8(IndexStateManagementHistory this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.rolloverAndDeleteHistoryIndex();
    }

    public static final /* synthetic */ Logger access$getLogger$p(IndexStateManagementHistory $this) {
        return $this.logger;
    }

    public static final /* synthetic */ List access$getIndicesToDelete(IndexStateManagementHistory $this, ClusterStateResponse clusterStateResponse) {
        return $this.getIndicesToDelete(clusterStateResponse);
    }

    public static final /* synthetic */ void access$deleteAllOldHistoryIndices(IndexStateManagementHistory $this, List indicesToDelete) {
        $this.deleteAllOldHistoryIndices(indicesToDelete);
    }

    public static final /* synthetic */ void access$deleteOldHistoryIndex(IndexStateManagementHistory $this, List indicesToDelete) {
        $this.deleteOldHistoryIndex(indicesToDelete);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Step.StepStatus.values().length];
            try {
                nArray[Step.StepStatus.STARTING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Step.StepStatus.CONDITION_NOT_MET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

