/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.controlcenter.notification.action.index;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.indexmanagement.controlcenter.notification.ControlCenterIndices;
import org.opensearch.indexmanagement.controlcenter.notification.LRONConfigResponse;
import org.opensearch.indexmanagement.controlcenter.notification.action.index.IndexLRONConfigRequest;
import org.opensearch.indexmanagement.controlcenter.notification.action.index.TransportIndexLRONConfigAction;
import org.opensearch.indexmanagement.controlcenter.notification.model.LRONConfig;
import org.opensearch.indexmanagement.controlcenter.notification.util.LRONUtils;
import org.opensearch.indexmanagement.util.SecurityUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001#B7\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J&\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00022\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\"H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006$"}, d2={"Lorg/opensearch/indexmanagement/controlcenter/notification/action/index/TransportIndexLRONConfigAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/indexmanagement/controlcenter/notification/action/index/IndexLRONConfigRequest;", "Lorg/opensearch/indexmanagement/controlcenter/notification/LRONConfigResponse;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "transportService", "Lorg/opensearch/transport/TransportService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "controlCenterIndices", "Lorg/opensearch/indexmanagement/controlcenter/notification/ControlCenterIndices;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "(Lorg/opensearch/transport/client/node/NodeClient;Lorg/opensearch/transport/TransportService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/indexmanagement/controlcenter/notification/ControlCenterIndices;Lorg/opensearch/core/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/opensearch/transport/client/node/NodeClient;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "getControlCenterIndices", "()Lorg/opensearch/indexmanagement/controlcenter/notification/ControlCenterIndices;", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "listener", "Lorg/opensearch/core/action/ActionListener;", "IndexLRONConfigHandler", "opensearch-index-management"})
public final class TransportIndexLRONConfigAction
extends HandledTransportAction<IndexLRONConfigRequest, LRONConfigResponse> {
    @NotNull
    private final NodeClient client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final ControlCenterIndices controlCenterIndices;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    private final Logger log;

    @Inject
    public TransportIndexLRONConfigAction(@NotNull NodeClient client, @NotNull TransportService transportService, @NotNull ActionFilters actionFilters, @NotNull ClusterService clusterService, @NotNull ControlCenterIndices controlCenterIndices, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)controlCenterIndices, (String)"controlCenterIndices");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        super("cluster:admin/opensearch/controlcenter/lron/write", transportService, actionFilters, IndexLRONConfigRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.controlCenterIndices = controlCenterIndices;
        this.xContentRegistry = xContentRegistry;
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
    }

    @NotNull
    public final NodeClient getClient() {
        return this.client;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final ControlCenterIndices getControlCenterIndices() {
        return this.controlCenterIndices;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    protected void doExecute(@NotNull Task task, @NotNull IndexLRONConfigRequest request, @NotNull ActionListener<LRONConfigResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        new IndexLRONConfigHandler(this, this.client, listener, request, null, null, 24, null).start();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0002J\u0006\u0010\u0013\u001a\u00020\u000fJ\b\u0010\u0014\u001a\u00020\u000fH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/opensearch/indexmanagement/controlcenter/notification/action/index/TransportIndexLRONConfigAction$IndexLRONConfigHandler;", "", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "Lorg/opensearch/indexmanagement/controlcenter/notification/LRONConfigResponse;", "request", "Lorg/opensearch/indexmanagement/controlcenter/notification/action/index/IndexLRONConfigRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "docId", "", "(Lorg/opensearch/indexmanagement/controlcenter/notification/action/index/TransportIndexLRONConfigAction;Lorg/opensearch/transport/client/node/NodeClient;Lorg/opensearch/core/action/ActionListener;Lorg/opensearch/indexmanagement/controlcenter/notification/action/index/IndexLRONConfigRequest;Lorg/opensearch/commons/authuser/User;Ljava/lang/String;)V", "onCreateMappingsResponse", "", "response", "Lorg/opensearch/action/support/clustermanager/AcknowledgedResponse;", "putLRONConfig", "start", "validate", "opensearch-index-management"})
    public final class IndexLRONConfigHandler {
        @NotNull
        private final NodeClient client;
        @NotNull
        private final ActionListener<LRONConfigResponse> actionListener;
        @NotNull
        private final IndexLRONConfigRequest request;
        @Nullable
        private final User user;
        @NotNull
        private final String docId;
        final /* synthetic */ TransportIndexLRONConfigAction this$0;

        public IndexLRONConfigHandler(@NotNull TransportIndexLRONConfigAction this$0, @NotNull NodeClient client, @NotNull ActionListener<LRONConfigResponse> actionListener, @Nullable IndexLRONConfigRequest request, @NotNull User user, String docId2) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
            Intrinsics.checkNotNullParameter((Object)docId2, (String)"docId");
            this.this$0 = this$0;
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = user;
            this.docId = docId2;
        }

        public /* synthetic */ IndexLRONConfigHandler(TransportIndexLRONConfigAction transportIndexLRONConfigAction, NodeClient nodeClient, ActionListener actionListener, IndexLRONConfigRequest indexLRONConfigRequest, User user, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                ThreadContext threadContext = nodeClient.threadPool().getThreadContext();
                Intrinsics.checkNotNullExpressionValue((Object)threadContext, (String)"getThreadContext(...)");
                user = SecurityUtils.Companion.buildUser$default(SecurityUtils.Companion, threadContext, null, 2, null);
            }
            if ((n & 0x10) != 0) {
                string = LRONUtils.getDocID(indexLRONConfigRequest.getLronConfig().getTaskId(), indexLRONConfigRequest.getLronConfig().getActionName());
            }
            this(transportIndexLRONConfigAction, nodeClient, (ActionListener<LRONConfigResponse>)actionListener, indexLRONConfigRequest, user, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void start() {
            this.this$0.log.debug("User and roles string from thread context: " + this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
            TransportIndexLRONConfigAction transportIndexLRONConfigAction = this.this$0;
            Throwable throwable = null;
            try {
                ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
                boolean bl = false;
                if (this.request.getDryRun()) {
                    this.validate();
                    return;
                }
                ControlCenterIndices controlCenterIndices = transportIndexLRONConfigAction.getControlCenterIndices();
                ActionListener actionListener = ActionListener.wrap(this::onCreateMappingsResponse, arg_0 -> this.actionListener.onFailure(arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)actionListener, (String)"wrap(...)");
                controlCenterIndices.checkAndUpdateControlCenterIndex((ActionListener<AcknowledgedResponse>)actionListener);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        private final void onCreateMappingsResponse(AcknowledgedResponse response2) {
            if (response2.isAcknowledged()) {
                this.this$0.log.info("Successfully created or updated .opensearch-control-center with newest mappings.");
                this.validate();
            } else {
                String message = "Unable to create or update .opensearch-control-center with newest mapping.";
                this.this$0.log.error(message);
                this.actionListener.onFailure((Exception)new OpenSearchStatusException(message, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }
        }

        private final void validate() {
            if (this.request.getLronConfig().getTaskId() != null && this.this$0.getClusterService().state().getNodes().get(this.request.getLronConfig().getTaskId().getNodeId()) == null) {
                this.actionListener.onFailure((Exception)new IllegalArgumentException("Illegal taskID. NodeID not exists."));
                return;
            }
            this.putLRONConfig();
        }

        private final void putLRONConfig() {
            LRONConfig lronConfig2 = LRONConfig.copy$default(this.request.getLronConfig(), null, null, null, null, this.user, LRONUtils.getPriority(this.request.getLronConfig().getTaskId(), this.request.getLronConfig().getActionName()), 15, null);
            if (this.request.getDryRun()) {
                this.actionListener.onResponse((Object)new LRONConfigResponse(this.docId, lronConfig2));
                return;
            }
            IndexRequest indexRequest = (IndexRequest)new IndexRequest(".opensearch-control-center").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder(...)");
            IndexRequest indexRequest2 = (IndexRequest)indexRequest.source(lronConfig2.toXContent(xContentBuilder)).id(this.docId).timeout(IndexRequest.DEFAULT_TIMEOUT);
            if (!this.request.isUpdate()) {
                indexRequest2.opType(DocWriteRequest.OpType.CREATE);
            }
            this.client.index(indexRequest2, (ActionListener)new ActionListener<IndexResponse>(this, lronConfig2){
                final /* synthetic */ IndexLRONConfigHandler this$0;
                final /* synthetic */ LRONConfig $lronConfig;
                {
                    this.this$0 = $receiver;
                    this.$lronConfig = $lronConfig;
                }

                public void onResponse(@NotNull IndexResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    if (response2.getShardInfo().getFailed() > 0) {
                        ReplicationResponse.ShardInfo.Failure[] failureArray = response2.getShardInfo().getFailures();
                        Intrinsics.checkNotNullExpressionValue((Object)failureArray, (String)"getFailures(...)");
                        String failureReasons2 = ArraysKt.joinToString$default((Object[])failureArray, (CharSequence)",", null, null, (int)0, null, (Function1)putLRONConfig.onResponse.failureReasons.1.INSTANCE, (int)30, null);
                        IndexLRONConfigHandler.access$getActionListener$p(this.this$0).onFailure((Exception)new OpenSearchStatusException(failureReasons2, response2.status(), new Object[0]));
                    } else {
                        ActionListener actionListener = IndexLRONConfigHandler.access$getActionListener$p(this.this$0);
                        String string = response2.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                        actionListener.onResponse((Object)((Object)new LRONConfigResponse(string, this.$lronConfig)));
                    }
                }

                public void onFailure(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ActionListener actionListener = IndexLRONConfigHandler.access$getActionListener$p(this.this$0);
                    Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)e);
                    Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    actionListener.onFailure((Exception)throwable);
                }
            });
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(IndexLRONConfigHandler $this) {
            return $this.actionListener;
        }
    }
}

