/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.ip2geo.dao;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.SpecialPermission;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.cluster.routing.Preference;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.geospatial.annotation.VisibleForTesting;
import org.opensearch.geospatial.ip2geo.common.DatasourceManifest;
import org.opensearch.geospatial.ip2geo.common.Ip2GeoSettings;
import org.opensearch.geospatial.ip2geo.common.URLDenyListChecker;
import org.opensearch.geospatial.ip2geo.dao.DatasourceDao;
import org.opensearch.geospatial.shared.Constants;
import org.opensearch.geospatial.shared.StashedThreadContext;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.Requests;

public class GeoIpDataDao {
    @Generated
    private static final Logger log = LogManager.getLogger(GeoIpDataDao.class);
    private static final String IP_RANGE_FIELD_NAME = "_cidr";
    private static final String DATA_FIELD_NAME = "_data";
    private static final Map<String, Object> INDEX_SETTING_TO_CREATE = Map.of("index.number_of_shards", 1, "index.number_of_replicas", 0, "index.refresh_interval", -1, "index.hidden", true);
    private static final Map<String, Object> INDEX_SETTING_TO_FREEZE = Map.of("index.auto_expand_replicas", "0-all", "index.blocks.write", true);
    private final ClusterService clusterService;
    private final ClusterSettings clusterSettings;
    private final Client client;
    private final URLDenyListChecker urlDenyListChecker;

    public GeoIpDataDao(ClusterService clusterService, Client client, URLDenyListChecker urlDenyListChecker) {
        this.clusterService = clusterService;
        this.clusterSettings = clusterService.getClusterSettings();
        this.client = client;
        this.urlDenyListChecker = urlDenyListChecker;
    }

    public void createIndexIfNotExists(String indexName) {
        if (this.clusterService.state().metadata().hasIndex(indexName)) {
            return;
        }
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName).settings(INDEX_SETTING_TO_CREATE).mapping(this.getIndexMapping());
        StashedThreadContext.run(this.client, () -> (CreateIndexResponse)this.client.admin().indices().create(createIndexRequest).actionGet((TimeValue)this.clusterSettings.get(Ip2GeoSettings.TIMEOUT)));
    }

    private void freezeIndex(String indexName) {
        TimeValue timeout = (TimeValue)this.clusterSettings.get(Ip2GeoSettings.TIMEOUT);
        StashedThreadContext.run(this.client, () -> {
            this.client.admin().indices().prepareForceMerge(new String[]{indexName}).setMaxNumSegments(1).execute().actionGet(timeout);
            this.client.admin().indices().prepareRefresh(new String[]{indexName}).execute().actionGet(timeout);
            this.client.admin().indices().prepareUpdateSettings(new String[]{indexName}).setSettings(INDEX_SETTING_TO_FREEZE).execute().actionGet((TimeValue)this.clusterSettings.get(Ip2GeoSettings.TIMEOUT));
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getIndexMapping() {
        try (InputStream is = DatasourceDao.class.getResourceAsStream("/mappings/ip2geo_geoip.json");){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                string = reader.lines().map(String::trim).collect(Collectors.joining());
            }
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @SuppressForbidden(reason="Need to connect to http endpoint to read GeoIP database file")
    public CSVParser getDatabaseReader(DatasourceManifest manifest) {
        SpecialPermission.check();
        return AccessController.doPrivileged(() -> {
            try {
                URL zipUrl = this.urlDenyListChecker.toUrlIfNotInDenyList(manifest.getUrl());
                return this.internalGetDatabaseReader(manifest, zipUrl.openConnection());
            }
            catch (IOException e) {
                throw new OpenSearchException("failed to read geoip data from {}", new Object[]{manifest.getUrl(), e});
            }
        });
    }

    @VisibleForTesting
    @SuppressForbidden(reason="Need to connect to http endpoint to read GeoIP database file")
    protected CSVParser internalGetDatabaseReader(DatasourceManifest manifest, URLConnection connection) throws IOException {
        connection.addRequestProperty("User-Agent", Constants.USER_AGENT_VALUE);
        ZipInputStream zipIn = new ZipInputStream(connection.getInputStream());
        ZipEntry zipEntry = zipIn.getNextEntry();
        while (zipEntry != null) {
            if (!zipEntry.getName().equalsIgnoreCase(manifest.getDbName())) {
                zipEntry = zipIn.getNextEntry();
                continue;
            }
            return new CSVParser((Reader)new BufferedReader(new InputStreamReader(zipIn)), CSVFormat.RFC4180);
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "database file [%s] does not exist in the zip file [%s]", manifest.getDbName(), manifest.getUrl()));
    }

    public XContentBuilder createDocument(String[] fields, String[] values) throws IOException {
        if (fields.length != values.length) {
            throw new OpenSearchException("header[{}] and record[{}] length does not match", new Object[]{fields, values});
        }
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        builder.field(IP_RANGE_FIELD_NAME, values[0]);
        builder.startObject(DATA_FIELD_NAME);
        for (int i = 1; i < fields.length; ++i) {
            if (!Strings.hasText((String)values[i])) continue;
            builder.field(fields[i], values[i]);
        }
        builder.endObject();
        builder.endObject();
        builder.close();
        return builder;
    }

    public Map<String, Object> getGeoIpData(String indexName, String ip) {
        SearchResponse response = StashedThreadContext.run(this.client, () -> (SearchResponse)this.client.prepareSearch(new String[]{indexName}).setSize(1).setQuery((QueryBuilder)QueryBuilders.termQuery((String)IP_RANGE_FIELD_NAME, (String)ip)).setPreference(Preference.LOCAL.type()).setRequestCache(Boolean.valueOf(true)).get((TimeValue)this.clusterSettings.get(Ip2GeoSettings.TIMEOUT)));
        if (response.getHits().getHits().length == 0) {
            return Collections.emptyMap();
        }
        return (Map)((Map)XContentHelper.convertToMap((BytesReference)response.getHits().getAt(0).getSourceRef(), (boolean)false, (XContentType)XContentType.JSON).v2()).get(DATA_FIELD_NAME);
    }

    public void putGeoIpData(@NonNull String indexName, @NonNull String[] fields, @NonNull Iterator<CSVRecord> iterator, @NonNull Runnable renewLock) throws IOException {
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        if (iterator == null) {
            throw new NullPointerException("iterator is marked non-null but is null");
        }
        if (renewLock == null) {
            throw new NullPointerException("renewLock is marked non-null but is null");
        }
        TimeValue timeout = (TimeValue)this.clusterSettings.get(Ip2GeoSettings.TIMEOUT);
        Integer batchSize = (Integer)this.clusterSettings.get(Ip2GeoSettings.BATCH_SIZE);
        BulkRequest bulkRequest = new BulkRequest();
        LinkedList<IndexRequest> requests = new LinkedList<IndexRequest>();
        for (int i = 0; i < batchSize; ++i) {
            requests.add(Requests.indexRequest((String)indexName));
        }
        while (iterator.hasNext()) {
            CSVRecord record = iterator.next();
            XContentBuilder document = this.createDocument(fields, record.values());
            IndexRequest indexRequest = (IndexRequest)requests.poll();
            indexRequest.source(document);
            indexRequest.id(record.get(0));
            bulkRequest.add(indexRequest);
            if (!iterator.hasNext() || bulkRequest.requests().size() == batchSize.intValue()) {
                BulkResponse response = StashedThreadContext.run(this.client, () -> (BulkResponse)this.client.bulk(bulkRequest).actionGet(timeout));
                if (response.hasFailures()) {
                    throw new OpenSearchException("error occurred while ingesting GeoIP data in {} with an error {}", new Object[]{indexName, response.buildFailureMessage()});
                }
                requests.addAll(bulkRequest.requests());
                bulkRequest.requests().clear();
            }
            renewLock.run();
        }
        this.freezeIndex(indexName);
    }

    public void deleteIp2GeoDataIndex(String index) {
        this.deleteIp2GeoDataIndex(Arrays.asList(index));
    }

    public void deleteIp2GeoDataIndex(List<String> indices) {
        if (indices == null || indices.isEmpty()) {
            return;
        }
        Optional<String> invalidIndex = indices.stream().filter(index -> !index.startsWith(".geospatial-ip2geo-data")).findAny();
        if (invalidIndex.isPresent()) {
            throw new OpenSearchException("the index[{}] is not ip2geo data index which should start with {}", new Object[]{invalidIndex.get(), ".geospatial-ip2geo-data"});
        }
        AcknowledgedResponse response = StashedThreadContext.run(this.client, () -> (AcknowledgedResponse)this.client.admin().indices().prepareDelete(indices.toArray(new String[0])).setIndicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED_HIDDEN).execute().actionGet((TimeValue)this.clusterSettings.get(Ip2GeoSettings.TIMEOUT)));
        if (!response.isAcknowledged()) {
            throw new OpenSearchException("failed to delete data[{}] in datasource", new Object[]{String.join((CharSequence)",", indices)});
        }
    }
}

