/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.utils;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.ParseMethod;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.parse.GrokExpression;
import org.opensearch.sql.expression.parse.ParseExpression;
import org.opensearch.sql.expression.parse.RegexExpression;
import shaded.com.google.common.collect.ImmutableMap;

public final class ParseUtils {
    private static final String NEW_FIELD_KEY = "new_field";
    private static final Map<ParseMethod, ParseExpressionFactory> FACTORY_MAP = ImmutableMap.of((Object)((Object)ParseMethod.REGEX), RegexExpression::new, (Object)((Object)ParseMethod.GROK), GrokExpression::new);

    public static ParseExpression createParseExpression(ParseMethod parseMethod, Expression sourceField, Expression pattern, Expression identifier) {
        return FACTORY_MAP.get((Object)parseMethod).initialize(sourceField, pattern, identifier);
    }

    public static List<String> getNamedGroupCandidates(ParseMethod parseMethod, String pattern, Map<String, Literal> arguments) {
        switch (parseMethod) {
            case REGEX: {
                return RegexExpression.getNamedGroupCandidates(pattern);
            }
        }
        return GrokExpression.getNamedGroupCandidates(pattern);
    }

    @Generated
    private ParseUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static interface ParseExpressionFactory {
        public ParseExpression initialize(Expression var1, Expression var2, Expression var3);
    }
}

