/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ppl.parser;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.opensearch.sql.ast.dsl.AstDSL;
import org.opensearch.sql.ast.expression.AggregateFunction;
import org.opensearch.sql.ast.expression.Alias;
import org.opensearch.sql.ast.expression.AllFields;
import org.opensearch.sql.ast.expression.And;
import org.opensearch.sql.ast.expression.Between;
import org.opensearch.sql.ast.expression.Cast;
import org.opensearch.sql.ast.expression.Compare;
import org.opensearch.sql.ast.expression.DataType;
import org.opensearch.sql.ast.expression.EqualTo;
import org.opensearch.sql.ast.expression.Field;
import org.opensearch.sql.ast.expression.Function;
import org.opensearch.sql.ast.expression.In;
import org.opensearch.sql.ast.expression.Interval;
import org.opensearch.sql.ast.expression.IntervalUnit;
import org.opensearch.sql.ast.expression.Let;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.Not;
import org.opensearch.sql.ast.expression.Or;
import org.opensearch.sql.ast.expression.QualifiedName;
import org.opensearch.sql.ast.expression.RelevanceFieldList;
import org.opensearch.sql.ast.expression.Span;
import org.opensearch.sql.ast.expression.SpanUnit;
import org.opensearch.sql.ast.expression.UnresolvedArgument;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.expression.Xor;
import org.opensearch.sql.ast.expression.subquery.ExistsSubquery;
import org.opensearch.sql.ast.expression.subquery.InSubquery;
import org.opensearch.sql.ast.expression.subquery.ScalarSubquery;
import org.opensearch.sql.ast.tree.Trendline;
import org.opensearch.sql.common.antlr.SyntaxCheckException;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.ppl.antlr.parser.OpenSearchPPLParser;
import org.opensearch.sql.ppl.antlr.parser.OpenSearchPPLParserBaseVisitor;
import org.opensearch.sql.ppl.parser.AstBuilder;
import org.opensearch.sql.ppl.utils.ArgumentFactory;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableMap;

public class AstExpressionBuilder
extends OpenSearchPPLParserBaseVisitor<UnresolvedExpression> {
    private static final int DEFAULT_TAKE_FUNCTION_SIZE_VALUE = 10;
    private static final Map<String, String> FUNCTION_NAME_MAPPING = new ImmutableMap.Builder().put((Object)"isnull", (Object)BuiltinFunctionName.IS_NULL.getName().getFunctionName()).put((Object)"isnotnull", (Object)BuiltinFunctionName.IS_NOT_NULL.getName().getFunctionName()).build();
    private final AstBuilder astBuilder;

    public AstExpressionBuilder(AstBuilder astBuilder) {
        this.astBuilder = astBuilder;
    }

    @Override
    public UnresolvedExpression visitEvalClause(OpenSearchPPLParser.EvalClauseContext ctx) {
        return new Let((Field)this.visit((ParseTree)ctx.fieldExpression()), (UnresolvedExpression)this.visit((ParseTree)ctx.expression()));
    }

    @Override
    public Trendline.TrendlineComputation visitTrendlineClause(OpenSearchPPLParser.TrendlineClauseContext ctx) {
        int numberOfDataPoints = Integer.parseInt(ctx.numberOfDataPoints.getText());
        if (numberOfDataPoints < 1) {
            throw new SyntaxCheckException("Number of trendline data-points must be greater than or equal to 1");
        }
        Field dataField = (Field)this.visitFieldExpression(ctx.field);
        String alias = ctx.alias != null ? ctx.alias.getText() : dataField.getChild().get(0).toString() + "_trendline";
        Trendline.TrendlineType computationType = Trendline.TrendlineType.valueOf(ctx.trendlineType().getText().toUpperCase(Locale.ROOT));
        return new Trendline.TrendlineComputation(numberOfDataPoints, dataField, alias, computationType);
    }

    @Override
    public UnresolvedExpression visitLogicalNot(OpenSearchPPLParser.LogicalNotContext ctx) {
        return new Not((UnresolvedExpression)this.visit((ParseTree)ctx.logicalExpression()));
    }

    @Override
    public UnresolvedExpression visitLogicalOr(OpenSearchPPLParser.LogicalOrContext ctx) {
        return new Or((UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public UnresolvedExpression visitLogicalAnd(OpenSearchPPLParser.LogicalAndContext ctx) {
        return new And((UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public UnresolvedExpression visitLogicalXor(OpenSearchPPLParser.LogicalXorContext ctx) {
        return new Xor((UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public UnresolvedExpression visitCompareExpr(OpenSearchPPLParser.CompareExprContext ctx) {
        return new Compare(ctx.comparisonOperator().getText(), (UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public UnresolvedExpression visitInExpr(OpenSearchPPLParser.InExprContext ctx) {
        In expr = new In((UnresolvedExpression)this.visit((ParseTree)ctx.valueExpression()), ctx.valueList().literalValue().stream().map(this::visitLiteralValue).collect(Collectors.toList()));
        return ctx.NOT() != null ? new Not(expr) : expr;
    }

    @Override
    public UnresolvedExpression visitBinaryArithmetic(OpenSearchPPLParser.BinaryArithmeticContext ctx) {
        return new Function(ctx.binaryOperator.getText(), Arrays.asList((UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right)));
    }

    @Override
    public UnresolvedExpression visitParentheticValueExpr(OpenSearchPPLParser.ParentheticValueExprContext ctx) {
        return (UnresolvedExpression)this.visit((ParseTree)ctx.valueExpression());
    }

    @Override
    public UnresolvedExpression visitParentheticLogicalExpr(OpenSearchPPLParser.ParentheticLogicalExprContext ctx) {
        return (UnresolvedExpression)this.visit((ParseTree)ctx.logicalExpression());
    }

    @Override
    public UnresolvedExpression visitFieldExpression(OpenSearchPPLParser.FieldExpressionContext ctx) {
        return new Field((QualifiedName)this.visit((ParseTree)ctx.qualifiedName()));
    }

    @Override
    public UnresolvedExpression visitWcFieldExpression(OpenSearchPPLParser.WcFieldExpressionContext ctx) {
        return new Field((QualifiedName)this.visit((ParseTree)ctx.wcQualifiedName()));
    }

    @Override
    public UnresolvedExpression visitSortField(OpenSearchPPLParser.SortFieldContext ctx) {
        return new Field((UnresolvedExpression)this.visit((ParseTree)ctx.sortFieldExpression().fieldExpression().qualifiedName()), ArgumentFactory.getArgumentList(ctx));
    }

    @Override
    public UnresolvedExpression visitStatsFunctionCall(OpenSearchPPLParser.StatsFunctionCallContext ctx) {
        return new AggregateFunction(ctx.statsFunctionName().getText(), (UnresolvedExpression)this.visit((ParseTree)ctx.valueExpression()));
    }

    @Override
    public UnresolvedExpression visitCountAllFunctionCall(OpenSearchPPLParser.CountAllFunctionCallContext ctx) {
        return new AggregateFunction("count", AllFields.of());
    }

    @Override
    public UnresolvedExpression visitDistinctCountFunctionCall(OpenSearchPPLParser.DistinctCountFunctionCallContext ctx) {
        return new AggregateFunction("count", (UnresolvedExpression)this.visit((ParseTree)ctx.valueExpression()), true);
    }

    @Override
    public UnresolvedExpression visitPercentileApproxFunctionCall(OpenSearchPPLParser.PercentileApproxFunctionCallContext ctx) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new UnresolvedArgument("percent", (UnresolvedExpression)this.visit((ParseTree)ctx.percentileApproxFunction().percent)));
        if (ctx.percentileApproxFunction().compression != null) {
            builder.add((Object)new UnresolvedArgument("compression", (UnresolvedExpression)this.visit((ParseTree)ctx.percentileApproxFunction().compression)));
        }
        return new AggregateFunction("percentile", (UnresolvedExpression)this.visit((ParseTree)ctx.percentileApproxFunction().aggField), (List<UnresolvedExpression>)builder.build());
    }

    @Override
    public UnresolvedExpression visitTakeAggFunctionCall(OpenSearchPPLParser.TakeAggFunctionCallContext ctx) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new UnresolvedArgument("size", ctx.takeAggFunction().size != null ? (UnresolvedExpression)this.visit((ParseTree)ctx.takeAggFunction().size) : AstDSL.intLiteral(10)));
        return new AggregateFunction("take", (UnresolvedExpression)this.visit((ParseTree)ctx.takeAggFunction().fieldExpression()), (List<UnresolvedExpression>)builder.build());
    }

    @Override
    public UnresolvedExpression visitBooleanFunctionCall(OpenSearchPPLParser.BooleanFunctionCallContext ctx) {
        String functionName = ctx.conditionFunctionName().getText().toLowerCase();
        return this.buildFunction(FUNCTION_NAME_MAPPING.getOrDefault(functionName, functionName), ctx.functionArgs().functionArg());
    }

    @Override
    public UnresolvedExpression visitEvalFunctionCall(OpenSearchPPLParser.EvalFunctionCallContext ctx) {
        return this.buildFunction(ctx.evalFunctionName().getText(), ctx.functionArgs().functionArg());
    }

    @Override
    public UnresolvedExpression visitDataTypeFunctionCall(OpenSearchPPLParser.DataTypeFunctionCallContext ctx) {
        return new Cast((UnresolvedExpression)this.visit((ParseTree)ctx.expression()), (UnresolvedExpression)this.visit((ParseTree)ctx.convertedDataType()));
    }

    @Override
    public UnresolvedExpression visitConvertedDataType(OpenSearchPPLParser.ConvertedDataTypeContext ctx) {
        return AstDSL.stringLiteral(ctx.getText());
    }

    private Function buildFunction(String functionName, List<OpenSearchPPLParser.FunctionArgContext> args) {
        return new Function(functionName, args.stream().map(this::visitFunctionArg).collect(Collectors.toList()));
    }

    @Override
    public UnresolvedExpression visitSingleFieldRelevanceFunction(OpenSearchPPLParser.SingleFieldRelevanceFunctionContext ctx) {
        return new Function(ctx.singleFieldRelevanceFunctionName().getText().toLowerCase(), this.singleFieldRelevanceArguments(ctx));
    }

    @Override
    public UnresolvedExpression visitMultiFieldRelevanceFunction(OpenSearchPPLParser.MultiFieldRelevanceFunctionContext ctx) {
        return new Function(ctx.multiFieldRelevanceFunctionName().getText().toLowerCase(), this.multiFieldRelevanceArguments(ctx));
    }

    @Override
    public UnresolvedExpression visitTableSource(OpenSearchPPLParser.TableSourceContext ctx) {
        if (ctx.getChild(0) instanceof OpenSearchPPLParser.IdentsAsTableQualifiedNameContext) {
            return this.visitIdentsAsTableQualifiedName((OpenSearchPPLParser.IdentsAsTableQualifiedNameContext)ctx.getChild(0));
        }
        return this.visitIdentifiers(Arrays.asList(ctx));
    }

    @Override
    public UnresolvedExpression visitPositionFunction(OpenSearchPPLParser.PositionFunctionContext ctx) {
        return new Function(BuiltinFunctionName.POSITION.getName().getFunctionName(), Arrays.asList((UnresolvedExpression)this.visitFunctionArg(ctx.functionArg(0)), (UnresolvedExpression)this.visitFunctionArg(ctx.functionArg(1))));
    }

    @Override
    public UnresolvedExpression visitExtractFunctionCall(OpenSearchPPLParser.ExtractFunctionCallContext ctx) {
        return new Function(ctx.extractFunction().EXTRACT().toString(), this.getExtractFunctionArguments(ctx));
    }

    private List<UnresolvedExpression> getExtractFunctionArguments(OpenSearchPPLParser.ExtractFunctionCallContext ctx) {
        List<UnresolvedExpression> args = Arrays.asList(new Literal(ctx.extractFunction().datetimePart().getText(), DataType.STRING), (UnresolvedExpression)this.visitFunctionArg(ctx.extractFunction().functionArg()));
        return args;
    }

    @Override
    public UnresolvedExpression visitGetFormatFunctionCall(OpenSearchPPLParser.GetFormatFunctionCallContext ctx) {
        return new Function(ctx.getFormatFunction().GET_FORMAT().toString(), this.getFormatFunctionArguments(ctx));
    }

    private List<UnresolvedExpression> getFormatFunctionArguments(OpenSearchPPLParser.GetFormatFunctionCallContext ctx) {
        List<UnresolvedExpression> args = Arrays.asList(new Literal(ctx.getFormatFunction().getFormatType().getText(), DataType.STRING), (UnresolvedExpression)this.visitFunctionArg(ctx.getFormatFunction().functionArg()));
        return args;
    }

    @Override
    public UnresolvedExpression visitTimestampFunctionCall(OpenSearchPPLParser.TimestampFunctionCallContext ctx) {
        return new Function(ctx.timestampFunction().timestampFunctionName().getText(), this.timestampFunctionArguments(ctx));
    }

    private List<UnresolvedExpression> timestampFunctionArguments(OpenSearchPPLParser.TimestampFunctionCallContext ctx) {
        List<UnresolvedExpression> args = Arrays.asList(new Literal(ctx.timestampFunction().simpleDateTimePart().getText(), DataType.STRING), (UnresolvedExpression)this.visitFunctionArg(ctx.timestampFunction().firstArg), (UnresolvedExpression)this.visitFunctionArg(ctx.timestampFunction().secondArg));
        return args;
    }

    @Override
    public UnresolvedExpression visitIdentsAsQualifiedName(OpenSearchPPLParser.IdentsAsQualifiedNameContext ctx) {
        return this.visitIdentifiers(ctx.ident());
    }

    @Override
    public UnresolvedExpression visitIdentsAsTableQualifiedName(OpenSearchPPLParser.IdentsAsTableQualifiedNameContext ctx) {
        return this.visitIdentifiers(Stream.concat(Stream.of(ctx.tableIdent()), ctx.ident().stream()).collect(Collectors.toList()));
    }

    @Override
    public UnresolvedExpression visitIdentsAsWildcardQualifiedName(OpenSearchPPLParser.IdentsAsWildcardQualifiedNameContext ctx) {
        return this.visitIdentifiers(ctx.wildcard());
    }

    @Override
    public UnresolvedExpression visitIntervalLiteral(OpenSearchPPLParser.IntervalLiteralContext ctx) {
        return new Interval((UnresolvedExpression)this.visit((ParseTree)ctx.valueExpression()), IntervalUnit.of(ctx.intervalUnit().getText()));
    }

    @Override
    public UnresolvedExpression visitStringLiteral(OpenSearchPPLParser.StringLiteralContext ctx) {
        return new Literal(StringUtils.unquoteText(ctx.getText()), DataType.STRING);
    }

    @Override
    public UnresolvedExpression visitIntegerLiteral(OpenSearchPPLParser.IntegerLiteralContext ctx) {
        long number = Long.parseLong(ctx.getText());
        if (Integer.MIN_VALUE <= number && number <= Integer.MAX_VALUE) {
            return new Literal((int)number, DataType.INTEGER);
        }
        return new Literal(number, DataType.LONG);
    }

    @Override
    public UnresolvedExpression visitDecimalLiteral(OpenSearchPPLParser.DecimalLiteralContext ctx) {
        return new Literal(Double.valueOf(ctx.getText()), DataType.DOUBLE);
    }

    @Override
    public UnresolvedExpression visitBooleanLiteral(OpenSearchPPLParser.BooleanLiteralContext ctx) {
        return new Literal(Boolean.valueOf(ctx.getText()), DataType.BOOLEAN);
    }

    @Override
    public UnresolvedExpression visitBySpanClause(OpenSearchPPLParser.BySpanClauseContext ctx) {
        String name = ctx.spanClause().getText();
        return ctx.alias != null ? new Alias(StringUtils.unquoteIdentifier(ctx.alias.getText()), (UnresolvedExpression)this.visit((ParseTree)ctx.spanClause())) : new Alias(name, (UnresolvedExpression)this.visit((ParseTree)ctx.spanClause()));
    }

    @Override
    public UnresolvedExpression visitSpanClause(OpenSearchPPLParser.SpanClauseContext ctx) {
        String unit = ctx.unit != null ? ctx.unit.getText() : "";
        return new Span((UnresolvedExpression)this.visit((ParseTree)ctx.fieldExpression()), (UnresolvedExpression)this.visit((ParseTree)ctx.value), SpanUnit.of(unit));
    }

    @Override
    public UnresolvedExpression visitLeftHint(OpenSearchPPLParser.LeftHintContext ctx) {
        return new EqualTo(new Literal(ctx.leftHintKey.getText(), DataType.STRING), (UnresolvedExpression)this.visit((ParseTree)ctx.leftHintValue));
    }

    @Override
    public UnresolvedExpression visitRightHint(OpenSearchPPLParser.RightHintContext ctx) {
        return new EqualTo(new Literal(ctx.rightHintKey.getText(), DataType.STRING), (UnresolvedExpression)this.visit((ParseTree)ctx.rightHintValue));
    }

    @Override
    public UnresolvedExpression visitInSubqueryExpr(OpenSearchPPLParser.InSubqueryExprContext ctx) {
        InSubquery expr = new InSubquery(ctx.valueExpressionList().valueExpression().stream().map(arg_0 -> ((AstExpressionBuilder)this).visit(arg_0)).collect(Collectors.toList()), this.astBuilder.visitSubSearch(ctx.subSearch()));
        return ctx.NOT() != null ? new Not(expr) : expr;
    }

    @Override
    public UnresolvedExpression visitScalarSubqueryExpr(OpenSearchPPLParser.ScalarSubqueryExprContext ctx) {
        return new ScalarSubquery(this.astBuilder.visitSubSearch(ctx.subSearch()));
    }

    @Override
    public UnresolvedExpression visitExistsSubqueryExpr(OpenSearchPPLParser.ExistsSubqueryExprContext ctx) {
        return new ExistsSubquery(this.astBuilder.visitSubSearch(ctx.subSearch()));
    }

    @Override
    public UnresolvedExpression visitBetween(OpenSearchPPLParser.BetweenContext ctx) {
        Between betweenExpr = new Between((UnresolvedExpression)this.visit((ParseTree)ctx.valueExpression(0)), (UnresolvedExpression)this.visit((ParseTree)ctx.valueExpression(1)), (UnresolvedExpression)this.visit((ParseTree)ctx.valueExpression(2)));
        return ctx.NOT() != null ? new Not(betweenExpr) : betweenExpr;
    }

    private QualifiedName visitIdentifiers(List<? extends ParserRuleContext> ctx) {
        return new QualifiedName(ctx.stream().map(RuleContext::getText).map(StringUtils::unquoteIdentifier).collect(Collectors.toList()));
    }

    private List<UnresolvedExpression> singleFieldRelevanceArguments(OpenSearchPPLParser.SingleFieldRelevanceFunctionContext ctx) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new UnresolvedArgument("field", new QualifiedName(StringUtils.unquoteText(ctx.field.getText()))));
        builder.add((Object)new UnresolvedArgument("query", new Literal(StringUtils.unquoteText(ctx.query.getText()), DataType.STRING)));
        ctx.relevanceArg().forEach(v -> builder.add((Object)new UnresolvedArgument(v.relevanceArgName().getText().toLowerCase(), new Literal(StringUtils.unquoteText(v.relevanceArgValue().getText()), DataType.STRING))));
        return builder.build();
    }

    private List<UnresolvedExpression> multiFieldRelevanceArguments(OpenSearchPPLParser.MultiFieldRelevanceFunctionContext ctx) {
        ImmutableList.Builder builder = ImmutableList.builder();
        RelevanceFieldList fields = new RelevanceFieldList(ctx.getRuleContexts(OpenSearchPPLParser.RelevanceFieldAndWeightContext.class).stream().collect(Collectors.toMap(f -> StringUtils.unquoteText(f.field.getText()), f -> Float.valueOf(f.weight == null ? 1.0f : Float.parseFloat(f.weight.getText())))));
        builder.add((Object)new UnresolvedArgument("fields", fields));
        builder.add((Object)new UnresolvedArgument("query", new Literal(StringUtils.unquoteText(ctx.query.getText()), DataType.STRING)));
        ctx.relevanceArg().forEach(v -> builder.add((Object)new UnresolvedArgument(v.relevanceArgName().getText().toLowerCase(), new Literal(StringUtils.unquoteText(v.relevanceArgValue().getText()), DataType.STRING))));
        return builder.build();
    }
}

