/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.system;

import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.request.system.OpenSearchCatIndicesRequest;
import org.opensearch.sql.opensearch.request.system.OpenSearchDescribeIndexRequest;
import org.opensearch.sql.opensearch.request.system.OpenSearchSystemRequest;
import org.opensearch.sql.opensearch.storage.system.OpenSearchSystemIndexScan;
import org.opensearch.sql.opensearch.storage.system.OpenSearchSystemIndexSchema;
import org.opensearch.sql.planner.DefaultImplementor;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalRelation;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.storage.Table;
import org.opensearch.sql.utils.SystemIndexUtils;
import shaded.com.google.common.annotations.VisibleForTesting;

public class OpenSearchSystemIndex
implements Table {
    private final Pair<OpenSearchSystemIndexSchema, OpenSearchSystemRequest> systemIndexBundle;

    public OpenSearchSystemIndex(OpenSearchClient client, String indexName) {
        this.systemIndexBundle = this.buildIndexBundle(client, indexName);
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public void create(Map<String, ExprType> schema) {
        throw new UnsupportedOperationException("OpenSearch system index is predefined and cannot be created");
    }

    @Override
    public Map<String, ExprType> getFieldTypes() {
        return ((OpenSearchSystemIndexSchema)((Object)this.systemIndexBundle.getLeft())).getMapping();
    }

    @Override
    public PhysicalPlan implement(LogicalPlan plan) {
        return plan.accept(new OpenSearchSystemIndexDefaultImplementor(), null);
    }

    private Pair<OpenSearchSystemIndexSchema, OpenSearchSystemRequest> buildIndexBundle(OpenSearchClient client, String indexName) {
        SystemIndexUtils.SystemTable systemTable = SystemIndexUtils.systemTable(indexName);
        if (systemTable.isSystemInfoTable()) {
            return Pair.of((Object)((Object)OpenSearchSystemIndexSchema.SYS_TABLE_TABLES), (Object)new OpenSearchCatIndicesRequest(client));
        }
        return Pair.of((Object)((Object)OpenSearchSystemIndexSchema.SYS_TABLE_MAPPINGS), (Object)new OpenSearchDescribeIndexRequest(client, systemTable.getTableName(), systemTable.getLangSpec()));
    }

    @VisibleForTesting
    public class OpenSearchSystemIndexDefaultImplementor
    extends DefaultImplementor<Object> {
        @Override
        public PhysicalPlan visitRelation(LogicalRelation node, Object context) {
            return new OpenSearchSystemIndexScan((OpenSearchSystemRequest)OpenSearchSystemIndex.this.systemIndexBundle.getRight());
        }

        @Generated
        public OpenSearchSystemIndexDefaultImplementor() {
        }
    }
}

