/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.scan;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.ExpressionNodeVisitor;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.expression.function.OpenSearchFunctions;
import org.opensearch.sql.opensearch.request.OpenSearchRequestBuilder;
import org.opensearch.sql.opensearch.storage.scan.PushDownQueryBuilder;
import org.opensearch.sql.opensearch.storage.script.filter.FilterQueryBuilder;
import org.opensearch.sql.opensearch.storage.script.sort.SortQueryBuilder;
import org.opensearch.sql.opensearch.storage.serialization.DefaultExpressionSerializer;
import org.opensearch.sql.planner.logical.LogicalFilter;
import org.opensearch.sql.planner.logical.LogicalHighlight;
import org.opensearch.sql.planner.logical.LogicalLimit;
import org.opensearch.sql.planner.logical.LogicalNested;
import org.opensearch.sql.planner.logical.LogicalPaginate;
import org.opensearch.sql.planner.logical.LogicalProject;
import org.opensearch.sql.planner.logical.LogicalSort;
import shaded.com.google.common.annotations.VisibleForTesting;

@VisibleForTesting
class OpenSearchIndexScanQueryBuilder
implements PushDownQueryBuilder {
    final OpenSearchRequestBuilder requestBuilder;

    public OpenSearchIndexScanQueryBuilder(OpenSearchRequestBuilder requestBuilder) {
        this.requestBuilder = requestBuilder;
    }

    @Override
    public boolean pushDownFilter(LogicalFilter filter) {
        FilterQueryBuilder queryBuilder = new FilterQueryBuilder(new DefaultExpressionSerializer());
        Expression queryCondition = filter.getCondition();
        QueryBuilder query = queryBuilder.build(queryCondition);
        this.requestBuilder.pushDownFilter(query);
        this.requestBuilder.pushDownTrackedScore(this.trackScoresFromOpenSearchFunction(queryCondition));
        return true;
    }

    @Override
    public boolean pushDownSort(LogicalSort sort) {
        List<Pair<Sort.SortOption, Expression>> sortList = sort.getSortList();
        SortQueryBuilder builder = new SortQueryBuilder();
        this.requestBuilder.pushDownSort(sortList.stream().map(sortItem -> builder.build((Expression)sortItem.getValue(), (Sort.SortOption)sortItem.getKey())).collect(Collectors.toList()));
        return true;
    }

    @Override
    public boolean pushDownLimit(LogicalLimit limit) {
        this.requestBuilder.pushDownLimit(limit.getLimit(), limit.getOffset());
        return true;
    }

    @Override
    public boolean pushDownProject(LogicalProject project) {
        this.requestBuilder.pushDownProjects(OpenSearchIndexScanQueryBuilder.findReferenceExpressions(project.getProjectList()));
        return false;
    }

    @Override
    public boolean pushDownHighlight(LogicalHighlight highlight) {
        this.requestBuilder.pushDownHighlight(StringUtils.unquoteText(highlight.getHighlightField().toString()), highlight.getArguments());
        return true;
    }

    @Override
    public boolean pushDownPageSize(LogicalPaginate paginate) {
        this.requestBuilder.pushDownPageSize(paginate.getPageSize());
        return true;
    }

    private boolean trackScoresFromOpenSearchFunction(Expression condition) {
        if (condition instanceof OpenSearchFunctions.OpenSearchFunction && ((OpenSearchFunctions.OpenSearchFunction)condition).isScoreTracked()) {
            return true;
        }
        if (condition instanceof FunctionExpression) {
            return ((FunctionExpression)condition).getArguments().stream().anyMatch(this::trackScoresFromOpenSearchFunction);
        }
        return false;
    }

    @Override
    public boolean pushDownNested(LogicalNested nested) {
        this.requestBuilder.pushDownNested(nested.getFields());
        this.requestBuilder.pushDownProjects(OpenSearchIndexScanQueryBuilder.findReferenceExpressions(nested.getProjectList()));
        return false;
    }

    @Override
    public OpenSearchRequestBuilder build() {
        return this.requestBuilder;
    }

    public static Set<ReferenceExpression> findReferenceExpressions(List<NamedExpression> expressions) {
        HashSet<ReferenceExpression> projectList = new HashSet<ReferenceExpression>();
        for (NamedExpression namedExpression : expressions) {
            projectList.addAll(OpenSearchIndexScanQueryBuilder.findReferenceExpression(namedExpression));
        }
        return projectList;
    }

    public static List<ReferenceExpression> findReferenceExpression(NamedExpression expression) {
        final ArrayList<ReferenceExpression> results = new ArrayList<ReferenceExpression>();
        expression.accept(new ExpressionNodeVisitor<Object, Object>(){

            @Override
            public Object visitReference(ReferenceExpression node, Object context) {
                return results.add(node);
            }
        }, null);
        return results;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSearchIndexScanQueryBuilder)) {
            return false;
        }
        OpenSearchIndexScanQueryBuilder other = (OpenSearchIndexScanQueryBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OpenSearchRequestBuilder this$requestBuilder = this.requestBuilder;
        OpenSearchRequestBuilder other$requestBuilder = other.requestBuilder;
        return !(this$requestBuilder == null ? other$requestBuilder != null : !((Object)this$requestBuilder).equals(other$requestBuilder));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OpenSearchIndexScanQueryBuilder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OpenSearchRequestBuilder $requestBuilder = this.requestBuilder;
        result = result * 59 + ($requestBuilder == null ? 43 : ((Object)$requestBuilder).hashCode());
        return result;
    }
}

