/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.scan;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.linq4j.Enumerator;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.request.OpenSearchRequest;
import org.opensearch.sql.opensearch.response.OpenSearchResponse;

public class OpenSearchIndexEnumerator
implements Enumerator<Object> {
    private final OpenSearchClient client;
    private final List<String> fields;
    private final OpenSearchRequest request;
    private final int maxResponseSize;
    private Integer queryCount;
    private Iterator<ExprValue> iterator;
    private ExprValue current;

    public OpenSearchIndexEnumerator(OpenSearchClient client, List<String> fields, int maxResponseSize, OpenSearchRequest request) {
        this.client = client;
        this.fields = fields;
        this.maxResponseSize = maxResponseSize;
        this.request = request;
        this.queryCount = 0;
        this.current = null;
    }

    private void fetchNextBatch() {
        OpenSearchResponse response = this.client.search(this.request);
        if (!response.isEmpty()) {
            this.iterator = response.iterator();
        } else if (this.iterator == null) {
            this.iterator = Collections.emptyIterator();
        }
    }

    public Object current() {
        if (this.fields.size() == 1) {
            return this.resolveForCalcite(this.current, this.fields.getFirst());
        }
        return this.fields.stream().map(field -> this.resolveForCalcite(this.current, (String)field)).toArray();
    }

    private Object resolveForCalcite(ExprValue value, String rawPath) {
        return ExprValueUtils.resolveRefPaths(value, List.of(rawPath.split("\\."))).valueForCalcite();
    }

    public boolean moveNext() {
        if (this.queryCount >= this.maxResponseSize) {
            this.iterator = Collections.emptyIterator();
            return false;
        }
        if (this.iterator == null || !this.iterator.hasNext()) {
            this.fetchNextBatch();
        }
        if (this.iterator.hasNext()) {
            this.current = this.iterator.next();
            Integer n = this.queryCount;
            this.queryCount = this.queryCount + 1;
            return true;
        }
        return false;
    }

    public void reset() {
        this.iterator = Collections.emptyIterator();
        this.queryCount = 0;
    }

    public void close() {
        this.reset();
        this.client.cleanup(this.request);
    }
}

