/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.scan;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.opensearch.data.type.OpenSearchDataType;
import org.opensearch.sql.opensearch.planner.physical.EnumerableIndexScanRule;
import org.opensearch.sql.opensearch.planner.physical.OpenSearchIndexRules;
import org.opensearch.sql.opensearch.request.AggregateAnalyzer;
import org.opensearch.sql.opensearch.request.PredicateAnalyzer;
import org.opensearch.sql.opensearch.response.agg.OpenSearchAggregationResponseParser;
import org.opensearch.sql.opensearch.storage.OpenSearchIndex;
import org.opensearch.sql.opensearch.storage.scan.CalciteIndexScan;
import shaded.com.google.common.collect.ImmutableList;

public class CalciteLogicalIndexScan
extends CalciteIndexScan {
    private static final Logger LOG = LogManager.getLogger(CalciteLogicalIndexScan.class);

    public CalciteLogicalIndexScan(RelOptCluster cluster, RelOptTable table, OpenSearchIndex osIndex) {
        this(cluster, cluster.traitSetOf((RelTrait)Convention.NONE), (List<RelHint>)ImmutableList.of(), table, osIndex, table.getRowType(), new CalciteIndexScan.PushDownContext());
    }

    protected CalciteLogicalIndexScan(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelOptTable table, OpenSearchIndex osIndex, RelDataType schema, CalciteIndexScan.PushDownContext pushDownContext) {
        super(cluster, traitSet, hints, table, osIndex, schema, pushDownContext);
    }

    public CalciteLogicalIndexScan copyWithNewSchema(RelDataType schema) {
        return new CalciteLogicalIndexScan(this.getCluster(), this.traitSet, (List<RelHint>)this.hints, this.table, this.osIndex, schema, this.pushDownContext.clone());
    }

    public void register(RelOptPlanner planner) {
        super.register(planner);
        planner.addRule(EnumerableIndexScanRule.DEFAULT_CONFIG.toRule());
        if (((Boolean)this.osIndex.getSettings().getSettingValue(Settings.Key.CALCITE_PUSHDOWN_ENABLED)).booleanValue()) {
            for (RelOptRule rule : OpenSearchIndexRules.OPEN_SEARCH_INDEX_SCAN_RULES) {
                planner.addRule(rule);
            }
        }
    }

    public CalciteLogicalIndexScan pushDownFilter(Filter filter) {
        try {
            CalciteLogicalIndexScan newScan = this.copyWithNewSchema(filter.getRowType());
            List schema = this.getRowType().getFieldNames();
            Map<String, OpenSearchDataType> typeMapping = this.osIndex.getFieldOpenSearchTypes();
            QueryBuilder filterBuilder = PredicateAnalyzer.analyze(filter.getCondition(), schema, typeMapping);
            newScan.pushDownContext.add(CalciteIndexScan.PushDownAction.of(CalciteIndexScan.PushDownType.FILTER, filter.getCondition(), requestBuilder -> requestBuilder.pushDownFilter(filterBuilder)));
            return newScan;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot pushdown the filter condition {}", (Object)filter.getCondition(), (Object)e);
            } else {
                LOG.warn("Cannot pushdown the filter condition {}, ", (Object)filter.getCondition());
            }
            return null;
        }
    }

    public CalciteLogicalIndexScan pushDownProject(List<Integer> selectedColumns) {
        RelDataTypeFactory.FieldInfoBuilder builder = this.getCluster().getTypeFactory().builder();
        List fieldList = this.getRowType().getFieldList();
        for (int project : selectedColumns) {
            builder.add((RelDataTypeField)fieldList.get(project));
        }
        RelDataType newSchema = builder.build();
        CalciteLogicalIndexScan newScan = this.copyWithNewSchema(newSchema);
        newScan.pushDownContext.add(CalciteIndexScan.PushDownAction.of(CalciteIndexScan.PushDownType.PROJECT, newSchema.getFieldNames(), requestBuilder -> requestBuilder.pushDownProjectStream(newSchema.getFieldNames().stream())));
        return newScan;
    }

    public CalciteLogicalIndexScan pushDownAggregate(Aggregate aggregate) {
        try {
            CalciteLogicalIndexScan newScan = this.copyWithNewSchema(aggregate.getRowType());
            List schema = this.getRowType().getFieldNames();
            Map<String, OpenSearchDataType> typeMapping = this.osIndex.getFieldOpenSearchTypes();
            List outputFields = aggregate.getRowType().getFieldNames();
            Pair<List<AggregationBuilder>, OpenSearchAggregationResponseParser> aggregationBuilder = AggregateAnalyzer.analyze(aggregate, schema, typeMapping, outputFields);
            Map<String, OpenSearchDataType> extendedTypeMapping = aggregate.getRowType().getFieldList().stream().collect(Collectors.toMap(RelDataTypeField::getName, field -> OpenSearchDataType.of(OpenSearchTypeFactory.convertRelDataTypeToExprType(field.getType()))));
            newScan.pushDownContext.add(CalciteIndexScan.PushDownAction.of(CalciteIndexScan.PushDownType.AGGREGATION, aggregate, requestBuilder -> {
                requestBuilder.pushDownAggregation(aggregationBuilder);
                requestBuilder.pushTypeMapping(extendedTypeMapping);
            }));
            return newScan;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot pushdown the aggregate {}", (Object)aggregate, (Object)e);
            } else {
                LOG.warn("Cannot pushdown the aggregate {}, ", (Object)aggregate);
            }
            return null;
        }
    }
}

