/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.scan;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.opensearch.sql.opensearch.request.OpenSearchRequestBuilder;
import org.opensearch.sql.opensearch.storage.OpenSearchIndex;

public abstract class CalciteIndexScan
extends TableScan {
    public final OpenSearchIndex osIndex;
    protected final RelDataType schema;
    protected final PushDownContext pushDownContext;

    protected CalciteIndexScan(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelOptTable table, OpenSearchIndex osIndex, RelDataType schema, PushDownContext pushDownContext) {
        super(cluster, traitSet, hints, table);
        this.osIndex = Objects.requireNonNull(osIndex, "OpenSearch index");
        this.schema = schema;
        this.pushDownContext = pushDownContext;
    }

    public RelDataType deriveRowType() {
        return this.schema;
    }

    public RelWriter explainTerms(RelWriter pw) {
        OpenSearchRequestBuilder requestBuilder = this.osIndex.createRequestBuilder();
        this.pushDownContext.forEach(action -> action.apply(requestBuilder));
        String explainString = String.valueOf(this.pushDownContext) + ", " + String.valueOf(requestBuilder);
        return super.explainTerms(pw).itemIf("PushDownContext", (Object)explainString, !this.pushDownContext.isEmpty());
    }

    @Generated
    public OpenSearchIndex getOsIndex() {
        return this.osIndex;
    }

    @Generated
    public RelDataType getSchema() {
        return this.schema;
    }

    @Generated
    public PushDownContext getPushDownContext() {
        return this.pushDownContext;
    }

    public static class PushDownContext
    extends ArrayDeque<PushDownAction> {
        private boolean isAggregatePushed = false;

        @Override
        public PushDownContext clone() {
            return (PushDownContext)super.clone();
        }

        @Override
        public boolean add(PushDownAction pushDownAction) {
            assert (!this.isAggregatePushed) : "Aggregate has already been pushed!";
            if (pushDownAction.type == PushDownType.AGGREGATION) {
                this.isAggregatePushed = true;
            }
            return super.add(pushDownAction);
        }

        public boolean isAggregatePushed() {
            if (this.isAggregatePushed) {
                return true;
            }
            this.isAggregatePushed = !this.isEmpty() && ((PushDownAction)super.peekLast()).type == PushDownType.AGGREGATION;
            return this.isAggregatePushed;
        }
    }

    public record PushDownAction(PushDownType type, Object digest, AbstractAction action) {
        static PushDownAction of(PushDownType type, Object digest, AbstractAction action) {
            return new PushDownAction(type, digest, action);
        }

        @Override
        public String toString() {
            return String.valueOf((Object)this.type) + "->" + String.valueOf(this.digest);
        }

        public void apply(OpenSearchRequestBuilder requestBuilder) {
            this.action.apply(requestBuilder);
        }
    }

    public static interface AbstractAction {
        public void apply(OpenSearchRequestBuilder var1);
    }

    protected static enum PushDownType {
        FILTER,
        PROJECT,
        AGGREGATION;

    }
}

