/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.scan;

import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.opensearch.sql.calcite.plan.OpenSearchRules;
import org.opensearch.sql.opensearch.request.OpenSearchRequestBuilder;
import org.opensearch.sql.opensearch.storage.OpenSearchIndex;
import org.opensearch.sql.opensearch.storage.scan.CalciteIndexScan;
import org.opensearch.sql.opensearch.storage.scan.OpenSearchIndexEnumerator;

public class CalciteEnumerableIndexScan
extends CalciteIndexScan
implements EnumerableRel {
    private static final Logger LOG = LogManager.getLogger(CalciteEnumerableIndexScan.class);

    public CalciteEnumerableIndexScan(RelOptCluster cluster, List<RelHint> hints, RelOptTable table, OpenSearchIndex osIndex, RelDataType schema, CalciteIndexScan.PushDownContext pushDownContext) {
        super(cluster, cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE), hints, table, osIndex, schema, pushDownContext);
    }

    public void register(RelOptPlanner planner) {
        for (RelOptRule relOptRule : OpenSearchRules.OPEN_SEARCH_OPT_RULES) {
            planner.addRule(relOptRule);
        }
        planner.removeRule((RelOptRule)CoreRules.AGGREGATE_EXPAND_DISTINCT_AGGREGATES);
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.getRowType(), (JavaRowFormat)pref.preferArray());
        Expression scanOperator = implementor.stash((Object)this, CalciteEnumerableIndexScan.class);
        return implementor.result(physType, Blocks.toBlock((Node)Expressions.call((Expression)scanOperator, (String)"scan", (Expression[])new Expression[0])));
    }

    public Enumerable<@Nullable Object> scan() {
        final OpenSearchRequestBuilder requestBuilder = this.osIndex.createRequestBuilder();
        this.pushDownContext.forEach(action -> action.apply(requestBuilder));
        return new AbstractEnumerable<Object>(){

            public Enumerator<Object> enumerator() {
                return new OpenSearchIndexEnumerator(CalciteEnumerableIndexScan.this.osIndex.getClient(), List.copyOf(CalciteEnumerableIndexScan.this.getRowType().getFieldNames()), requestBuilder.getMaxResponseSize(), CalciteEnumerableIndexScan.this.osIndex.buildRequest(requestBuilder));
            }
        };
    }
}

