/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.request.system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.executor.QueryType;
import org.opensearch.sql.lang.LangSpec;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.data.type.OpenSearchDataType;
import org.opensearch.sql.opensearch.mapping.IndexMapping;
import org.opensearch.sql.opensearch.request.OpenSearchRequest;
import org.opensearch.sql.opensearch.request.system.OpenSearchSystemRequest;

public class OpenSearchDescribeIndexRequest
implements OpenSearchSystemRequest {
    private static final String DEFAULT_TABLE_CAT = "opensearch";
    private static final Integer DEFAULT_NUM_PREC_RADIX = 10;
    private static final Integer DEFAULT_NULLABLE = 2;
    private static final String DEFAULT_IS_AUTOINCREMENT = "NO";
    private final OpenSearchClient client;
    private final OpenSearchRequest.IndexName indexName;
    private final LangSpec langSpec;

    public OpenSearchDescribeIndexRequest(OpenSearchClient client, String indexName) {
        this(client, new OpenSearchRequest.IndexName(indexName));
    }

    public OpenSearchDescribeIndexRequest(OpenSearchClient client, String indexName, LangSpec langSpec) {
        this(client, new OpenSearchRequest.IndexName(indexName), langSpec);
    }

    public OpenSearchDescribeIndexRequest(OpenSearchClient client, OpenSearchRequest.IndexName indexName) {
        this(client, indexName, LangSpec.SQL_SPEC);
    }

    public OpenSearchDescribeIndexRequest(OpenSearchClient client, OpenSearchRequest.IndexName indexName, LangSpec langSpec) {
        this.client = client;
        this.indexName = indexName;
        this.langSpec = langSpec;
    }

    @Override
    public List<ExprValue> search() {
        ArrayList<ExprValue> results = new ArrayList<ExprValue>();
        Map<String, String> meta = this.client.meta();
        int pos = 0;
        for (Map.Entry<String, OpenSearchDataType> entry : OpenSearchDataType.traverseAndFlatten(this.getFieldTypes()).entrySet()) {
            results.add(this.row(entry.getKey(), (this.langSpec.language() == QueryType.PPL ? this.langSpec.typeName(entry.getValue().getExprType()) : entry.getValue().legacyTypeName()).toLowerCase(Locale.ROOT), pos++, this.clusterName(meta)));
        }
        return results;
    }

    public Map<String, OpenSearchDataType> getFieldTypes() {
        HashMap<String, OpenSearchDataType> fieldTypes = new HashMap<String, OpenSearchDataType>();
        Map<String, IndexMapping> indexMappings = this.client.getIndexMappings(this.getLocalIndexNames(this.indexName.getIndexNames()));
        for (IndexMapping indexMapping : indexMappings.values()) {
            fieldTypes.putAll(indexMapping.getFieldMappings());
        }
        return fieldTypes;
    }

    public Integer getMaxResultWindow() {
        return this.client.getIndexMaxResultWindows(this.getLocalIndexNames(this.indexName.getIndexNames())).values().stream().min(Integer::compare).get();
    }

    private ExprTupleValue row(String fieldName, String fieldType, int position, String clusterName) {
        LinkedHashMap<String, ExprValue> valueMap = new LinkedHashMap<String, ExprValue>();
        valueMap.put("TABLE_CAT", ExprValueUtils.stringValue(clusterName));
        valueMap.put("TABLE_NAME", ExprValueUtils.stringValue(this.indexName.toString()));
        valueMap.put("COLUMN_NAME", ExprValueUtils.stringValue(fieldName));
        valueMap.put("TYPE_NAME", ExprValueUtils.stringValue(fieldType));
        valueMap.put("NUM_PREC_RADIX", ExprValueUtils.integerValue(DEFAULT_NUM_PREC_RADIX));
        valueMap.put("NULLABLE", ExprValueUtils.integerValue(DEFAULT_NULLABLE));
        valueMap.put("ORDINAL_POSITION", ExprValueUtils.integerValue(position));
        valueMap.put("IS_NULLABLE", ExprValueUtils.stringValue(""));
        valueMap.put("IS_AUTOINCREMENT", ExprValueUtils.stringValue(DEFAULT_IS_AUTOINCREMENT));
        valueMap.put("IS_GENERATEDCOLUMN", ExprValueUtils.stringValue(""));
        return new ExprTupleValue(valueMap);
    }

    private String[] getLocalIndexNames(String[] indexNames) {
        return (String[])Arrays.stream(indexNames).map(name -> name.substring(name.indexOf(":") + 1)).toArray(String[]::new);
    }

    private String clusterName(Map<String, String> meta) {
        return meta.getOrDefault("CLUSTER_NAME", DEFAULT_TABLE_CAT);
    }

    public String toString() {
        return "OpenSearchDescribeIndexRequest{indexName='" + String.valueOf(this.indexName) + "'}";
    }
}

