/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.physical;

import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.immutables.value.Value;
import org.opensearch.sql.opensearch.planner.physical.ImmutableOpenSearchFilterIndexScanRule;
import org.opensearch.sql.opensearch.planner.physical.OpenSearchIndexScanRule;
import org.opensearch.sql.opensearch.storage.scan.CalciteLogicalIndexScan;

@Value.Enclosing
public class OpenSearchFilterIndexScanRule
extends RelRule<Config> {
    protected OpenSearchFilterIndexScanRule(Config config) {
        super((RelRule.Config)config);
    }

    public void onMatch(RelOptRuleCall call) {
        if (call.rels.length != 2) {
            throw new AssertionError((Object)String.format("The length of rels should be %s but got %s", this.operands.size(), call.rels.length));
        }
        LogicalFilter filter = (LogicalFilter)call.rel(0);
        CalciteLogicalIndexScan scan = (CalciteLogicalIndexScan)call.rel(1);
        this.apply(call, (Filter)filter, scan);
    }

    protected void apply(RelOptRuleCall call, Filter filter, CalciteLogicalIndexScan scan) {
        CalciteLogicalIndexScan newScan = scan.pushDownFilter(filter);
        if (newScan != null) {
            call.transformTo((RelNode)newScan);
        }
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableOpenSearchFilterIndexScanRule.Config.builder().build().withOperandSupplier(b0 -> b0.operand(LogicalFilter.class).oneInput(b1 -> b1.operand(CalciteLogicalIndexScan.class).predicate(OpenSearchIndexScanRule::test).noInputs()));

        default public OpenSearchFilterIndexScanRule toRule() {
            return new OpenSearchFilterIndexScanRule(this);
        }
    }
}

