/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query.planner.core;

import org.opensearch.sql.legacy.executor.format.Schema;
import org.opensearch.sql.legacy.expression.core.Expression;
import shaded.com.google.common.base.Strings;

public class ColumnNode {
    private String name;
    private String alias;
    private Schema.Type type;
    private Expression expr;

    public String columnName() {
        return Strings.isNullOrEmpty((String)this.alias) ? this.name : this.alias;
    }

    ColumnNode(String name, String alias, Schema.Type type, Expression expr) {
        this.name = name;
        this.alias = alias;
        this.type = type;
        this.expr = expr;
    }

    public static ColumnNodeBuilder builder() {
        return new ColumnNodeBuilder();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setType(Schema.Type type) {
        this.type = type;
    }

    public void setExpr(Expression expr) {
        this.expr = expr;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public Schema.Type getType() {
        return this.type;
    }

    public Expression getExpr() {
        return this.expr;
    }

    public String toString() {
        return "ColumnNode(name=" + this.getName() + ", alias=" + this.getAlias() + ", type=" + String.valueOf((Object)this.getType()) + ", expr=" + String.valueOf(this.getExpr()) + ")";
    }

    public static class ColumnNodeBuilder {
        private String name;
        private String alias;
        private Schema.Type type;
        private Expression expr;

        ColumnNodeBuilder() {
        }

        public ColumnNodeBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ColumnNodeBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public ColumnNodeBuilder type(Schema.Type type) {
            this.type = type;
            return this;
        }

        public ColumnNodeBuilder expr(Expression expr) {
            this.expr = expr;
            return this;
        }

        public ColumnNode build() {
            return new ColumnNode(this.name, this.alias, this.type, this.expr);
        }

        public String toString() {
            return "ColumnNode.ColumnNodeBuilder(name=" + this.name + ", alias=" + this.alias + ", type=" + String.valueOf((Object)this.type) + ", expr=" + String.valueOf(this.expr) + ")";
        }
    }
}

