/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.expression.core.operator;

import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.opensearch.sql.legacy.expression.core.operator.ScalarOperation;
import org.opensearch.sql.legacy.expression.core.operator.ScalarOperator;
import org.opensearch.sql.legacy.expression.model.ExprValue;
import org.opensearch.sql.legacy.expression.model.ExprValueFactory;
import org.opensearch.sql.legacy.expression.model.ExprValueUtils;
import shaded.com.google.common.collect.ImmutableMap;

public class BinaryScalarOperator
implements ScalarOperator {
    private static final Map<ExprValue.ExprValueKind, Integer> numberTypeOrder = new ImmutableMap.Builder().put((Object)ExprValue.ExprValueKind.INTEGER_VALUE, (Object)0).put((Object)ExprValue.ExprValueKind.LONG_VALUE, (Object)1).put((Object)ExprValue.ExprValueKind.DOUBLE_VALUE, (Object)2).put((Object)ExprValue.ExprValueKind.FLOAT_VALUE, (Object)3).build();
    private final ScalarOperation op;
    private final BiFunction<Integer, Integer, Integer> integerFunc;
    private final BiFunction<Long, Long, Long> longFunc;
    private final BiFunction<Double, Double, Double> doubleFunc;
    private final BiFunction<Float, Float, Float> floatFunc;

    @Override
    public ExprValue apply(List<ExprValue> valueList) {
        ExprValue v1 = valueList.get(0);
        ExprValue v2 = valueList.get(1);
        if (!numberTypeOrder.containsKey((Object)v1.kind()) || !numberTypeOrder.containsKey((Object)v2.kind())) {
            throw new RuntimeException(String.format("unexpected operation type: %s(%s, %s) ", new Object[]{this.op.name(), v1.kind(), v2.kind()}));
        }
        ExprValue.ExprValueKind expectedType = numberTypeOrder.get((Object)v1.kind()) > numberTypeOrder.get((Object)v2.kind()) ? v1.kind() : v2.kind();
        switch (expectedType) {
            case DOUBLE_VALUE: {
                return ExprValueFactory.from(this.doubleFunc.apply(ExprValueUtils.getDoubleValue(v1), ExprValueUtils.getDoubleValue(v2)));
            }
            case INTEGER_VALUE: {
                return ExprValueFactory.from(this.integerFunc.apply(ExprValueUtils.getIntegerValue(v1), ExprValueUtils.getIntegerValue(v2)));
            }
            case LONG_VALUE: {
                return ExprValueFactory.from(this.longFunc.apply(ExprValueUtils.getLongValue(v1), ExprValueUtils.getLongValue(v2)));
            }
            case FLOAT_VALUE: {
                return ExprValueFactory.from(this.floatFunc.apply(ExprValueUtils.getFloatValue(v1), ExprValueUtils.getFloatValue(v2)));
            }
        }
        throw new RuntimeException(String.format("unexpected operation type: %s(%s, %s)", new Object[]{this.op.name(), v1.kind(), v2.kind()}));
    }

    @Override
    public String name() {
        return this.op.name();
    }

    public BinaryScalarOperator(ScalarOperation op, BiFunction<Integer, Integer, Integer> integerFunc, BiFunction<Long, Long, Long> longFunc, BiFunction<Double, Double, Double> doubleFunc, BiFunction<Float, Float, Float> floatFunc) {
        this.op = op;
        this.integerFunc = integerFunc;
        this.longFunc = longFunc;
        this.doubleFunc = doubleFunc;
        this.floatFunc = floatFunc;
    }
}

