/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor;

import java.util.Map;
import java.util.Optional;
import shaded.com.google.common.collect.ImmutableMap;

public enum Format {
    JDBC("jdbc"),
    CSV("csv"),
    RAW("raw"),
    TABLE("table"),
    SIMPLE("simple"),
    STANDARD("standard"),
    EXTENDED("extended");

    private final String formatName;
    public static final Map<String, Format> RESPONSE_FORMATS;
    public static final Map<String, Format> EXPLAIN_FORMATS;

    public static Optional<Format> of(String formatName) {
        return Optional.ofNullable(RESPONSE_FORMATS.getOrDefault(formatName, null));
    }

    public static Optional<Format> ofExplain(String formatName) {
        return Optional.ofNullable(EXPLAIN_FORMATS.getOrDefault(formatName, null));
    }

    private Format(String formatName) {
        this.formatName = formatName;
    }

    public String getFormatName() {
        return this.formatName;
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)Format.JDBC.formatName, (Object)JDBC);
        builder.put((Object)Format.CSV.formatName, (Object)CSV);
        builder.put((Object)Format.RAW.formatName, (Object)RAW);
        builder.put((Object)Format.TABLE.formatName, (Object)TABLE);
        RESPONSE_FORMATS = builder.build();
        builder = new ImmutableMap.Builder();
        builder.put((Object)Format.SIMPLE.formatName, (Object)SIMPLE);
        builder.put((Object)Format.STANDARD.formatName, (Object)STANDARD);
        builder.put((Object)Format.EXTENDED.formatName, (Object)EXTENDED);
        EXPLAIN_FORMATS = builder.build();
    }
}

