/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.window.patterns;

import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.LiteralExpression;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.parse.PatternsExpression;
import org.opensearch.sql.expression.window.WindowDefinition;
import org.opensearch.sql.expression.window.WindowFunctionExpression;
import org.opensearch.sql.expression.window.frame.CurrentRowWindowFrame;
import org.opensearch.sql.expression.window.frame.WindowFrame;
import org.opensearch.sql.utils.ExpressionUtils;
import org.opensearch.sql.utils.FunctionUtils;

public class StreamPatternWindowFunction
extends FunctionExpression
implements WindowFunctionExpression {
    private final PatternsExpression patternsExpression;

    public StreamPatternWindowFunction(List<Expression> arguments) {
        super(BuiltinFunctionName.SIMPLE_PATTERN.getName(), arguments);
        String pattern = FunctionUtils.getNamedArgumentValue(this.getArguments(), "pattern").map(ExprValue::stringValue).orElse("");
        this.patternsExpression = new PatternsExpression(this.getArguments().get(0), new LiteralExpression(new ExprStringValue(pattern)), new LiteralExpression(new ExprStringValue("")));
    }

    @Override
    public WindowFrame createWindowFrame(WindowDefinition definition) {
        return new CurrentRowWindowFrame(definition);
    }

    @Override
    public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
        CurrentRowWindowFrame frame = (CurrentRowWindowFrame)valueEnv;
        ExprValue sourceFieldValue = this.patternsExpression.getSourceField().valueOf(frame.current().bindingTuples());
        return this.patternsExpression.parseValue(sourceFieldValue);
    }

    @Override
    public ExprType type() {
        return ExprCoreType.STRING;
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "%s(%s)", this.getFunctionName(), ExpressionUtils.format(this.getArguments()));
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamPatternWindowFunction)) {
            return false;
        }
        StreamPatternWindowFunction other = (StreamPatternWindowFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PatternsExpression this$patternsExpression = this.patternsExpression;
        PatternsExpression other$patternsExpression = other.patternsExpression;
        return !(this$patternsExpression == null ? other$patternsExpression != null : !((Object)this$patternsExpression).equals(other$patternsExpression));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StreamPatternWindowFunction;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        PatternsExpression $patternsExpression = this.patternsExpression;
        result = result * 59 + ($patternsExpression == null ? 43 : ((Object)$patternsExpression).hashCode());
        return result;
    }
}

