/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.ip;

import inet.ipaddr.IPAddress;
import java.util.Arrays;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.expression.function.DefaultFunctionResolver;
import org.opensearch.sql.expression.function.FunctionDSL;
import org.opensearch.sql.expression.function.OpenSearchFunctions;
import org.opensearch.sql.utils.IPUtils;

public final class IPFunctions {
    public static void register(BuiltinFunctionRepository repository) {
        repository.register(IPFunctions.cidrmatch());
        repository.register(IPFunctions.geoIp());
    }

    private static DefaultFunctionResolver cidrmatch() {
        return FunctionDSL.define(BuiltinFunctionName.CIDRMATCH.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(IPFunctions::exprCidrMatch), ExprCoreType.BOOLEAN, ExprCoreType.IP, ExprCoreType.STRING));
    }

    private static ExprValue exprCidrMatch(ExprValue addressExprValue, ExprValue rangeExprValue) {
        IPAddress range;
        IPAddress address = addressExprValue.ipValue();
        return IPUtils.compare(address, (range = IPUtils.toRange(rangeExprValue.stringValue())).getLower()) < 0 || IPUtils.compare(address, range.getUpper()) > 0 ? ExprValueUtils.LITERAL_FALSE : ExprValueUtils.LITERAL_TRUE;
    }

    private static DefaultFunctionResolver geoIp() {
        return FunctionDSL.define(BuiltinFunctionName.GEOIP.getName(), OpenSearchFunctions.OpenSearchExecutableFunction.openSearchImpl(ExprCoreType.BOOLEAN, Arrays.asList(ExprCoreType.STRING, ExprCoreType.STRING)), OpenSearchFunctions.OpenSearchExecutableFunction.openSearchImpl(ExprCoreType.BOOLEAN, Arrays.asList(ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.STRING)));
    }

    @Generated
    private IPFunctions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

