/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.PairList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.type.SqlTypeName;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.executor.QueryType;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.CalciteFuncSignature;
import org.opensearch.sql.expression.function.PPLBuiltinOperators;
import shaded.com.google.common.collect.ImmutableMap;

public class PPLFuncImpTable {
    public static final PPLFuncImpTable INSTANCE;
    private final ImmutableMap<BuiltinFunctionName, PairList<CalciteFuncSignature, FunctionImp>> map;

    private PPLFuncImpTable(Builder builder) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        builder.map.forEach((k, v) -> mapBuilder.put((Object)k, (Object)v.immutable()));
        this.map = ImmutableMap.copyOf((Map)mapBuilder.build());
    }

    public @Nullable RexNode resolveSafe(RexBuilder builder, String functionName, RexNode ... args) {
        try {
            return this.resolve(builder, functionName, args);
        }
        catch (Exception e) {
            return null;
        }
    }

    public RexNode resolve(RexBuilder builder, String functionName, RexNode ... args) {
        Optional<BuiltinFunctionName> funcNameOpt = BuiltinFunctionName.of(functionName);
        if (funcNameOpt.isEmpty()) {
            throw new IllegalArgumentException(String.format("Unsupported function: %s", functionName));
        }
        return this.resolve(builder, funcNameOpt.get(), args);
    }

    public RexNode resolve(RexBuilder builder, BuiltinFunctionName functionName, RexNode ... args) {
        PairList implementList = (PairList)this.map.get((Object)functionName);
        if (implementList == null || implementList.isEmpty()) {
            throw new IllegalStateException(String.format("Cannot resolve function: %s", new Object[]{functionName}));
        }
        List<RelDataType> argTypes = Arrays.stream(args).map(RexNode::getType).toList();
        try {
            for (Map.Entry implement : implementList) {
                if (!((CalciteFuncSignature)implement.getKey()).match(functionName.getName(), argTypes)) continue;
                return ((FunctionImp)implement.getValue()).resolve(builder, args);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Cannot resolve function: %s, arguments: %s, caused by: %s", new Object[]{functionName, argTypes, e.getMessage()}), e);
        }
        throw new IllegalArgumentException(String.format("Cannot resolve function: %s, arguments: %s", new Object[]{functionName, argTypes}));
    }

    static {
        Builder builder = new Builder();
        builder.populate();
        INSTANCE = new PPLFuncImpTable(builder);
    }

    private static class Builder
    extends AbstractBuilder {
        private final Map<BuiltinFunctionName, PairList<CalciteFuncSignature, FunctionImp>> map = new HashMap<BuiltinFunctionName, PairList<CalciteFuncSignature, FunctionImp>>();

        private Builder() {
        }

        @Override
        void register(BuiltinFunctionName functionName, FunctionImp implement) {
            CalciteFuncSignature signature = new CalciteFuncSignature(functionName.getName(), implement.getParams());
            if (this.map.containsKey((Object)functionName)) {
                this.map.get((Object)functionName).add((Object)signature, (Object)implement);
            } else {
                this.map.put(functionName, (PairList<CalciteFuncSignature, FunctionImp>)PairList.of((Object)signature, (Object)implement));
            }
        }
    }

    public static interface FunctionImp {
        public static final RelDataType ANY_TYPE = OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.ANY);

        public RexNode resolve(RexBuilder var1, RexNode ... var2);

        default public List<RelDataType> getParams() {
            return null;
        }
    }

    private static class XOR_FUNC
    implements FunctionImp2 {
        private XOR_FUNC() {
        }

        @Override
        public RexNode resolve(RexBuilder builder, RexNode arg1, RexNode arg2) {
            return builder.makeCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, new RexNode[]{arg1, arg2});
        }

        @Override
        public List<RelDataType> getParams() {
            RelDataType boolType = OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.BOOLEAN);
            return List.of(boolType, boolType);
        }
    }

    private static abstract class AbstractBuilder {
        private AbstractBuilder() {
        }

        abstract void register(BuiltinFunctionName var1, FunctionImp var2);

        void registerOperator(BuiltinFunctionName functionName, SqlOperator operator) {
            this.register(functionName, (builder, node) -> builder.makeCall(operator, node));
        }

        void populate() {
            this.registerOperator(BuiltinFunctionName.AND, (SqlOperator)SqlStdOperatorTable.AND);
            this.registerOperator(BuiltinFunctionName.OR, (SqlOperator)SqlStdOperatorTable.OR);
            this.registerOperator(BuiltinFunctionName.NOT, (SqlOperator)SqlStdOperatorTable.NOT);
            this.registerOperator(BuiltinFunctionName.NOTEQUAL, (SqlOperator)SqlStdOperatorTable.NOT_EQUALS);
            this.registerOperator(BuiltinFunctionName.EQUAL, (SqlOperator)SqlStdOperatorTable.EQUALS);
            this.registerOperator(BuiltinFunctionName.GREATER, (SqlOperator)SqlStdOperatorTable.GREATER_THAN);
            this.registerOperator(BuiltinFunctionName.GTE, (SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL);
            this.registerOperator(BuiltinFunctionName.LESS, (SqlOperator)SqlStdOperatorTable.LESS_THAN);
            this.registerOperator(BuiltinFunctionName.LTE, (SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL);
            this.registerOperator(BuiltinFunctionName.ADD, (SqlOperator)SqlStdOperatorTable.PLUS);
            this.registerOperator(BuiltinFunctionName.SUBTRACT, (SqlOperator)SqlStdOperatorTable.MINUS);
            this.registerOperator(BuiltinFunctionName.MULTIPLY, (SqlOperator)SqlStdOperatorTable.MULTIPLY);
            this.registerOperator(BuiltinFunctionName.ASCII, (SqlOperator)SqlStdOperatorTable.ASCII);
            this.registerOperator(BuiltinFunctionName.LENGTH, (SqlOperator)SqlStdOperatorTable.CHAR_LENGTH);
            this.registerOperator(BuiltinFunctionName.LOWER, (SqlOperator)SqlStdOperatorTable.LOWER);
            this.registerOperator(BuiltinFunctionName.POSITION, (SqlOperator)SqlStdOperatorTable.POSITION);
            this.registerOperator(BuiltinFunctionName.SUBSTRING, (SqlOperator)SqlStdOperatorTable.SUBSTRING);
            this.registerOperator(BuiltinFunctionName.SUBSTR, (SqlOperator)SqlStdOperatorTable.SUBSTRING);
            this.registerOperator(BuiltinFunctionName.UPPER, (SqlOperator)SqlStdOperatorTable.UPPER);
            this.registerOperator(BuiltinFunctionName.ABS, (SqlOperator)SqlStdOperatorTable.ABS);
            this.registerOperator(BuiltinFunctionName.ACOS, (SqlOperator)SqlStdOperatorTable.ACOS);
            this.registerOperator(BuiltinFunctionName.ASIN, (SqlOperator)SqlStdOperatorTable.ASIN);
            this.registerOperator(BuiltinFunctionName.ATAN, (SqlOperator)SqlStdOperatorTable.ATAN);
            this.registerOperator(BuiltinFunctionName.ATAN2, (SqlOperator)SqlStdOperatorTable.ATAN2);
            this.registerOperator(BuiltinFunctionName.CEILING, (SqlOperator)SqlStdOperatorTable.CEIL);
            this.registerOperator(BuiltinFunctionName.COS, (SqlOperator)SqlStdOperatorTable.COS);
            this.registerOperator(BuiltinFunctionName.COT, (SqlOperator)SqlStdOperatorTable.COT);
            this.registerOperator(BuiltinFunctionName.DEGREES, (SqlOperator)SqlStdOperatorTable.DEGREES);
            this.registerOperator(BuiltinFunctionName.EXP, (SqlOperator)SqlStdOperatorTable.EXP);
            this.registerOperator(BuiltinFunctionName.FLOOR, (SqlOperator)SqlStdOperatorTable.FLOOR);
            this.registerOperator(BuiltinFunctionName.LN, (SqlOperator)SqlStdOperatorTable.LN);
            this.registerOperator(BuiltinFunctionName.LOG10, (SqlOperator)SqlStdOperatorTable.LOG10);
            this.registerOperator(BuiltinFunctionName.PI, (SqlOperator)SqlStdOperatorTable.PI);
            this.registerOperator(BuiltinFunctionName.POW, (SqlOperator)SqlStdOperatorTable.POWER);
            this.registerOperator(BuiltinFunctionName.POWER, (SqlOperator)SqlStdOperatorTable.POWER);
            this.registerOperator(BuiltinFunctionName.RADIANS, (SqlOperator)SqlStdOperatorTable.RADIANS);
            this.registerOperator(BuiltinFunctionName.RAND, (SqlOperator)SqlStdOperatorTable.RAND);
            this.registerOperator(BuiltinFunctionName.ROUND, (SqlOperator)SqlStdOperatorTable.ROUND);
            this.registerOperator(BuiltinFunctionName.SIGN, (SqlOperator)SqlStdOperatorTable.SIGN);
            this.registerOperator(BuiltinFunctionName.SIN, (SqlOperator)SqlStdOperatorTable.SIN);
            this.registerOperator(BuiltinFunctionName.CBRT, (SqlOperator)SqlStdOperatorTable.CBRT);
            this.registerOperator(BuiltinFunctionName.IS_NOT_NULL, (SqlOperator)SqlStdOperatorTable.IS_NOT_NULL);
            this.registerOperator(BuiltinFunctionName.IS_NULL, (SqlOperator)SqlStdOperatorTable.IS_NULL);
            this.registerOperator(BuiltinFunctionName.REGEXP, (SqlOperator)SqlLibraryOperators.REGEXP);
            this.registerOperator(BuiltinFunctionName.CONCAT, (SqlOperator)SqlLibraryOperators.CONCAT_FUNCTION);
            this.registerOperator(BuiltinFunctionName.CONCAT_WS, (SqlOperator)SqlLibraryOperators.CONCAT_WS);
            this.registerOperator(BuiltinFunctionName.LIKE, (SqlOperator)SqlLibraryOperators.ILIKE);
            this.registerOperator(BuiltinFunctionName.CONCAT_WS, (SqlOperator)SqlLibraryOperators.CONCAT_WS);
            this.registerOperator(BuiltinFunctionName.REVERSE, (SqlOperator)SqlLibraryOperators.REVERSE);
            this.registerOperator(BuiltinFunctionName.RIGHT, (SqlOperator)SqlLibraryOperators.RIGHT);
            this.registerOperator(BuiltinFunctionName.LEFT, (SqlOperator)SqlLibraryOperators.LEFT);
            this.registerOperator(BuiltinFunctionName.LOG2, (SqlOperator)SqlLibraryOperators.LOG2);
            this.registerOperator(BuiltinFunctionName.SPAN, PPLBuiltinOperators.SPAN);
            this.register(BuiltinFunctionName.TRIM, (builder, arg) -> builder.makeCall((SqlOperator)SqlStdOperatorTable.TRIM, new RexNode[]{builder.makeFlag((Enum)SqlTrimFunction.Flag.BOTH), builder.makeLiteral(" "), arg}));
            this.register(BuiltinFunctionName.LTRIM, (builder, arg) -> builder.makeCall((SqlOperator)SqlStdOperatorTable.TRIM, new RexNode[]{builder.makeFlag((Enum)SqlTrimFunction.Flag.LEADING), builder.makeLiteral(" "), arg}));
            this.register(BuiltinFunctionName.RTRIM, (builder, arg) -> builder.makeCall((SqlOperator)SqlStdOperatorTable.TRIM, new RexNode[]{builder.makeFlag((Enum)SqlTrimFunction.Flag.TRAILING), builder.makeLiteral(" "), arg}));
            this.register(BuiltinFunctionName.STRCMP, (builder, arg1, arg2) -> builder.makeCall((SqlOperator)SqlLibraryOperators.STRCMP, new RexNode[]{arg2, arg1}));
            this.register(BuiltinFunctionName.LOG, (builder, arg1, arg2) -> builder.makeCall((SqlOperator)SqlLibraryOperators.LOG, new RexNode[]{arg2, arg1}));
            this.register(BuiltinFunctionName.LOG, (builder, arg) -> builder.makeCall((SqlOperator)SqlLibraryOperators.LOG, new RexNode[]{arg, builder.makeApproxLiteral(BigDecimal.valueOf(Math.E))}));
            this.register(BuiltinFunctionName.TYPEOF, (builder, arg) -> builder.makeLiteral(OpenSearchTypeFactory.getLegacyTypeName(arg.getType(), QueryType.PPL)));
            this.register(BuiltinFunctionName.XOR, new XOR_FUNC());
        }
    }

    public static interface FunctionImp2
    extends FunctionImp {
        public static final List<RelDataType> ANY_TYPE_2 = List.of(ANY_TYPE, ANY_TYPE);

        public RexNode resolve(RexBuilder var1, RexNode var2, RexNode var3);

        @Override
        default public RexNode resolve(RexBuilder builder, RexNode ... args) {
            if (args.length != 2) {
                throw new IllegalArgumentException("This function requires exactly 2 arguments");
            }
            return this.resolve(builder, args[0], args[1]);
        }

        @Override
        default public List<RelDataType> getParams() {
            return ANY_TYPE_2;
        }
    }

    public static interface FunctionImp1
    extends FunctionImp {
        public static final List<RelDataType> ANY_TYPE_1 = List.of(ANY_TYPE);

        public RexNode resolve(RexBuilder var1, RexNode var2);

        @Override
        default public RexNode resolve(RexBuilder builder, RexNode ... args) {
            if (args.length != 1) {
                throw new IllegalArgumentException("This function requires exactly 1 arguments");
            }
            return this.resolve(builder, args[0]);
        }

        @Override
        default public List<RelDataType> getParams() {
            return ANY_TYPE_1;
        }
    }
}

