/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.ExpressionNodeVisitor;
import org.opensearch.sql.expression.env.Environment;

public class ReferenceExpression
implements Expression {
    private final String attr;
    private final String rawPath;
    private final List<String> paths;
    private final ExprType type;

    public ReferenceExpression(String ref, ExprType type) {
        this.attr = ref;
        this.rawPath = type.getOriginalPath().orElse(ref);
        this.paths = Arrays.asList(this.rawPath.split("\\."));
        this.type = type.getOriginalExprType();
    }

    @Override
    public ExprValue valueOf(Environment<Expression, ExprValue> env) {
        return env.resolve(this);
    }

    @Override
    public ExprType type() {
        return this.type;
    }

    @Override
    public <T, C> T accept(ExpressionNodeVisitor<T, C> visitor, C context) {
        return visitor.visitReference(this, context);
    }

    public String toString() {
        return this.attr;
    }

    public ExprValue resolve(ExprTupleValue value) {
        return ExprValueUtils.resolveRefPaths(value, this.paths);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReferenceExpression)) {
            return false;
        }
        ReferenceExpression other = (ReferenceExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$attr = this.getAttr();
        String other$attr = other.getAttr();
        if (this$attr == null ? other$attr != null : !this$attr.equals(other$attr)) {
            return false;
        }
        String this$rawPath = this.getRawPath();
        String other$rawPath = other.getRawPath();
        if (this$rawPath == null ? other$rawPath != null : !this$rawPath.equals(other$rawPath)) {
            return false;
        }
        List<String> this$paths = this.getPaths();
        List<String> other$paths = other.getPaths();
        if (this$paths == null ? other$paths != null : !((Object)this$paths).equals(other$paths)) {
            return false;
        }
        ExprType this$type = this.type;
        ExprType other$type = other.type;
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReferenceExpression;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $attr = this.getAttr();
        result = result * 59 + ($attr == null ? 43 : $attr.hashCode());
        String $rawPath = this.getRawPath();
        result = result * 59 + ($rawPath == null ? 43 : $rawPath.hashCode());
        List<String> $paths = this.getPaths();
        result = result * 59 + ($paths == null ? 43 : ((Object)$paths).hashCode());
        ExprType $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Generated
    public ReferenceExpression(String attr, String rawPath, List<String> paths, ExprType type) {
        this.attr = attr;
        this.rawPath = rawPath;
        this.paths = paths;
        this.type = type;
    }

    @Generated
    public String getAttr() {
        return this.attr;
    }

    @Generated
    public String getRawPath() {
        return this.rawPath;
    }

    @Generated
    public List<String> getPaths() {
        return this.paths;
    }
}

