/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.executor;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.calcite.rel.RelNode;
import org.opensearch.sql.ast.statement.Explain;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.common.response.ResponseListener;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.executor.ExecutionContext;
import org.opensearch.sql.executor.pagination.Cursor;
import org.opensearch.sql.planner.physical.PhysicalPlan;

public interface ExecutionEngine {
    public void execute(PhysicalPlan var1, ResponseListener<QueryResponse> var2);

    public void execute(PhysicalPlan var1, ExecutionContext var2, ResponseListener<QueryResponse> var3);

    public void explain(PhysicalPlan var1, ResponseListener<ExplainResponse> var2);

    default public void execute(RelNode plan, CalcitePlanContext context, ResponseListener<QueryResponse> listener) {
    }

    default public void explain(RelNode plan, Explain.ExplainFormat format, CalcitePlanContext context, ResponseListener<ExplainResponse> listener) {
    }

    public static class ExplainResponseNodeV2 {
        private final String logical;
        private final String physical;
        private final String extended;

        @Generated
        public ExplainResponseNodeV2(String logical, String physical, String extended) {
            this.logical = logical;
            this.physical = physical;
            this.extended = extended;
        }
    }

    public static class ExplainResponseNode {
        private final String name;
        private Map<String, Object> description;
        private List<ExplainResponseNode> children;

        @Generated
        public ExplainResponseNode(String name, Map<String, Object> description, List<ExplainResponseNode> children) {
            this.name = name;
            this.description = description;
            this.children = children;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Map<String, Object> getDescription() {
            return this.description;
        }

        @Generated
        public List<ExplainResponseNode> getChildren() {
            return this.children;
        }

        @Generated
        public void setDescription(Map<String, Object> description) {
            this.description = description;
        }

        @Generated
        public void setChildren(List<ExplainResponseNode> children) {
            this.children = children;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExplainResponseNode)) {
                return false;
            }
            ExplainResponseNode other = (ExplainResponseNode)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Map<String, Object> this$description = this.getDescription();
            Map<String, Object> other$description = other.getDescription();
            if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
                return false;
            }
            List<ExplainResponseNode> this$children = this.getChildren();
            List<ExplainResponseNode> other$children = other.getChildren();
            return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ExplainResponseNode;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Map<String, Object> $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
            List<ExplainResponseNode> $children = this.getChildren();
            result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ExecutionEngine.ExplainResponseNode(name=" + this.getName() + ", description=" + String.valueOf(this.getDescription()) + ", children=" + String.valueOf(this.getChildren()) + ")";
        }

        @Generated
        public ExplainResponseNode(String name) {
            this.name = name;
        }
    }

    public static class ExplainResponse {
        private final ExplainResponseNode root;
        private final ExplainResponseNodeV2 calcite;

        public ExplainResponse(ExplainResponseNode root) {
            this.root = root;
            this.calcite = null;
        }

        public ExplainResponse(ExplainResponseNodeV2 calcite) {
            this.root = null;
            this.calcite = calcite;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExplainResponse that = (ExplainResponse)o;
            return Objects.equals(this.root, that.root) || Objects.equals(this.calcite, that.calcite);
        }

        public int hashCode() {
            return Objects.hash(this.root, this.calcite);
        }
    }

    public static class Schema {
        private final List<Column> columns;

        @Generated
        public Schema(List<Column> columns) {
            this.columns = columns;
        }

        @Generated
        public List<Column> getColumns() {
            return this.columns;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Schema)) {
                return false;
            }
            Schema other = (Schema)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Column> this$columns = this.getColumns();
            List<Column> other$columns = other.getColumns();
            return !(this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Schema;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Column> $columns = this.getColumns();
            result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ExecutionEngine.Schema(columns=" + String.valueOf(this.getColumns()) + ")";
        }

        public static class Column {
            private final String name;
            private final String alias;
            private final ExprType exprType;

            @Generated
            public Column(String name, String alias, ExprType exprType) {
                this.name = name;
                this.alias = alias;
                this.exprType = exprType;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getAlias() {
                return this.alias;
            }

            @Generated
            public ExprType getExprType() {
                return this.exprType;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Column)) {
                    return false;
                }
                Column other = (Column)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$alias = this.getAlias();
                String other$alias = other.getAlias();
                if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
                    return false;
                }
                ExprType this$exprType = this.getExprType();
                ExprType other$exprType = other.getExprType();
                return !(this$exprType == null ? other$exprType != null : !this$exprType.equals(other$exprType));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Column;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $alias = this.getAlias();
                result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
                ExprType $exprType = this.getExprType();
                result = result * 59 + ($exprType == null ? 43 : $exprType.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "ExecutionEngine.Schema.Column(name=" + this.getName() + ", alias=" + this.getAlias() + ", exprType=" + String.valueOf(this.getExprType()) + ")";
            }
        }
    }

    public static class QueryResponse {
        private final Schema schema;
        private final List<ExprValue> results;
        private final Cursor cursor;

        @Generated
        public QueryResponse(Schema schema, List<ExprValue> results, Cursor cursor) {
            this.schema = schema;
            this.results = results;
            this.cursor = cursor;
        }

        @Generated
        public Schema getSchema() {
            return this.schema;
        }

        @Generated
        public List<ExprValue> getResults() {
            return this.results;
        }

        @Generated
        public Cursor getCursor() {
            return this.cursor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueryResponse)) {
                return false;
            }
            QueryResponse other = (QueryResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Schema this$schema = this.getSchema();
            Schema other$schema = other.getSchema();
            if (this$schema == null ? other$schema != null : !((Object)this$schema).equals(other$schema)) {
                return false;
            }
            List<ExprValue> this$results = this.getResults();
            List<ExprValue> other$results = other.getResults();
            if (this$results == null ? other$results != null : !((Object)this$results).equals(other$results)) {
                return false;
            }
            Cursor this$cursor = this.getCursor();
            Cursor other$cursor = other.getCursor();
            return !(this$cursor == null ? other$cursor != null : !((Object)this$cursor).equals(other$cursor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof QueryResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Schema $schema = this.getSchema();
            result = result * 59 + ($schema == null ? 43 : ((Object)$schema).hashCode());
            List<ExprValue> $results = this.getResults();
            result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
            Cursor $cursor = this.getCursor();
            result = result * 59 + ($cursor == null ? 43 : ((Object)$cursor).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ExecutionEngine.QueryResponse(schema=" + String.valueOf(this.getSchema()) + ", results=" + String.valueOf(this.getResults()) + ", cursor=" + String.valueOf(this.getCursor()) + ")";
        }
    }
}

