/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.datetime;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.calcite.sql.type.SqlTypeName;
import org.opensearch.sql.calcite.utils.datetime.DateTimeParser;
import org.opensearch.sql.data.model.ExprTimeValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.function.FunctionProperties;

public interface InstantUtils {
    public static Instant fromEpochMills(long epochMillis) {
        return Instant.ofEpochMilli(epochMillis);
    }

    public static Instant fromInternalDate(int date) {
        LocalDate localDate = LocalDate.ofEpochDay(date);
        return localDate.atStartOfDay(ZoneId.of("UTC")).toInstant();
    }

    public static Instant fromInternalTime(int time) {
        LocalDate todayUtc = LocalDate.now(ZoneId.of("UTC"));
        ZonedDateTime startOfDayUtc = todayUtc.atStartOfDay(ZoneId.of("UTC"));
        return startOfDayUtc.toInstant().plus(Duration.ofMillis(time));
    }

    public static Instant fromStringExpr(String timestampExpression) {
        LocalDateTime datetime = DateTimeParser.parse(timestampExpression);
        return datetime.atZone(ZoneId.of("UTC")).toInstant();
    }

    public static Instant convertToInstant(Object candidate, SqlTypeName sqlTypeName) {
        Instant dateTimeBase = null;
        switch (sqlTypeName) {
            case DATE: {
                dateTimeBase = InstantUtils.fromInternalDate((Integer)candidate);
                break;
            }
            case TIMESTAMP: {
                dateTimeBase = InstantUtils.fromEpochMills((Long)candidate);
                break;
            }
            case TIME: {
                dateTimeBase = InstantUtils.fromInternalTime((Integer)candidate);
                break;
            }
            default: {
                dateTimeBase = InstantUtils.fromStringExpr((String)candidate);
            }
        }
        return dateTimeBase;
    }

    public static LocalDateTime parseStringToTimestamp(String input, FunctionProperties functionProperties) {
        try {
            return InstantUtils.parseTimeOrTimestamp(input, functionProperties);
        }
        catch (SemanticCheckException e) {
            return InstantUtils.parseDateOrTimestamp(input);
        }
    }

    public static LocalDateTime parseTimeOrTimestamp(String input, FunctionProperties functionProperties) {
        if (input == null || input.trim().isEmpty()) {
            throw new SemanticCheckException("Cannot parse a null/empty date-time string.");
        }
        try {
            return InstantUtils.parseTimestamp(input);
        }
        catch (Exception exception) {
            try {
                return InstantUtils.parseTime(input, functionProperties);
            }
            catch (Exception exception2) {
                throw new SemanticCheckException(String.format("time:%s in unsupported format, please use 'HH:mm:ss[.SSSSSSSSS]'", input));
            }
        }
    }

    public static LocalDateTime parseDateOrTimestamp(String input) {
        if (input == null || input.trim().isEmpty()) {
            throw new SemanticCheckException("Cannot parse a null/empty date-time string.");
        }
        try {
            return InstantUtils.parseTimestamp(input);
        }
        catch (Exception exception) {
            try {
                return InstantUtils.parseDate(input);
            }
            catch (Exception exception2) {
                throw new SemanticCheckException(String.format("date:%s in unsupported format, please use 'yyyy-MM-dd'", input));
            }
        }
    }

    public static LocalDateTime parseTimestamp(String input) {
        return LocalDateTime.ofInstant(ExprValueUtils.fromObjectValue(input, ExprCoreType.TIMESTAMP).timestampValue(), ZoneOffset.UTC);
    }

    public static LocalDateTime parseTime(String input, FunctionProperties functionProperties) {
        return LocalDateTime.ofInstant(new ExprTimeValue(input).timestampValue(functionProperties), ZoneOffset.UTC);
    }

    public static LocalDateTime parseDate(String input) {
        return LocalDateTime.ofInstant(ExprValueUtils.fromObjectValue(input, ExprCoreType.DATE).timestampValue(), ZoneOffset.UTC);
    }
}

