/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.datetime;

import java.time.Duration;
import java.time.Instant;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.sql.type.SqlTypeName;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.data.model.ExprTimeValue;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.function.FunctionProperties;

public interface DateTimeApplyUtils {
    public static Instant applyInterval(Instant base, Duration interval, boolean isAdd) {
        return isAdd ? base.plus(interval) : base.minus(interval);
    }

    public static ExprValue transferInputToExprValue(Object candidate, SqlTypeName sqlTypeName) {
        return ExprValueUtils.fromObjectValue(candidate, OpenSearchTypeFactory.convertSqlTypeNameToExprType(sqlTypeName));
    }

    public static ExprValue transferInputToExprTimestampValue(Object candidate, SqlTypeName sqlTypeName, FunctionProperties properties) {
        switch (sqlTypeName) {
            case TIME: {
                ExprTimeValue timeValue = (ExprTimeValue)ExprValueUtils.fromObjectValue(candidate, OpenSearchTypeFactory.convertSqlTypeNameToExprType(sqlTypeName));
                return new ExprTimestampValue(timeValue.timestampValue(properties));
            }
        }
        try {
            return new ExprTimestampValue(ExprValueUtils.fromObjectValue(candidate, OpenSearchTypeFactory.convertSqlTypeNameToExprType(sqlTypeName)).timestampValue());
        }
        catch (SemanticCheckException e) {
            ExprTimeValue hardTransferredTimeValue = (ExprTimeValue)ExprValueUtils.fromObjectValue(candidate, ExprCoreType.TIME);
            return new ExprTimestampValue(hardTransferredTimeValue.timestampValue(properties));
        }
    }

    public static TemporalAmount convertToTemporalAmount(long number, TimeUnit unit) {
        return switch (unit) {
            case TimeUnit.YEAR -> Period.ofYears((int)number);
            case TimeUnit.QUARTER -> Period.ofMonths((int)number * 3);
            case TimeUnit.MONTH -> Period.ofMonths((int)number);
            case TimeUnit.WEEK -> Period.ofWeeks((int)number);
            case TimeUnit.DAY -> Period.ofDays((int)number);
            case TimeUnit.HOUR -> Duration.ofHours(number);
            case TimeUnit.MINUTE -> Duration.ofMinutes(number);
            case TimeUnit.SECOND -> Duration.ofSeconds(number);
            case TimeUnit.MILLISECOND -> Duration.ofMillis(number);
            case TimeUnit.MICROSECOND -> Duration.ofNanos(number * 1000L);
            case TimeUnit.NANOSECOND -> Duration.ofNanos(number);
            default -> throw new UnsupportedOperationException("No mapping defined for Calcite TimeUnit: " + String.valueOf(unit));
        };
    }

    public static ExprValue transferTimeToTimestamp(ExprValue candidate, FunctionProperties functionProperties) {
        return new ExprTimestampValue(((ExprTimeValue)candidate).timestampValue(functionProperties));
    }
}

