/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils;

import java.lang.reflect.Method;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.AggregateFunction;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.ScalarFunction;
import org.apache.calcite.schema.impl.AggregateFunctionImpl;
import org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlUserDefinedAggFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Optionality;
import org.opensearch.sql.calcite.type.ExprSqlType;
import org.opensearch.sql.calcite.udf.UserDefinedAggFunction;
import org.opensearch.sql.calcite.udf.UserDefinedFunction;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.executor.QueryType;
import org.opensearch.sql.expression.function.FunctionProperties;
import org.opensearch.sql.utils.DateTimeFormatters;

public class UserDefinedFunctionUtils {
    public static SqlReturnTypeInference INTEGER_FORCE_NULLABLE = ReturnTypes.INTEGER.andThen(SqlTypeTransforms.FORCE_NULLABLE);
    public static RelDataType nullableTimeUDT = OpenSearchTypeFactory.TYPE_FACTORY.createUDT(OpenSearchTypeFactory.ExprUDT.EXPR_TIME, true);
    public static RelDataType nullableDateUDT = OpenSearchTypeFactory.TYPE_FACTORY.createUDT(OpenSearchTypeFactory.ExprUDT.EXPR_DATE, true);
    public static RelDataType nullableTimestampUDT = OpenSearchTypeFactory.TYPE_FACTORY.createUDT(OpenSearchTypeFactory.ExprUDT.EXPR_TIMESTAMP, true);
    public static SqlReturnTypeInference timestampInference = ReturnTypes.explicit((RelDataType)nullableTimestampUDT);
    public static SqlReturnTypeInference timeInference = ReturnTypes.explicit((RelDataType)nullableTimeUDT);
    public static SqlReturnTypeInference dateInference = ReturnTypes.explicit((RelDataType)nullableDateUDT);

    public static RelBuilder.AggCall TransferUserDefinedAggFunction(Class<? extends UserDefinedAggFunction> UDAF, String functionName, SqlReturnTypeInference returnType, List<RexNode> fields, List<RexNode> argList, RelBuilder relBuilder) {
        SqlUserDefinedAggFunction sqlUDAF = new SqlUserDefinedAggFunction(new SqlIdentifier(functionName, SqlParserPos.ZERO), SqlKind.OTHER_FUNCTION, returnType, null, null, (AggregateFunction)AggregateFunctionImpl.create(UDAF), false, false, Optionality.FORBIDDEN);
        ArrayList<RexNode> addArgList = new ArrayList<RexNode>(fields);
        addArgList.addAll(argList);
        return relBuilder.aggregateCall((SqlAggFunction)sqlUDAF, addArgList);
    }

    public static SqlOperator TransferUserDefinedFunction(Class<? extends UserDefinedFunction> UDF, String functionName, SqlReturnTypeInference returnType) {
        ScalarFunction udfFunction = ScalarFunctionImpl.create((Method)Types.lookupMethod(UDF, (String)"eval", (Class[])new Class[]{Object[].class}));
        SqlIdentifier udfLtrimIdentifier = new SqlIdentifier(Collections.singletonList(functionName), null, SqlParserPos.ZERO, null);
        return new SqlUserDefinedFunction(udfLtrimIdentifier, SqlKind.OTHER_FUNCTION, returnType, InferTypes.ANY_NULLABLE, null, (Function)udfFunction);
    }

    static SqlReturnTypeInference getReturnTypeInferenceForArray() {
        return opBinding -> {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            List argTypes = opBinding.collectOperandTypes();
            if (argTypes.isEmpty()) {
                throw new IllegalArgumentException("Function requires at least one argument.");
            }
            RelDataType firstArgType = (RelDataType)argTypes.getFirst();
            return SqlTypeUtil.createArrayType((RelDataTypeFactory)typeFactory, (RelDataType)firstArgType, (boolean)true);
        };
    }

    static List<Integer> transferStringExprToDateValue(String timeExpr) {
        try {
            if (timeExpr.contains(":")) {
                LocalDateTime localDateTime = LocalDateTime.parse(timeExpr, DateTimeFormatters.DATE_TIME_FORMATTER_VARIABLE_NANOS_OPTIONAL);
                return List.of(Integer.valueOf(localDateTime.getYear()), Integer.valueOf(localDateTime.getMonthValue()), Integer.valueOf(localDateTime.getDayOfMonth()));
            }
            LocalDate localDate = LocalDate.parse(timeExpr, DateTimeFormatters.DATE_TIME_FORMATTER_VARIABLE_NANOS_OPTIONAL);
            return List.of(Integer.valueOf(localDate.getYear()), Integer.valueOf(localDate.getMonthValue()), Integer.valueOf(localDate.getDayOfMonth()));
        }
        catch (DateTimeParseException e) {
            throw new SemanticCheckException(String.format("date:%s in unsupported format, please use 'yyyy-MM-dd'", timeExpr));
        }
    }

    public static void validateArgumentCount(String funcName, int expectedArguments, int actualArguments, boolean exactMatch) {
        if (exactMatch) {
            if (actualArguments != expectedArguments) {
                throw new IllegalArgumentException(String.format("Mismatch arguments: function %s expects %d arguments, but got %d", funcName, expectedArguments, actualArguments));
            }
        } else if (actualArguments < expectedArguments) {
            throw new IllegalArgumentException(String.format("Mismatch arguments: function %s expects at least %d arguments, but got %d", funcName, expectedArguments, actualArguments));
        }
    }

    public static void validateArgumentTypes(List<Object> objects, List<Class<?>> types) {
        UserDefinedFunctionUtils.validateArgumentTypes(objects, types, Collections.nCopies(types.size(), false));
    }

    public static void validateArgumentTypes(List<Object> objects, List<Class<?>> types, boolean nullable) {
        UserDefinedFunctionUtils.validateArgumentTypes(objects, types, Collections.nCopies(types.size(), nullable));
    }

    public static void validateArgumentTypes(List<Object> objects, List<Class<?>> types, List<Boolean> nullables) {
        if (objects.size() < types.size()) {
            throw new IllegalArgumentException(String.format("Mismatch in the number of objects and types. Got %d objects and %d types", objects.size(), types.size()));
        }
        for (int i = 0; i < types.size(); ++i) {
            if (objects.get(i) == null && nullables.get(i).booleanValue() || types.get(i).isInstance(objects.get(i))) continue;
            throw new IllegalArgumentException(String.format("Object at index %d is not of type %s (Got %s)", i, types.get(i).getName(), objects.get(i) == null ? "null" : objects.get(i).getClass().getName()));
        }
    }

    public static boolean containsNull(Object[] objects) {
        return Arrays.stream(objects).anyMatch(Objects::isNull);
    }

    public static String formatTimestampWithoutUnnecessaryNanos(LocalDateTime localDateTime) {
        String base = localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        int nano = localDateTime.getNano();
        if (nano == 0) {
            return base;
        }
        String nanoStr = String.format(Locale.ENGLISH, "%09d", nano);
        if (!(nanoStr = nanoStr.replaceFirst("0+$", "")).isEmpty()) {
            return base + "." + nanoStr;
        }
        return base;
    }

    public static SqlTypeName transferDateRelatedTimeName(RexNode candidate) {
        RelDataType type = candidate.getType();
        if (type instanceof ExprSqlType) {
            OpenSearchTypeFactory.ExprUDT exprUDT = ((ExprSqlType)type).getUdt();
            if (exprUDT == OpenSearchTypeFactory.ExprUDT.EXPR_TIME) {
                return SqlTypeName.TIME;
            }
            if (exprUDT == OpenSearchTypeFactory.ExprUDT.EXPR_TIMESTAMP) {
                return SqlTypeName.TIMESTAMP;
            }
            if (exprUDT == OpenSearchTypeFactory.ExprUDT.EXPR_DATE) {
                return SqlTypeName.DATE;
            }
        }
        return type.getSqlTypeName();
    }

    public static FunctionProperties restoreFunctionProperties(Object timestampStr) {
        String expression = (String)timestampStr;
        Instant parsed = Instant.parse(expression);
        FunctionProperties functionProperties = new FunctionProperties(parsed, ZoneId.systemDefault(), QueryType.PPL);
        return functionProperties;
    }
}

