/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.ExtendedRexBuilder;
import org.opensearch.sql.calcite.udf.conditionUDF.IfFunction;
import org.opensearch.sql.calcite.udf.conditionUDF.IfNullFunction;
import org.opensearch.sql.calcite.udf.conditionUDF.NullIfFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.ConvertTZFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.DateAddSubFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.DateDiffFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.DateFormatFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.DateFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.DatetimeFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.DayFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.DayOfWeekFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.DayOfYearFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.ExtractFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.FromDaysFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.FromUnixTimestampFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.GetFormatFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.HourFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.LastDayFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.MakeDateFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.MakeTimeFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.MicrosecondFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.MinuteFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.MinuteOfDayFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.MonthFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.PeriodAddFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.PeriodDiffFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.PeriodNameFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.PostprocessForUDTFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.QuarterFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.SecondFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.SecondToTimeFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.StrToDateFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.SysdateFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.TimeAddSubFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.TimeDiffFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.TimeFormatFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.TimeFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.TimeToSecondFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.TimestampAddFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.TimestampDiffFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.TimestampFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.ToDaysFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.ToSecondsFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.UnixTimeStampFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.UtcDateFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.UtcTimeFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.UtcTimeStampFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.WeekDayFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.WeekFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.YearFunction;
import org.opensearch.sql.calcite.udf.datetimeUDF.YearWeekFunction;
import org.opensearch.sql.calcite.udf.mathUDF.CRC32Function;
import org.opensearch.sql.calcite.udf.mathUDF.ConvFunction;
import org.opensearch.sql.calcite.udf.mathUDF.DivideFunction;
import org.opensearch.sql.calcite.udf.mathUDF.EulerFunction;
import org.opensearch.sql.calcite.udf.mathUDF.ModFunction;
import org.opensearch.sql.calcite.udf.mathUDF.SqrtFunction;
import org.opensearch.sql.calcite.udf.textUDF.LocateFunction;
import org.opensearch.sql.calcite.udf.textUDF.ReplaceFunction;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import shaded.com.google.common.collect.ImmutableList;

public interface BuiltinFunctionUtils {
    public static final Set<String> TIME_EXCLUSIVE_OPS = Set.of("SECOND", "SECOND_OF_MINUTE", "MINUTE", "MINUTE_OF_HOUR", "HOUR", "HOUR_OF_DAY");
    public static final SqlReturnTypeInference VARCHAR_FORCE_NULLABLE = ReturnTypes.VARCHAR.andThen(SqlTypeTransforms.FORCE_NULLABLE);

    public static SqlOperator translate(String op) {
        String capitalOP;
        switch (capitalOP = op.toUpperCase(Locale.ROOT)) {
            case "/": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(DivideFunction.class, "/", ReturnTypes.QUOTIENT_NULLABLE);
            }
            case "REPLACE": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(ReplaceFunction.class, "REPLACE", VARCHAR_FORCE_NULLABLE);
            }
            case "LOCATE": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(LocateFunction.class, "LOCATE", ReturnTypes.INTEGER.andThen(SqlTypeTransforms.FORCE_NULLABLE));
            }
            case "CONV": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(ConvFunction.class, "CONVERT", VARCHAR_FORCE_NULLABLE);
            }
            case "CRC32": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(CRC32Function.class, "CRC32", ReturnTypes.BIGINT);
            }
            case "E": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(EulerFunction.class, "E", ReturnTypes.DOUBLE);
            }
            case "MOD": 
            case "%": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(ModFunction.class, "MOD", ReturnTypes.LEAST_RESTRICTIVE);
            }
            case "SQRT": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(SqrtFunction.class, "SQRT", ReturnTypes.DOUBLE_FORCE_NULLABLE);
            }
            case "CURRENT_TIMESTAMP": 
            case "NOW": 
            case "LOCALTIMESTAMP": 
            case "LOCALTIME": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(PostprocessForUDTFunction.class, "POSTPROCESS", UserDefinedFunctionUtils.timestampInference);
            }
            case "CURTIME": 
            case "CURRENT_TIME": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(PostprocessForUDTFunction.class, "POSTPROCESS", UserDefinedFunctionUtils.timeInference);
            }
            case "CURRENT_DATE": 
            case "CURDATE": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(PostprocessForUDTFunction.class, "POSTPROCESS", UserDefinedFunctionUtils.dateInference);
            }
            case "DATE": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(DateFunction.class, "DATE", UserDefinedFunctionUtils.dateInference);
            }
            case "DATE_ADD": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(DateAddSubFunction.class, "DATE_ADD", UserDefinedFunctionUtils.timestampInference);
            }
            case "ADDDATE": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(DateAddSubFunction.class, "ADDDATE", DateAddSubFunction.getReturnTypeForAddOrSubDate());
            }
            case "SUBDATE": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(DateAddSubFunction.class, "SUBDATE", DateAddSubFunction.getReturnTypeForAddOrSubDate());
            }
            case "DATE_SUB": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(DateAddSubFunction.class, "DATE_SUB", UserDefinedFunctionUtils.timestampInference);
            }
            case "ADDTIME": 
            case "SUBTIME": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(TimeAddSubFunction.class, capitalOP, TimeAddSubFunction.getReturnTypeForTimeAddSub());
            }
            case "DAY_OF_WEEK": 
            case "DAYOFWEEK": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(DayOfWeekFunction.class, capitalOP, UserDefinedFunctionUtils.INTEGER_FORCE_NULLABLE);
            }
            case "DAY_OF_YEAR": 
            case "DAYOFYEAR": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(DayOfYearFunction.class, capitalOP, UserDefinedFunctionUtils.INTEGER_FORCE_NULLABLE);
            }
            case "EXTRACT": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(ExtractFunction.class, "EXTRACT", ReturnTypes.BIGINT);
            }
            case "CONVERT_TZ": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(ConvertTZFunction.class, "CONVERT_TZ", UserDefinedFunctionUtils.timestampInference);
            }
            case "DATETIME": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(DatetimeFunction.class, "DATETIME", UserDefinedFunctionUtils.timestampInference);
            }
            case "FROM_DAYS": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(FromDaysFunction.class, "FROM_DAYS", UserDefinedFunctionUtils.dateInference);
            }
            case "DATE_FORMAT": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(DateFormatFunction.class, "DATE_FORMAT", VARCHAR_FORCE_NULLABLE);
            }
            case "GET_FORMAT": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(GetFormatFunction.class, "GET_FORMAT", VARCHAR_FORCE_NULLABLE);
            }
            case "MAKETIME": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(MakeTimeFunction.class, "MAKETIME", UserDefinedFunctionUtils.timeInference);
            }
            case "MAKEDATE": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(MakeDateFunction.class, "MAKEDATE", UserDefinedFunctionUtils.dateInference);
            }
            case "MINUTE_OF_DAY": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(MinuteOfDayFunction.class, "MINUTE_OF_DAY", ReturnTypes.INTEGER);
            }
            case "PERIOD_ADD": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(PeriodAddFunction.class, "PERIOD_ADD", ReturnTypes.INTEGER);
            }
            case "PERIOD_DIFF": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(PeriodDiffFunction.class, "PERIOD_DIFF", ReturnTypes.INTEGER);
            }
            case "STR_TO_DATE": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(StrToDateFunction.class, "STR_TO_DATE", UserDefinedFunctionUtils.timestampInference);
            }
            case "WEEK": 
            case "WEEK_OF_YEAR": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(WeekFunction.class, "WEEK", ReturnTypes.INTEGER);
            }
            case "IF": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(IfFunction.class, "if", ReturnTypes.ARG1.andThen(SqlTypeTransforms.FORCE_NULLABLE));
            }
            case "IFNULL": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(IfNullFunction.class, "ifnull", ReturnTypes.ARG0_FORCE_NULLABLE);
            }
            case "NULLIF": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(NullIfFunction.class, "nullif", ReturnTypes.ARG0_FORCE_NULLABLE);
            }
            case "DAYNAME": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(PeriodNameFunction.class, "DAYNAME", VARCHAR_FORCE_NULLABLE);
            }
            case "MONTHNAME": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(PeriodNameFunction.class, "MONTHNAME", VARCHAR_FORCE_NULLABLE);
            }
            case "LAST_DAY": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(LastDayFunction.class, "LAST_DAY", UserDefinedFunctionUtils.dateInference);
            }
            case "UNIX_TIMESTAMP": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(UnixTimeStampFunction.class, "unix_timestamp", ReturnTypes.DOUBLE);
            }
            case "SYSDATE": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(SysdateFunction.class, "SYSDATE", UserDefinedFunctionUtils.timestampInference);
            }
            case "TIME": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(TimeFunction.class, "TIME", UserDefinedFunctionUtils.timeInference);
            }
            case "TIMEDIFF": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(TimeDiffFunction.class, "TIMEDIFF", UserDefinedFunctionUtils.timeInference);
            }
            case "TIME_TO_SEC": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(TimeToSecondFunction.class, "TIME_TO_SEC", ReturnTypes.BIGINT);
            }
            case "TIME_FORMAT": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(TimeFormatFunction.class, "TIME_FORMAT", VARCHAR_FORCE_NULLABLE);
            }
            case "TIMESTAMP": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(TimestampFunction.class, "timestamp", UserDefinedFunctionUtils.timestampInference);
            }
            case "TIMESTAMPADD": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(TimestampAddFunction.class, "TIMESTAMPADD", UserDefinedFunctionUtils.timestampInference);
            }
            case "TIMESTAMPDIFF": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(TimestampDiffFunction.class, "TIMESTAMPDIFF", ReturnTypes.BIGINT);
            }
            case "DATEDIFF": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(DateDiffFunction.class, "DATEDIFF", ReturnTypes.BIGINT);
            }
            case "TO_SECONDS": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(ToSecondsFunction.class, "TO_SECONDS", ReturnTypes.BIGINT);
            }
            case "TO_DAYS": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(ToDaysFunction.class, "TO_DAYS", ReturnTypes.BIGINT);
            }
            case "SEC_TO_TIME": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(SecondToTimeFunction.class, "SEC_TO_TIME", UserDefinedFunctionUtils.timeInference);
            }
            case "YEAR": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(YearFunction.class, capitalOP, UserDefinedFunctionUtils.INTEGER_FORCE_NULLABLE);
            }
            case "QUARTER": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(QuarterFunction.class, capitalOP, UserDefinedFunctionUtils.INTEGER_FORCE_NULLABLE);
            }
            case "MINUTE": 
            case "MINUTE_OF_HOUR": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(MinuteFunction.class, capitalOP, UserDefinedFunctionUtils.INTEGER_FORCE_NULLABLE);
            }
            case "HOUR": 
            case "HOUR_OF_DAY": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(HourFunction.class, capitalOP, UserDefinedFunctionUtils.INTEGER_FORCE_NULLABLE);
            }
            case "MONTH": 
            case "MONTH_OF_YEAR": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(MonthFunction.class, capitalOP, UserDefinedFunctionUtils.INTEGER_FORCE_NULLABLE);
            }
            case "DAY_OF_MONTH": 
            case "DAYOFMONTH": 
            case "DAY": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(DayFunction.class, capitalOP, UserDefinedFunctionUtils.INTEGER_FORCE_NULLABLE);
            }
            case "SECOND": 
            case "SECOND_OF_MINUTE": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(SecondFunction.class, capitalOP, UserDefinedFunctionUtils.INTEGER_FORCE_NULLABLE);
            }
            case "MICROSECOND": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(MicrosecondFunction.class, "MICROSECOND", ReturnTypes.INTEGER);
            }
            case "YEARWEEK": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(YearWeekFunction.class, "YEARWEEK", ReturnTypes.INTEGER);
            }
            case "FROM_UNIXTIME": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(FromUnixTimestampFunction.class, "FROM_UNIXTIME", FromUnixTimestampFunction.interReturnTypes());
            }
            case "WEEKDAY": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(WeekDayFunction.class, "WEEKDAY", ReturnTypes.INTEGER);
            }
            case "UTC_TIMESTAMP": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(UtcTimeStampFunction.class, "utc_timestamp", UserDefinedFunctionUtils.timestampInference);
            }
            case "UTC_TIME": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(UtcTimeFunction.class, "utc_time", UserDefinedFunctionUtils.timeInference);
            }
            case "UTC_DATE": {
                return UserDefinedFunctionUtils.TransferUserDefinedFunction(UtcDateFunction.class, "utc_date", UserDefinedFunctionUtils.dateInference);
            }
        }
        throw new IllegalArgumentException("Unsupported operator: " + op);
    }

    public static List<RexNode> translateArgument(String op, List<RexNode> argList, CalcitePlanContext context, String currentTimestampStr) {
        String capitalOP;
        switch (capitalOP = op.toUpperCase(Locale.ROOT)) {
            case "DATE": {
                List<RexLiteral> dateArgs = List.of(argList.get(0), context.rexBuilder.makeFlag((Enum)UserDefinedFunctionUtils.transferDateRelatedTimeName(argList.get(0))), context.rexBuilder.makeLiteral(currentTimestampStr));
                return dateArgs;
            }
            case "HOUR": 
            case "HOUR_OF_DAY": 
            case "MINUTE": 
            case "MINUTE_OF_HOUR": 
            case "QUARTER": 
            case "YEAR": 
            case "LAST_DAY": 
            case "DAY_OF_WEEK": 
            case "DAYOFWEEK": 
            case "DAY_OF_YEAR": 
            case "DAYOFYEAR": 
            case "MONTH": 
            case "MONTH_OF_YEAR": 
            case "DAY": 
            case "DAY_OF_MONTH": 
            case "DAYOFMONTH": 
            case "SECOND": 
            case "SECOND_OF_MINUTE": {
                return List.of(argList.get(0), context.rexBuilder.makeFlag((Enum)UserDefinedFunctionUtils.transferDateRelatedTimeName(argList.get(0))), context.rexBuilder.makeLiteral(currentTimestampStr));
            }
            case "CURRENT_TIMESTAMP": 
            case "NOW": 
            case "LOCALTIMESTAMP": 
            case "LOCALTIME": {
                RexNode currentTimestampCall = context.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CURRENT_TIMESTAMP, List.of());
                return List.of(currentTimestampCall, context.rexBuilder.makeFlag((Enum)SqlTypeName.TIMESTAMP));
            }
            case "CURTIME": 
            case "CURRENT_TIME": {
                RexNode currentTimeCall = context.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CURRENT_TIME, List.of());
                return List.of(currentTimeCall, context.rexBuilder.makeFlag((Enum)SqlTypeName.TIME));
            }
            case "CURRENT_DATE": 
            case "CURDATE": {
                RexNode currentDateCall = context.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CURRENT_DATE, List.of());
                return List.of(currentDateCall, context.rexBuilder.makeFlag((Enum)SqlTypeName.DATE));
            }
            case "TIMESTAMP": 
            case "TIMEDIFF": 
            case "TIME_TO_SEC": 
            case "TIME_FORMAT": 
            case "TO_SECONDS": 
            case "TO_DAYS": 
            case "CONVERT_TZ": {
                ArrayList<RexNode> timestampArgs = new ArrayList<RexNode>(argList);
                timestampArgs.addAll(argList.stream().map(p -> context.rexBuilder.makeFlag((Enum)UserDefinedFunctionUtils.transferDateRelatedTimeName(p))).collect(Collectors.toList()));
                timestampArgs.add((RexNode)context.rexBuilder.makeLiteral(currentTimestampStr));
                return timestampArgs;
            }
            case "YEARWEEK": 
            case "WEEKDAY": {
                ArrayList<RexNode> weekdayArgs = new ArrayList<RexNode>(argList);
                weekdayArgs.addAll(argList.stream().map(p -> context.rexBuilder.makeFlag((Enum)UserDefinedFunctionUtils.transferDateRelatedTimeName(p))).collect(Collectors.toList()));
                weekdayArgs.add((RexNode)context.rexBuilder.makeLiteral(currentTimestampStr));
                return weekdayArgs;
            }
            case "TIMESTAMPADD": {
                ArrayList<RexNode> timestampAddArgs = new ArrayList<RexNode>(argList);
                timestampAddArgs.add((RexNode)context.rexBuilder.makeFlag((Enum)argList.get(2).getType().getSqlTypeName()));
                timestampAddArgs.add((RexNode)context.rexBuilder.makeLiteral(currentTimestampStr));
                return timestampAddArgs;
            }
            case "TIMESTAMPDIFF": {
                ArrayList<RexNode> timestampDiffArgs = new ArrayList<RexNode>();
                timestampDiffArgs.add(argList.getFirst());
                timestampDiffArgs.addAll(BuiltinFunctionUtils.buildArgsWithTypes(context.rexBuilder, argList, 1, 2));
                timestampDiffArgs.add((RexNode)context.rexBuilder.makeLiteral(currentTimestampStr));
                return timestampDiffArgs;
            }
            case "DATEDIFF": {
                List<RexNode> dateDiffArgs = BuiltinFunctionUtils.buildArgsWithTypes(context.rexBuilder, argList, 0, 1);
                dateDiffArgs.add((RexNode)context.rexBuilder.makeLiteral(currentTimestampStr));
                return dateDiffArgs;
            }
            case "DAYNAME": 
            case "MONTHNAME": {
                ArrayList<RexNode> periodNameArgs = new ArrayList<RexNode>();
                periodNameArgs.add(argList.getFirst());
                periodNameArgs.add((RexNode)context.rexBuilder.makeLiteral(capitalOP));
                periodNameArgs.add((RexNode)context.rexBuilder.makeFlag((Enum)argList.getFirst().getType().getSqlTypeName()));
                return periodNameArgs;
            }
            case "DATE_SUB": {
                List<RexNode> dateSubArgs = BuiltinFunctionUtils.transformDateManipulationArgs(argList, context.rexBuilder);
                dateSubArgs.add((RexNode)context.rexBuilder.makeLiteral(false));
                dateSubArgs.add((RexNode)context.rexBuilder.makeFlag((Enum)SqlTypeName.TIMESTAMP));
                dateSubArgs.add((RexNode)context.rexBuilder.makeLiteral(currentTimestampStr));
                return dateSubArgs;
            }
            case "DATE_ADD": {
                List<RexNode> dateAddArgs = BuiltinFunctionUtils.transformDateManipulationArgs(argList, context.rexBuilder);
                dateAddArgs.add((RexNode)context.rexBuilder.makeLiteral(true));
                dateAddArgs.add((RexNode)context.rexBuilder.makeFlag((Enum)SqlTypeName.TIMESTAMP));
                dateAddArgs.add((RexNode)context.rexBuilder.makeLiteral(currentTimestampStr));
                return dateAddArgs;
            }
            case "ADDTIME": {
                SqlTypeName arg0Type = UserDefinedFunctionUtils.transferDateRelatedTimeName(argList.getFirst());
                SqlTypeName arg1Type = UserDefinedFunctionUtils.transferDateRelatedTimeName(argList.get(1));
                RexLiteral type0 = context.rexBuilder.makeFlag((Enum)arg0Type);
                RexLiteral type1 = context.rexBuilder.makeFlag((Enum)arg1Type);
                RexLiteral isAdd = context.rexBuilder.makeLiteral(true);
                return List.of(argList.getFirst(), type0, argList.get(1), type1, isAdd, context.rexBuilder.makeLiteral(currentTimestampStr));
            }
            case "ADDDATE": {
                return BuiltinFunctionUtils.transformAddOrSubDateArgs(argList, context.rexBuilder, true, currentTimestampStr);
            }
            case "SUBDATE": {
                return BuiltinFunctionUtils.transformAddOrSubDateArgs(argList, context.rexBuilder, false, currentTimestampStr);
            }
            case "SUBTIME": {
                List<RexNode> subTimeArgs = BuiltinFunctionUtils.transformTimeManipulationArgs(argList, context.rexBuilder);
                subTimeArgs.add((RexNode)context.rexBuilder.makeLiteral(false));
                subTimeArgs.add((RexNode)context.rexBuilder.makeLiteral(currentTimestampStr));
                return subTimeArgs;
            }
            case "TIME": {
                return ImmutableList.of((Object)argList.getFirst(), (Object)context.rexBuilder.makeFlag((Enum)UserDefinedFunctionUtils.transferDateRelatedTimeName(argList.getFirst())));
            }
            case "DATE_FORMAT": 
            case "FORMAT_TIMESTAMP": {
                RexNode dateExpr = argList.get(0);
                RexNode dateFormatPatternExpr = argList.get(1);
                RexLiteral datetimeType = context.rexBuilder.makeFlag((Enum)UserDefinedFunctionUtils.transferDateRelatedTimeName(dateExpr));
                return ImmutableList.of((Object)dateExpr, (Object)datetimeType, (Object)dateFormatPatternExpr, (Object)context.rexBuilder.makeLiteral(currentTimestampStr));
            }
            case "UNIX_TIMESTAMP": {
                ArrayList<RexNode> unixArgs = new ArrayList<RexNode>(argList);
                unixArgs.add((RexNode)context.rexBuilder.makeFlag((Enum)UserDefinedFunctionUtils.transferDateRelatedTimeName(argList.getFirst())));
                unixArgs.add((RexNode)context.rexBuilder.makeLiteral(currentTimestampStr));
                return unixArgs;
            }
            case "WEEK": 
            case "WEEK_OF_YEAR": {
                Object woyMode = argList.size() >= 2 ? argList.get(1) : context.rexBuilder.makeLiteral(0, context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.INTEGER));
                return List.of(argList.getFirst(), woyMode, context.rexBuilder.makeFlag((Enum)argList.getFirst().getType().getSqlTypeName()));
            }
            case "STR_TO_DATE": {
                ArrayList<RexNode> strToDateArgs = new ArrayList<RexNode>(argList);
                strToDateArgs.add((RexNode)context.rexBuilder.makeLiteral(currentTimestampStr));
                return strToDateArgs;
            }
            case "MINUTE_OF_DAY": 
            case "MICROSECOND": {
                return ImmutableList.of((Object)argList.getFirst(), (Object)context.rexBuilder.makeFlag((Enum)UserDefinedFunctionUtils.transferDateRelatedTimeName(argList.getFirst())));
            }
            case "EXTRACT": {
                return ImmutableList.of((Object)argList.getFirst(), (Object)argList.get(1), (Object)context.rexBuilder.makeFlag((Enum)UserDefinedFunctionUtils.transferDateRelatedTimeName(argList.get(1))), (Object)context.rexBuilder.makeLiteral(currentTimestampStr));
            }
            case "DATETIME": {
                RexNode argTimestamp = argList.getFirst();
                if (argTimestamp.getType().getSqlTypeName().equals((Object)SqlTypeName.TIMESTAMP)) {
                    argTimestamp = BuiltinFunctionUtils.makeConversionCall("DATE_FORMAT", (List<RexNode>)ImmutableList.of((Object)argTimestamp, (Object)context.rexBuilder.makeLiteral("%Y-%m-%d %T")), context, currentTimestampStr);
                }
                return Stream.concat(Stream.of(argTimestamp), argList.stream().skip(1L)).toList();
            }
            case "UTC_TIMESTAMP": 
            case "UTC_TIME": 
            case "UTC_DATE": {
                return List.of(context.rexBuilder.makeLiteral(currentTimestampStr));
            }
        }
        return argList;
    }

    private static RexNode makeConversionCall(String funcName, List<RexNode> arguments, CalcitePlanContext context, String currentTimestampStr) {
        SqlOperator operator = BuiltinFunctionUtils.translate(funcName);
        List<RexNode> translatedArguments = BuiltinFunctionUtils.translateArgument(funcName, arguments, context, currentTimestampStr);
        RelDataType returnType = BuiltinFunctionUtils.deriveReturnType(funcName, context.rexBuilder, operator, translatedArguments);
        return context.rexBuilder.makeCall(returnType, operator, translatedArguments);
    }

    public static RelDataType deriveReturnType(String funcName, RexBuilder rexBuilder, SqlOperator operator, List<? extends RexNode> exprs) {
        RelDataType returnType = switch (funcName.toUpperCase(Locale.ROOT)) {
            case "DATEDIFF" -> rexBuilder.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
            case "TIMESTAMPDIFF" -> rexBuilder.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
            case "YEAR", "MINUTE", "HOUR", "HOUR_OF_DAY", "MONTH", "MONTH_OF_YEAR", "DAY_OF_YEAR", "DAYOFYEAR", "DAY_OF_MONTH", "DAYOFMONTH", "DAY_OF_WEEK", "DAYOFWEEK", "DAY", "MINUTE_OF_HOUR", "QUARTER", "SECOND", "SECOND_OF_MINUTE" -> rexBuilder.getTypeFactory().createSqlType(SqlTypeName.INTEGER);
            default -> rexBuilder.deriveReturnType(operator, exprs);
        };
        return rexBuilder.getTypeFactory().createTypeWithNullability(returnType, true);
    }

    private static List<RexNode> transformDateManipulationArgs(List<RexNode> argList, ExtendedRexBuilder rexBuilder) {
        ArrayList<RexNode> dateAddArgs = new ArrayList<RexNode>();
        RexNode baseTimestampExpr = argList.get(0);
        RexNode intervalExpr = argList.get(1);
        RexLiteral timeFrameName = rexBuilder.makeFlag((Enum)Objects.requireNonNull(intervalExpr.getType().getIntervalQualifier()).getUnit());
        dateAddArgs.add((RexNode)timeFrameName);
        RexLiteral intervalArg = rexBuilder.makeBigintLiteral((BigDecimal)((RexLiteral)intervalExpr).getValueAs(BigDecimal.class));
        dateAddArgs.add((RexNode)intervalArg);
        dateAddArgs.add(baseTimestampExpr);
        dateAddArgs.add((RexNode)rexBuilder.makeFlag((Enum)UserDefinedFunctionUtils.transferDateRelatedTimeName(baseTimestampExpr)));
        return dateAddArgs;
    }

    private static List<RexNode> transformAddOrSubDateArgs(List<RexNode> argList, ExtendedRexBuilder rexBuilder, Boolean isAdd, String currentTimestampStr) {
        ArrayList<RexNode> addOrSubDateArgs = new ArrayList<RexNode>();
        addOrSubDateArgs.add(argList.getFirst());
        SqlTypeName addType = argList.get(1).getType().getSqlTypeName();
        if (addType == SqlTypeName.BIGINT || addType == SqlTypeName.DECIMAL || addType == SqlTypeName.INTEGER) {
            Number value = (Number)((RexLiteral)argList.get(1)).getValueAs(Number.class);
            addOrSubDateArgs.add((RexNode)rexBuilder.makeIntervalLiteral(new BigDecimal(value.toString()), new SqlIntervalQualifier(TimeUnit.DAY, null, SqlParserPos.ZERO)));
        } else {
            addOrSubDateArgs.add(argList.get(1));
        }
        List<RexNode> addOrSubDateRealInput = BuiltinFunctionUtils.transformDateManipulationArgs(addOrSubDateArgs, rexBuilder);
        addOrSubDateRealInput.add((RexNode)rexBuilder.makeLiteral(isAdd));
        SqlTypeName firstType = UserDefinedFunctionUtils.transferDateRelatedTimeName(argList.getFirst());
        if (firstType == SqlTypeName.DATE && (addType == SqlTypeName.BIGINT || addType == SqlTypeName.DECIMAL || addType == SqlTypeName.INTEGER)) {
            addOrSubDateRealInput.add((RexNode)rexBuilder.makeFlag((Enum)SqlTypeName.DATE));
            addOrSubDateRealInput.add((RexNode)rexBuilder.makeLiteral(0, rexBuilder.getTypeFactory().createSqlType(SqlTypeName.DATE)));
        } else {
            addOrSubDateRealInput.add((RexNode)rexBuilder.makeFlag((Enum)SqlTypeName.TIMESTAMP));
            addOrSubDateRealInput.add((RexNode)rexBuilder.makeLiteral(0L, rexBuilder.getTypeFactory().createSqlType(SqlTypeName.TIMESTAMP)));
        }
        addOrSubDateRealInput.add((RexNode)rexBuilder.makeLiteral(currentTimestampStr));
        return addOrSubDateRealInput;
    }

    private static List<RexNode> transformTimeManipulationArgs(List<RexNode> argList, ExtendedRexBuilder rexBuilder) {
        SqlTypeName arg0Type = UserDefinedFunctionUtils.transferDateRelatedTimeName(argList.getFirst());
        SqlTypeName arg1Type = UserDefinedFunctionUtils.transferDateRelatedTimeName(argList.get(1));
        RexLiteral type0 = rexBuilder.makeFlag((Enum)arg0Type);
        RexLiteral type1 = rexBuilder.makeFlag((Enum)arg1Type);
        return new ArrayList<RexLiteral>(List.of(argList.getFirst(), type0, argList.get(1), type1));
    }

    private static List<RexNode> buildArgsWithTypes(RexBuilder rexBuilder, List<RexNode> args, int ... indexes) {
        ArrayList<RexNode> result = new ArrayList<RexNode>();
        for (int index : indexes) {
            RexNode arg = args.get(index);
            result.add(arg);
            result.add((RexNode)rexBuilder.makeFlag((Enum)UserDefinedFunctionUtils.transferDateRelatedTimeName(arg)));
        }
        return result;
    }
}

