/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.tools.RelBuilder;
import org.opensearch.sql.ast.expression.AggregateFunction;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.udf.udaf.PercentileApproxFunction;
import org.opensearch.sql.calcite.udf.udaf.TakeAggFunction;
import org.opensearch.sql.calcite.utils.CalciteToolsHelper;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import shaded.com.google.common.collect.ImmutableList;

public interface AggregateUtils {
    public static RelBuilder.AggCall translate(AggregateFunction agg, RexNode field, CalcitePlanContext context, List<RexNode> argList) {
        if (BuiltinFunctionName.ofAggregation(agg.getFuncName()).isEmpty()) {
            throw new IllegalStateException("Unexpected value: " + agg.getFuncName());
        }
        BuiltinFunctionName functionName = BuiltinFunctionName.ofAggregation(agg.getFuncName()).get();
        switch (functionName) {
            case MAX: {
                return context.relBuilder.max(field);
            }
            case MIN: {
                return context.relBuilder.min(field);
            }
            case AVG: {
                return context.relBuilder.avg(agg.getDistinct().booleanValue(), null, field);
            }
            case COUNT: {
                return context.relBuilder.count(agg.getDistinct().booleanValue(), null, (Iterable)(field == null ? ImmutableList.of() : ImmutableList.of((Object)field)));
            }
            case SUM: {
                return context.relBuilder.sum(agg.getDistinct().booleanValue(), null, field);
            }
            case VARSAMP: {
                return context.relBuilder.aggregateCall(CalciteToolsHelper.VAR_SAMP_NULLABLE, new RexNode[]{field});
            }
            case VARPOP: {
                return context.relBuilder.aggregateCall(CalciteToolsHelper.VAR_POP_NULLABLE, new RexNode[]{field});
            }
            case STDDEV_POP: {
                return context.relBuilder.aggregateCall(CalciteToolsHelper.STDDEV_POP_NULLABLE, new RexNode[]{field});
            }
            case STDDEV_SAMP: {
                return context.relBuilder.aggregateCall(CalciteToolsHelper.STDDEV_SAMP_NULLABLE, new RexNode[]{field});
            }
            case TAKE: {
                return UserDefinedFunctionUtils.TransferUserDefinedAggFunction(TakeAggFunction.class, "TAKE", UserDefinedFunctionUtils.getReturnTypeInferenceForArray(), List.of(field), argList, context.relBuilder);
            }
            case PERCENTILE_APPROX: {
                ArrayList<RexNode> newArgList = new ArrayList<RexNode>(argList);
                newArgList.add((RexNode)context.rexBuilder.makeFlag((Enum)field.getType().getSqlTypeName()));
                return UserDefinedFunctionUtils.TransferUserDefinedAggFunction(PercentileApproxFunction.class, "percentile_approx", ReturnTypes.ARG0_FORCE_NULLABLE, List.of(field), newArgList, context.relBuilder);
            }
        }
        throw new IllegalStateException("Not Supported value: " + agg.getFuncName());
    }

    public static AggregateCall aggCreate(SqlAggFunction agg, boolean isDistinct, RexNode field) {
        int index = ((RexInputRef)field).getIndex();
        return AggregateCall.create((SqlAggFunction)agg, (boolean)isDistinct, (boolean)false, (boolean)false, (List)ImmutableList.of(), (List)ImmutableList.of((Object)index), (int)-1, null, (RelCollation)RelCollations.EMPTY, (RelDataType)field.getType(), null);
    }
}

