/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.udf.mathUDF;

import java.math.BigDecimal;
import org.opensearch.sql.calcite.udf.UserDefinedFunction;
import org.opensearch.sql.calcite.utils.MathUtils;

public class ModFunction
implements UserDefinedFunction {
    @Override
    public Object eval(Object ... args) {
        Number num0;
        Object arg1;
        block7: {
            Object arg0;
            block6: {
                if (args.length != 2) {
                    throw new IllegalArgumentException(String.format("MOD function requires exactly two arguments, but got %d", args.length));
                }
                arg0 = args[0];
                arg1 = args[1];
                if (!(arg0 instanceof Number)) break block6;
                num0 = (Number)arg0;
                if (arg1 instanceof Number) break block7;
            }
            throw new IllegalArgumentException(String.format("MOD function requires two numeric arguments, but got %s and %s", arg0.getClass().getSimpleName(), arg1.getClass().getSimpleName()));
        }
        Number num1 = (Number)arg1;
        if (num1.doubleValue() == 0.0) {
            return null;
        }
        if (MathUtils.isIntegral(num0) && MathUtils.isIntegral(num1)) {
            long l0 = num0.longValue();
            long l1 = num1.longValue();
            long result = l0 % l1;
            return MathUtils.coerceToWidestIntegralType(num0, num1, result);
        }
        BigDecimal b0 = new BigDecimal(num0.toString());
        BigDecimal b1 = new BigDecimal(num1.toString());
        BigDecimal result = b0.remainder(b1);
        return MathUtils.coerceToWidestFloatingType(num0, num1, result.doubleValue());
    }
}

