/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.udf.datetimeUDF;

import java.util.Objects;
import org.apache.calcite.sql.type.SqlTypeName;
import org.opensearch.sql.calcite.udf.UserDefinedFunction;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.calcite.utils.datetime.DateTimeApplyUtils;
import org.opensearch.sql.data.model.ExprIntegerValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.datetime.DateTimeFunctions;
import org.opensearch.sql.expression.function.FunctionProperties;

public class YearWeekFunction
implements UserDefinedFunction {
    @Override
    public Object eval(Object ... args) {
        int mode;
        SqlTypeName sqlTypeName;
        if (UserDefinedFunctionUtils.containsNull(args)) {
            return null;
        }
        if (Objects.isNull(args[0])) {
            return null;
        }
        if (args.length == 3) {
            sqlTypeName = (SqlTypeName)args[1];
            mode = 0;
        } else {
            sqlTypeName = (SqlTypeName)args[2];
            mode = (Integer)args[1];
        }
        FunctionProperties restored = UserDefinedFunctionUtils.restoreFunctionProperties(args[args.length - 1]);
        if (sqlTypeName == SqlTypeName.TIME) {
            return DateTimeFunctions.yearweekToday(new ExprIntegerValue(mode), restored.getQueryStartClock()).integerValue();
        }
        ExprValue exprValue = DateTimeApplyUtils.transferInputToExprValue(args[0], sqlTypeName);
        ExprValue yearWeekValue = DateTimeFunctions.exprYearweek(exprValue, new ExprIntegerValue(mode));
        return yearWeekValue.integerValue();
    }
}

