/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.udf.datetimeUDF;

import java.util.Objects;
import org.apache.calcite.sql.type.SqlTypeName;
import org.opensearch.sql.calcite.udf.UserDefinedFunction;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.expression.datetime.DateTimeFunctions;
import org.opensearch.sql.expression.function.FunctionProperties;

public class UnixTimeStampFunction
implements UserDefinedFunction {
    @Override
    public Object eval(Object ... args) {
        if (UserDefinedFunctionUtils.containsNull(args)) {
            return null;
        }
        if (args.length == 1) {
            FunctionProperties restored = UserDefinedFunctionUtils.restoreFunctionProperties(args[args.length - 1]);
            return DateTimeFunctions.unixTimeStamp(restored.getQueryStartClock()).longValue();
        }
        Object input = args[0];
        if (Objects.isNull(input)) {
            return null;
        }
        ExprValue candidate = ExprValueUtils.fromObjectValue(args[0], OpenSearchTypeFactory.convertSqlTypeNameToExprType((SqlTypeName)args[1]));
        return (double)DateTimeFunctions.unixTimeStampOf(candidate).longValue().longValue();
    }
}

