/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.udf.datetimeUDF;

import org.apache.calcite.sql.type.SqlTypeName;
import org.opensearch.sql.calcite.udf.UserDefinedFunction;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.calcite.utils.datetime.DateTimeApplyUtils;
import org.opensearch.sql.data.model.ExprLongValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.datetime.DateTimeFunctions;
import org.opensearch.sql.expression.function.FunctionProperties;

public class ToSecondsFunction
implements UserDefinedFunction {
    @Override
    public Object eval(Object ... args) {
        if (UserDefinedFunctionUtils.containsNull(args)) {
            return null;
        }
        FunctionProperties restored = UserDefinedFunctionUtils.restoreFunctionProperties(args[args.length - 1]);
        SqlTypeName sqlTypeName = (SqlTypeName)args[1];
        switch (sqlTypeName) {
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case CHAR: 
            case VARCHAR: {
                ExprValue dateTimeValue = DateTimeApplyUtils.transferInputToExprTimestampValue(args[0], sqlTypeName, restored);
                return DateTimeFunctions.exprToSeconds(dateTimeValue).longValue();
            }
        }
        return DateTimeFunctions.exprToSecondsForIntType(new ExprLongValue((Number)args[0])).longValue();
    }
}

