/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.udf.datetimeUDF;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.opensearch.sql.calcite.type.ExprSqlType;
import org.opensearch.sql.calcite.udf.UserDefinedFunction;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.calcite.utils.datetime.DateTimeApplyUtils;
import org.opensearch.sql.data.model.ExprTimeValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.datetime.DateTimeFunctions;
import org.opensearch.sql.expression.function.FunctionProperties;

public class TimeAddSubFunction
implements UserDefinedFunction {
    @Override
    public Object eval(Object ... args) {
        if (UserDefinedFunctionUtils.containsNull(args)) {
            return null;
        }
        Object argBase = args[0];
        SqlTypeName baseType = (SqlTypeName)args[1];
        Object argInterval = args[2];
        SqlTypeName argIntervalType = (SqlTypeName)args[3];
        boolean isAdd = (Boolean)args[4];
        ExprValue baseValue = DateTimeApplyUtils.transferInputToExprValue(args[0], baseType);
        ExprValue intervalValue = DateTimeApplyUtils.transferInputToExprValue(argInterval, argIntervalType);
        FunctionProperties restored = UserDefinedFunctionUtils.restoreFunctionProperties(args[args.length - 1]);
        ExprValue result = isAdd ? DateTimeFunctions.exprAddTime(restored, baseValue, intervalValue) : DateTimeFunctions.exprSubTime(restored, baseValue, intervalValue);
        if (baseType == SqlTypeName.TIME) {
            return new ExprTimeValue(result.timeValue()).valueForCalcite();
        }
        return result.valueForCalcite();
    }

    public static SqlReturnTypeInference getReturnTypeForTimeAddSub() {
        return opBinding -> {
            RelDataType operandType0 = opBinding.getOperandType(0);
            if (operandType0 instanceof ExprSqlType) {
                OpenSearchTypeFactory.ExprUDT exprUDT = ((ExprSqlType)operandType0).getUdt();
                if (exprUDT == OpenSearchTypeFactory.ExprUDT.EXPR_DATE || exprUDT == OpenSearchTypeFactory.ExprUDT.EXPR_TIMESTAMP) {
                    return UserDefinedFunctionUtils.nullableTimestampUDT;
                }
                if (exprUDT == OpenSearchTypeFactory.ExprUDT.EXPR_TIME) {
                    return UserDefinedFunctionUtils.nullableTimeUDT;
                }
                throw new IllegalArgumentException("Unsupported UDT type");
            }
            SqlTypeName typeName = operandType0.getSqlTypeName();
            return switch (typeName) {
                case SqlTypeName.DATE, SqlTypeName.TIMESTAMP -> UserDefinedFunctionUtils.nullableTimestampUDT;
                case SqlTypeName.TIME -> UserDefinedFunctionUtils.nullableTimeUDT;
                default -> throw new IllegalArgumentException("Unsupported type: " + String.valueOf(typeName));
            };
        };
    }
}

