/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.udf.datetimeUDF;

import org.opensearch.sql.calcite.udf.UserDefinedFunction;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.data.model.ExprTimeValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.expression.datetime.DateTimeFunctions;

public class SecondToTimeFunction
implements UserDefinedFunction {
    @Override
    public Object eval(Object ... args) {
        ExprValue returnTimeValue;
        if (UserDefinedFunctionUtils.containsNull(args)) {
            return null;
        }
        Number candidate = (Number)args[0];
        if (candidate instanceof Long) {
            ExprValue transferredValue = ExprValueUtils.longValue((Long)candidate);
            returnTimeValue = DateTimeFunctions.exprSecToTime(transferredValue);
        } else if (candidate instanceof Integer) {
            ExprValue transferredValue = ExprValueUtils.integerValue((Integer)candidate);
            returnTimeValue = DateTimeFunctions.exprSecToTime(transferredValue);
        } else if (candidate instanceof Double) {
            ExprValue transferredValue = ExprValueUtils.doubleValue((Double)candidate);
            returnTimeValue = DateTimeFunctions.exprSecToTimeWithNanos(transferredValue);
        } else {
            ExprValue transferredValue = ExprValueUtils.floatValue((Float)candidate);
            returnTimeValue = DateTimeFunctions.exprSecToTimeWithNanos(transferredValue);
        }
        return new ExprTimeValue(returnTimeValue.timeValue()).valueForCalcite();
    }
}

