/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.udf.datetimeUDF;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.TextStyle;
import java.util.Locale;
import java.util.Objects;
import org.apache.calcite.sql.type.SqlTypeName;
import org.opensearch.sql.calcite.udf.UserDefinedFunction;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.calcite.utils.datetime.DateTimeParser;
import org.opensearch.sql.calcite.utils.datetime.InstantUtils;

public class PeriodNameFunction
implements UserDefinedFunction {
    @Override
    public Object eval(Object ... args) {
        LocalDate localDate;
        if (UserDefinedFunctionUtils.containsNull(args)) {
            return null;
        }
        Object candiate = args[0];
        Object type = args[1];
        SqlTypeName argumentType = (SqlTypeName)args[2];
        if (candiate instanceof String) {
            localDate = DateTimeParser.parse(candiate.toString()).toLocalDate();
        } else if (argumentType == SqlTypeName.DATE) {
            localDate = LocalDate.ofInstant(InstantUtils.fromInternalDate((Integer)candiate), ZoneOffset.UTC);
        } else if (argumentType == SqlTypeName.TIMESTAMP) {
            localDate = LocalDateTime.ofInstant(InstantUtils.fromEpochMills((Long)candiate), ZoneOffset.UTC).toLocalDate();
        } else {
            throw new IllegalArgumentException("something wrong");
        }
        String nameType = (String)type;
        if (Objects.equals(nameType, "MONTHNAME")) {
            return localDate.getMonth().getDisplayName(TextStyle.FULL, Locale.getDefault());
        }
        if (Objects.equals(nameType, "DAYNAME")) {
            return localDate.getDayOfWeek().getDisplayName(TextStyle.FULL, Locale.getDefault());
        }
        throw new IllegalArgumentException("something wrong");
    }
}

