/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.udf.datetimeUDF;

import org.apache.calcite.sql.type.SqlTypeName;
import org.opensearch.sql.calcite.udf.UserDefinedFunction;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.calcite.utils.datetime.DateTimeApplyUtils;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.datetime.DateTimeFunctions;
import org.opensearch.sql.expression.function.FunctionProperties;

public class DayOfYearFunction
implements UserDefinedFunction {
    @Override
    public Object eval(Object ... args) {
        if (UserDefinedFunctionUtils.containsNull(args)) {
            return null;
        }
        FunctionProperties restored = UserDefinedFunctionUtils.restoreFunctionProperties(args[args.length - 1]);
        ExprValue candidate = DateTimeApplyUtils.transferInputToExprValue(args[0], (SqlTypeName)args[1]);
        if ((SqlTypeName)args[1] == SqlTypeName.TIME) {
            return this.extractForTime(candidate, restored).valueForCalcite();
        }
        return this.extract(candidate).valueForCalcite();
    }

    public ExprValue extractForTime(ExprValue candidate, FunctionProperties functionProperties) {
        return DateTimeFunctions.dayOfYearToday(functionProperties.getQueryStartClock());
    }

    public ExprValue extract(ExprValue candidate) {
        return DateTimeFunctions.exprDayOfYear(candidate);
    }
}

