/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.ViewExpanders;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexWindowBounds;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Holder;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.Node;
import org.opensearch.sql.ast.expression.AllFields;
import org.opensearch.sql.ast.expression.Argument;
import org.opensearch.sql.ast.expression.Field;
import org.opensearch.sql.ast.expression.Let;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.Map;
import org.opensearch.sql.ast.expression.ParseMethod;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.expression.subquery.SubqueryExpression;
import org.opensearch.sql.ast.tree.AD;
import org.opensearch.sql.ast.tree.Aggregation;
import org.opensearch.sql.ast.tree.CloseCursor;
import org.opensearch.sql.ast.tree.Dedupe;
import org.opensearch.sql.ast.tree.Eval;
import org.opensearch.sql.ast.tree.FetchCursor;
import org.opensearch.sql.ast.tree.FillNull;
import org.opensearch.sql.ast.tree.Filter;
import org.opensearch.sql.ast.tree.Head;
import org.opensearch.sql.ast.tree.Join;
import org.opensearch.sql.ast.tree.Kmeans;
import org.opensearch.sql.ast.tree.Lookup;
import org.opensearch.sql.ast.tree.ML;
import org.opensearch.sql.ast.tree.Paginate;
import org.opensearch.sql.ast.tree.Parse;
import org.opensearch.sql.ast.tree.Project;
import org.opensearch.sql.ast.tree.RareTopN;
import org.opensearch.sql.ast.tree.Relation;
import org.opensearch.sql.ast.tree.Rename;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.ast.tree.SubqueryAlias;
import org.opensearch.sql.ast.tree.TableFunction;
import org.opensearch.sql.ast.tree.Trendline;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.calcite.CalciteAggCallVisitor;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.CalciteRexNodeVisitor;
import org.opensearch.sql.calcite.utils.JoinAndLookupUtils;
import org.opensearch.sql.exception.CalciteUnsupportedException;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.utils.ParseUtils;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.Iterables;

public class CalciteRelNodeVisitor
extends AbstractNodeVisitor<RelNode, CalcitePlanContext> {
    private final CalciteRexNodeVisitor rexVisitor = new CalciteRexNodeVisitor(this);
    private final CalciteAggCallVisitor aggVisitor = new CalciteAggCallVisitor(this.rexVisitor);

    public RelNode analyze(UnresolvedPlan unresolved, CalcitePlanContext context) {
        return unresolved.accept(this, context);
    }

    @Override
    public RelNode visitRelation(Relation node, CalcitePlanContext context) {
        context.relBuilder.scan(node.getTableQualifiedName().getParts());
        return context.relBuilder.peek();
    }

    private RelBuilder scan(RelOptTable tableSchema, CalcitePlanContext context) {
        RelNode scan = context.relBuilder.getScanFactory().createScan(ViewExpanders.simpleContext((RelOptCluster)context.relBuilder.getCluster()), tableSchema);
        context.relBuilder.push(scan);
        return context.relBuilder;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public RelNode visitFilter(Filter node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        boolean containsSubqueryExpression = this.containsSubqueryExpression(node.getCondition());
        @Nullable Holder v = Holder.empty();
        if (containsSubqueryExpression) {
            context.relBuilder.variable(arg_0 -> ((Holder)v).set(arg_0));
            context.pushCorrelVar((RexCorrelVariable)v.get());
        }
        RexNode condition = this.rexVisitor.analyze(node.getCondition(), context);
        if (containsSubqueryExpression) {
            context.relBuilder.filter((Iterable)ImmutableList.of((Object)((RexCorrelVariable)v.get()).id), new RexNode[]{condition});
            context.popCorrelVar();
        } else {
            context.relBuilder.filter(new RexNode[]{condition});
        }
        return context.relBuilder.peek();
    }

    private boolean containsSubqueryExpression(Node expr) {
        if (expr == null) {
            return false;
        }
        if (expr instanceof SubqueryExpression) {
            return true;
        }
        if (expr instanceof Let) {
            Let l = (Let)expr;
            return this.containsSubqueryExpression(l.getExpression());
        }
        for (Node node : expr.getChild()) {
            if (!this.containsSubqueryExpression(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public RelNode visitProject(Project node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        if (node.getProjectList().stream().anyMatch(e -> e instanceof AllFields)) {
            this.tryToRemoveNestedFields(context);
            return context.relBuilder.peek();
        }
        List projectList = node.getProjectList().stream().map(expr -> this.rexVisitor.analyze((UnresolvedExpression)expr, context)).collect(Collectors.toList());
        if (node.isExcluded()) {
            context.relBuilder.projectExcept(projectList);
        } else {
            context.relBuilder.project(projectList);
        }
        return context.relBuilder.peek();
    }

    private void tryToRemoveNestedFields(CalcitePlanContext context) {
        HashSet allFields = new HashSet(context.relBuilder.peek().getRowType().getFieldNames());
        List<RexNode> duplicatedNestedFields = allFields.stream().filter(field -> {
            int lastDot = field.lastIndexOf(".");
            return -1 != lastDot && allFields.contains(field.substring(0, lastDot));
        }).map(field -> context.relBuilder.field(field)).toList();
        if (!duplicatedNestedFields.isEmpty()) {
            context.relBuilder.projectExcept(duplicatedNestedFields);
        }
    }

    @Override
    public RelNode visitRename(Rename node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List originalNames = context.relBuilder.peek().getRowType().getFieldNames();
        ArrayList<String> newNames = new ArrayList<String>(originalNames);
        for (Map renameMap : node.getRenameList()) {
            UnresolvedExpression unresolvedExpression = renameMap.getTarget();
            if (unresolvedExpression instanceof Field) {
                Field t = (Field)unresolvedExpression;
                String newName = t.getField().toString();
                RexNode check = this.rexVisitor.analyze(renameMap.getOrigin(), context);
                if (check instanceof RexInputRef) {
                    RexInputRef ref = (RexInputRef)check;
                    newNames.set(ref.getIndex(), newName);
                    continue;
                }
                throw new SemanticCheckException(String.format("the original field %s cannot be resolved", renameMap.getOrigin()));
            }
            throw new SemanticCheckException(String.format("the target expected to be field, but is %s", renameMap.getTarget()));
        }
        context.relBuilder.rename(newNames);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitSort(Sort node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List sortList = node.getSortList().stream().map(expr -> {
            RexNode sortField = this.rexVisitor.analyze((UnresolvedExpression)expr, context);
            Sort.SortOption sortOption = this.analyzeSortOption(expr.getFieldArgs());
            if (sortOption == Sort.SortOption.DEFAULT_DESC) {
                return context.relBuilder.desc(sortField);
            }
            return sortField;
        }).collect(Collectors.toList());
        context.relBuilder.sort(sortList);
        return context.relBuilder.peek();
    }

    private Sort.SortOption analyzeSortOption(List<Argument> fieldArgs) {
        Boolean asc = (Boolean)fieldArgs.get(0).getValue().getValue();
        Optional<Argument> nullFirst = fieldArgs.stream().filter(option -> "nullFirst".equals(option.getArgName())).findFirst();
        if (nullFirst.isPresent()) {
            Boolean isNullFirst = (Boolean)nullFirst.get().getValue().getValue();
            return new Sort.SortOption(asc != false ? Sort.SortOrder.ASC : Sort.SortOrder.DESC, isNullFirst != false ? Sort.NullOrder.NULL_FIRST : Sort.NullOrder.NULL_LAST);
        }
        return asc != false ? Sort.SortOption.DEFAULT_ASC : Sort.SortOption.DEFAULT_DESC;
    }

    @Override
    public RelNode visitHead(Head node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        context.relBuilder.limit(node.getFrom().intValue(), node.getSize().intValue());
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitParse(Parse node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List originalFieldNames = context.relBuilder.peek().getRowType().getFieldNames();
        RexNode sourceField = this.rexVisitor.analyze(node.getSourceField(), context);
        ParseMethod parseMethod = node.getParseMethod();
        java.util.Map<String, Literal> arguments = node.getArguments();
        String pattern = (String)node.getPattern().getValue();
        List<String> groupCandidates = ParseUtils.getNamedGroupCandidates(parseMethod, pattern, arguments);
        List<RexNode> newFields = groupCandidates.stream().map(group -> context.rexBuilder.makeCall((SqlOperator)SqlLibraryOperators.REGEXP_EXTRACT, new RexNode[]{sourceField, context.rexBuilder.makeLiteral(pattern)})).toList();
        this.projectPlusOverriding(newFields, groupCandidates, context);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitEval(Eval node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List originalFieldNames = context.relBuilder.peek().getRowType().getFieldNames();
        node.getExpressionList().forEach(expr -> {
            boolean containsSubqueryExpression = this.containsSubqueryExpression((Node)expr);
            @Nullable Holder v = Holder.empty();
            if (containsSubqueryExpression) {
                context.relBuilder.variable(arg_0 -> ((Holder)v).set(arg_0));
                context.pushCorrelVar((RexCorrelVariable)v.get());
            }
            RexNode eval = this.rexVisitor.analyze((UnresolvedExpression)expr, context);
            if (containsSubqueryExpression) {
                context.relBuilder.project(Iterables.concat((Iterable)context.relBuilder.fields(), (Iterable)ImmutableList.of((Object)eval)), (Iterable)ImmutableList.of(), false, (Iterable)ImmutableList.of((Object)((RexCorrelVariable)v.get()).id));
                context.popCorrelVar();
            } else {
                String alias = (String)((RexLiteral)((RexCall)eval).getOperands().get(1)).getValueAs(String.class);
                this.projectPlusOverriding(List.of(eval), List.of(alias), context);
            }
        });
        return context.relBuilder.peek();
    }

    private void projectPlusOverriding(List<RexNode> newFields, List<String> newNames, CalcitePlanContext context) {
        List originalFieldNames = context.relBuilder.peek().getRowType().getFieldNames();
        List<RexNode> toOverrideList = originalFieldNames.stream().filter(newNames::contains).map(a -> context.relBuilder.field(a)).toList();
        context.relBuilder.projectPlus(newFields);
        if (!toOverrideList.isEmpty()) {
            context.relBuilder.projectExcept(toOverrideList);
        }
        List currentFields = context.relBuilder.peek().getRowType().getFieldNames();
        int length = currentFields.size();
        ArrayList<String> expectedRenameFields = new ArrayList<String>(currentFields.subList(0, length - newNames.size()));
        expectedRenameFields.addAll(newNames);
        context.relBuilder.rename(expectedRenameFields);
    }

    @Override
    public RelNode visitAggregation(Aggregation node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List aggList = node.getAggExprList().stream().map(expr -> this.aggVisitor.analyze((UnresolvedExpression)expr, context)).collect(Collectors.toList());
        ArrayList<RexNode> groupByList = new ArrayList<RexNode>();
        UnresolvedExpression span = node.getSpan();
        if (!Objects.isNull(span)) {
            RexNode spanRex = this.rexVisitor.analyze(span, context);
            groupByList.add(spanRex);
        }
        groupByList.addAll(node.getGroupExprList().stream().map(expr -> this.rexVisitor.analyze((UnresolvedExpression)expr, context)).toList());
        context.relBuilder.aggregate(context.relBuilder.groupKey(groupByList), aggList);
        ImmutableList outputFields = context.relBuilder.fields();
        int numOfOutputFields = outputFields.size();
        int numOfAggList = aggList.size();
        ArrayList reordered = new ArrayList(numOfOutputFields);
        List aggRexList = outputFields.subList(numOfOutputFields - numOfAggList, numOfOutputFields);
        reordered.addAll(aggRexList);
        List<RexNode> aliasedGroupByList = groupByList.stream().map(this::extractAliasLiteral).flatMap(Optional::stream).map(ref -> (String)ref.getValueAs(String.class)).map(arg_0 -> ((RelBuilder)context.relBuilder).field(arg_0)).map(f -> f).toList();
        reordered.addAll(aliasedGroupByList);
        context.relBuilder.project(reordered);
        return context.relBuilder.peek();
    }

    private Optional<RexLiteral> extractAliasLiteral(RexNode node) {
        if (node == null) {
            return Optional.empty();
        }
        if (node.getKind() == SqlKind.AS) {
            return Optional.of((RexLiteral)((RexCall)node).getOperands().get(1));
        }
        return Optional.empty();
    }

    @Override
    public RelNode visitJoin(Join node, CalcitePlanContext context) {
        List<UnresolvedPlan> children = node.getChildren();
        children.forEach(c -> this.analyze((UnresolvedPlan)c, context));
        RexNode joinCondition = node.getJoinCondition().map(c -> this.rexVisitor.analyzeJoinCondition((UnresolvedExpression)c, context)).orElse((RexNode)context.relBuilder.literal((Object)true));
        context.relBuilder.join(JoinAndLookupUtils.translateJoinType(node.getJoinType()), joinCondition);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitSubqueryAlias(SubqueryAlias node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        context.relBuilder.as(node.getAlias());
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitLookup(Lookup node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List sourceFieldsNames = context.relBuilder.peek().getRowType().getFieldNames();
        this.analyze(node.getLookupRelation(), context);
        JoinAndLookupUtils.addProjectionIfNecessary(node, context);
        List lookupTableFieldNames = context.relBuilder.peek().getRowType().getFieldNames();
        List<String> toBeRemovedLookupFieldNames = node.getMappingAliasMap().keySet().stream().filter(k -> !node.getOutputAliasMap().containsKey(k)).toList();
        List<String> providedFieldNames = lookupTableFieldNames.stream().filter(k -> !toBeRemovedLookupFieldNames.contains(k)).toList();
        List<RexNode> toBeRemovedLookupFields = toBeRemovedLookupFieldNames.stream().map(d -> context.relBuilder.field(2, 1, d)).toList();
        ArrayList<RexNode> toBeRemovedFields = new ArrayList<RexNode>(toBeRemovedLookupFields);
        java.util.Map<String, String> duplicatedFieldNamesMap = JoinAndLookupUtils.findDuplicatedFields(node, sourceFieldsNames, providedFieldNames);
        List<RexNode> duplicatedSourceFields = duplicatedFieldNamesMap.keySet().stream().map(field -> JoinAndLookupUtils.analyzeFieldsForLookUp(field, true, context)).toList();
        toBeRemovedFields.addAll(duplicatedSourceFields);
        List<String> expectedProvidedFieldNames = providedFieldNames.stream().map(k -> node.getOutputAliasMap().getOrDefault(k, (String)k)).toList();
        ArrayList<RexNode> newCoalesceList = new ArrayList<RexNode>();
        if (!duplicatedFieldNamesMap.isEmpty() && node.getOutputStrategy() == Lookup.OutputStrategy.APPEND) {
            List<RexNode> duplicatedProvidedFields = duplicatedFieldNamesMap.values().stream().map(field -> JoinAndLookupUtils.analyzeFieldsForLookUp(field, false, context)).toList();
            for (int i = 0; i < duplicatedProvidedFields.size(); ++i) {
                newCoalesceList.add(context.rexBuilder.coalesce(duplicatedSourceFields.get(i), duplicatedProvidedFields.get(i)));
            }
            toBeRemovedFields.addAll(duplicatedProvidedFields);
            ArrayList<String> newExpectedFieldNames = new ArrayList<String>(expectedProvidedFieldNames.stream().filter(k -> !duplicatedFieldNamesMap.containsKey(k)).toList());
            newExpectedFieldNames.addAll(duplicatedFieldNamesMap.keySet());
            expectedProvidedFieldNames = newExpectedFieldNames;
        }
        JoinAndLookupUtils.addJoinForLookUp(node, context);
        if (!newCoalesceList.isEmpty()) {
            context.relBuilder.projectPlus(newCoalesceList);
        }
        if (!toBeRemovedFields.isEmpty()) {
            context.relBuilder.projectExcept(toBeRemovedFields);
        }
        JoinAndLookupUtils.renameToExpectedFields(expectedProvidedFieldNames, sourceFieldsNames.size() - duplicatedSourceFields.size(), context);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitDedupe(Dedupe node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List<Argument> options = node.getOptions();
        Integer allowedDuplication = (Integer)options.get(0).getValue().getValue();
        Boolean keepEmpty = (Boolean)options.get(1).getValue().getValue();
        Boolean consecutive = (Boolean)options.get(2).getValue().getValue();
        if (allowedDuplication <= 0) {
            throw new IllegalArgumentException("Number of duplicate events must be greater than 0");
        }
        if (consecutive.booleanValue()) {
            throw new UnsupportedOperationException("Consecutive deduplication is not supported");
        }
        List<RexNode> dedupeFields = node.getFields().stream().map(f -> this.rexVisitor.analyze((UnresolvedExpression)f, context)).toList();
        if (keepEmpty.booleanValue()) {
            RexNode rowNumber = context.relBuilder.aggregateCall((SqlAggFunction)SqlStdOperatorTable.ROW_NUMBER, new RexNode[0]).over().partitionBy(dedupeFields).orderBy(dedupeFields).rowsTo(RexWindowBounds.CURRENT_ROW).as("_row_number_");
            context.relBuilder.projectPlus(new RexNode[]{rowNumber});
            RexInputRef _row_number_ = context.relBuilder.field("_row_number_");
            RexNode[] rexNodeArray = new RexNode[1];
            RexNode[] rexNodeArray2 = new RexNode[2];
            rexNodeArray2[0] = context.relBuilder.or(dedupeFields.stream().map(arg_0 -> ((RelBuilder)context.relBuilder).isNull(arg_0)).toList());
            rexNodeArray2[1] = context.relBuilder.lessThanOrEqual((RexNode)_row_number_, (RexNode)context.relBuilder.literal((Object)allowedDuplication));
            rexNodeArray[0] = context.relBuilder.or(rexNodeArray2);
            context.relBuilder.filter(rexNodeArray);
            context.relBuilder.projectExcept(new RexNode[]{_row_number_});
        } else {
            RexNode[] rexNodeArray = new RexNode[1];
            rexNodeArray[0] = context.relBuilder.and(dedupeFields.stream().map(arg_0 -> ((RelBuilder)context.relBuilder).isNotNull(arg_0)).toList());
            context.relBuilder.filter(rexNodeArray);
            RexNode rowNumber = context.relBuilder.aggregateCall((SqlAggFunction)SqlStdOperatorTable.ROW_NUMBER, new RexNode[0]).over().partitionBy(dedupeFields).orderBy(dedupeFields).rowsTo(RexWindowBounds.CURRENT_ROW).as("_row_number_");
            context.relBuilder.projectPlus(new RexNode[]{rowNumber});
            RexInputRef _row_number_ = context.relBuilder.field("_row_number_");
            context.relBuilder.filter(new RexNode[]{context.relBuilder.lessThanOrEqual((RexNode)_row_number_, (RexNode)context.relBuilder.literal((Object)allowedDuplication))});
            context.relBuilder.projectExcept(new RexNode[]{_row_number_});
        }
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitAD(AD node, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("AD command is unsupported in Calcite");
    }

    @Override
    public RelNode visitCloseCursor(CloseCursor closeCursor, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("Close cursor operation is unsupported in Calcite");
    }

    @Override
    public RelNode visitFetchCursor(FetchCursor cursor, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("Fetch cursor operation is unsupported in Calcite");
    }

    @Override
    public RelNode visitML(ML node, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("ML command is unsupported in Calcite");
    }

    @Override
    public RelNode visitPaginate(Paginate paginate, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("Paginate operation is unsupported in Calcite");
    }

    @Override
    public RelNode visitKmeans(Kmeans node, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("Kmeans command is unsupported in Calcite");
    }

    @Override
    public RelNode visitFillNull(FillNull fillNull, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("FillNull command is unsupported in Calcite");
    }

    @Override
    public RelNode visitRareTopN(RareTopN node, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("Rare and Top commands are unsupported in Calcite");
    }

    @Override
    public RelNode visitTableFunction(TableFunction node, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("Table function is unsupported in Calcite");
    }

    @Override
    public RelNode visitTrendline(Trendline node, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("Trendline command is unsupported in Calcite");
    }
}

