/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite;

import java.util.ArrayList;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.logging.log4j.util.Strings;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.expression.AggregateFunction;
import org.opensearch.sql.ast.expression.Alias;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.CalciteRexNodeVisitor;
import org.opensearch.sql.calcite.utils.AggregateUtils;

public class CalciteAggCallVisitor
extends AbstractNodeVisitor<RelBuilder.AggCall, CalcitePlanContext> {
    private final CalciteRexNodeVisitor rexNodeVisitor;

    public CalciteAggCallVisitor(CalciteRexNodeVisitor rexNodeVisitor) {
        this.rexNodeVisitor = rexNodeVisitor;
    }

    public RelBuilder.AggCall analyze(UnresolvedExpression unresolved, CalcitePlanContext context) {
        return unresolved.accept(this, context);
    }

    @Override
    public RelBuilder.AggCall visitAlias(Alias node, CalcitePlanContext context) {
        RelBuilder.AggCall aggCall = this.analyze(node.getDelegated(), context);
        return aggCall.as(Strings.isEmpty((CharSequence)node.getAlias()) ? node.getName() : node.getAlias());
    }

    @Override
    public RelBuilder.AggCall visitAggregateFunction(AggregateFunction node, CalcitePlanContext context) {
        RexNode field = this.rexNodeVisitor.analyze(node.getField(), context);
        ArrayList<RexNode> argList = new ArrayList<RexNode>();
        for (UnresolvedExpression arg : node.getArgList()) {
            argList.add(this.rexNodeVisitor.analyze(arg, context));
        }
        return AggregateUtils.translate(node, field, context, argList);
    }
}

