/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.tree;

import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.Node;
import org.opensearch.sql.ast.expression.Field;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.tree.UnresolvedPlan;

public class FillNull
extends UnresolvedPlan {
    private UnresolvedPlan child;
    @NonNull
    private final ContainNullableFieldFill containNullableFieldFill;

    public List<NullableFieldFill> getNullableFieldFills() {
        return this.containNullableFieldFill.getNullFieldFill();
    }

    @Override
    public UnresolvedPlan attach(UnresolvedPlan child) {
        this.child = child;
        return this;
    }

    @Override
    public List<? extends Node> getChild() {
        return this.child == null ? List.of() : List.of(this.child);
    }

    @Override
    public <T, C> T accept(AbstractNodeVisitor<T, C> nodeVisitor, C context) {
        return nodeVisitor.visitFillNull(this, context);
    }

    @Generated
    public FillNull(@NonNull ContainNullableFieldFill containNullableFieldFill) {
        if (containNullableFieldFill == null) {
            throw new NullPointerException("containNullableFieldFill is marked non-null but is null");
        }
        this.containNullableFieldFill = containNullableFieldFill;
    }

    @Generated
    public FillNull(UnresolvedPlan child, @NonNull ContainNullableFieldFill containNullableFieldFill) {
        if (containNullableFieldFill == null) {
            throw new NullPointerException("containNullableFieldFill is marked non-null but is null");
        }
        this.child = child;
        this.containNullableFieldFill = containNullableFieldFill;
    }

    public static interface ContainNullableFieldFill {
        public List<NullableFieldFill> getNullFieldFill();

        public static ContainNullableFieldFill ofVariousValue(List<NullableFieldFill> replacements) {
            return new VariousValueNullFill(replacements);
        }

        public static ContainNullableFieldFill ofSameValue(UnresolvedExpression replaceNullWithMe, List<Field> nullableFieldReferences) {
            return new SameValueNullFill(replaceNullWithMe, nullableFieldReferences);
        }
    }

    private static class VariousValueNullFill
    implements ContainNullableFieldFill {
        @NonNull
        private final List<NullableFieldFill> nullFieldFill;

        @Generated
        public VariousValueNullFill(@NonNull List<NullableFieldFill> nullFieldFill) {
            if (nullFieldFill == null) {
                throw new NullPointerException("nullFieldFill is marked non-null but is null");
            }
            this.nullFieldFill = nullFieldFill;
        }

        @Override
        @NonNull
        @Generated
        public List<NullableFieldFill> getNullFieldFill() {
            return this.nullFieldFill;
        }
    }

    private static class SameValueNullFill
    implements ContainNullableFieldFill {
        private final List<NullableFieldFill> nullFieldFill;

        public SameValueNullFill(UnresolvedExpression replaceNullWithMe, List<Field> nullableFieldReferences) {
            Objects.requireNonNull(replaceNullWithMe, "Null replacement is required");
            this.nullFieldFill = Objects.requireNonNull(nullableFieldReferences, "Nullable field reference is required").stream().map(nullableReference -> new NullableFieldFill((Field)nullableReference, replaceNullWithMe)).toList();
        }

        @Override
        @Generated
        public List<NullableFieldFill> getNullFieldFill() {
            return this.nullFieldFill;
        }
    }

    public static class NullableFieldFill {
        @NonNull
        private final Field nullableFieldReference;
        @NonNull
        private final UnresolvedExpression replaceNullWithMe;

        @NonNull
        @Generated
        public Field getNullableFieldReference() {
            return this.nullableFieldReference;
        }

        @NonNull
        @Generated
        public UnresolvedExpression getReplaceNullWithMe() {
            return this.replaceNullWithMe;
        }

        @Generated
        public NullableFieldFill(@NonNull Field nullableFieldReference, @NonNull UnresolvedExpression replaceNullWithMe) {
            if (nullableFieldReference == null) {
                throw new NullPointerException("nullableFieldReference is marked non-null but is null");
            }
            if (replaceNullWithMe == null) {
                throw new NullPointerException("replaceNullWithMe is marked non-null but is null");
            }
            this.nullableFieldReference = nullableFieldReference;
            this.replaceNullWithMe = replaceNullWithMe;
        }
    }
}

