/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.statement;

import lombok.Generated;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.statement.Statement;
import org.opensearch.sql.executor.QueryType;

public class Explain
extends Statement {
    private final Statement statement;
    private final QueryType queryType;
    private final ExplainFormat format;

    public Explain(Statement statement, QueryType queryType) {
        this(statement, queryType, null);
    }

    public Explain(Statement statement, QueryType queryType, String format) {
        this.statement = statement;
        this.queryType = queryType;
        this.format = Explain.format(format);
    }

    @Override
    public <R, C> R accept(AbstractNodeVisitor<R, C> visitor, C context) {
        return visitor.visitExplain(this, context);
    }

    public static ExplainFormat format(String format) {
        try {
            return ExplainFormat.valueOf(format.toUpperCase());
        }
        catch (Exception e) {
            return ExplainFormat.STANDARD;
        }
    }

    @Generated
    public Statement getStatement() {
        return this.statement;
    }

    @Generated
    public QueryType getQueryType() {
        return this.queryType;
    }

    @Generated
    public ExplainFormat getFormat() {
        return this.format;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Explain)) {
            return false;
        }
        Explain other = (Explain)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Statement this$statement = this.getStatement();
        Statement other$statement = other.getStatement();
        if (this$statement == null ? other$statement != null : !((Object)this$statement).equals(other$statement)) {
            return false;
        }
        QueryType this$queryType = this.getQueryType();
        QueryType other$queryType = other.getQueryType();
        if (this$queryType == null ? other$queryType != null : !((Object)((Object)this$queryType)).equals((Object)other$queryType)) {
            return false;
        }
        ExplainFormat this$format = this.getFormat();
        ExplainFormat other$format = other.getFormat();
        return !(this$format == null ? other$format != null : !((Object)((Object)this$format)).equals((Object)other$format));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Explain;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Statement $statement = this.getStatement();
        result = result * 59 + ($statement == null ? 43 : ((Object)$statement).hashCode());
        QueryType $queryType = this.getQueryType();
        result = result * 59 + ($queryType == null ? 43 : ((Object)((Object)$queryType)).hashCode());
        ExplainFormat $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : ((Object)((Object)$format)).hashCode());
        return result;
    }

    public static enum ExplainFormat {
        SIMPLE,
        STANDARD,
        EXTENDED;

    }
}

