/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.analysis;

import lombok.Generated;
import org.opensearch.sql.analysis.AnalysisContext;
import org.opensearch.sql.analysis.ExpressionAnalyzer;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.expression.Alias;
import org.opensearch.sql.ast.expression.HighlightFunction;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.planner.logical.LogicalHighlight;
import org.opensearch.sql.planner.logical.LogicalPlan;

public class HighlightAnalyzer
extends AbstractNodeVisitor<LogicalPlan, AnalysisContext> {
    private final ExpressionAnalyzer expressionAnalyzer;
    private final LogicalPlan child;

    public LogicalPlan analyze(UnresolvedExpression projectItem, AnalysisContext context) {
        LogicalPlan highlight = projectItem.accept(this, context);
        return highlight == null ? this.child : highlight;
    }

    @Override
    public LogicalPlan visitAlias(Alias node, AnalysisContext context) {
        UnresolvedExpression delegated = node.getDelegated();
        if (!(delegated instanceof HighlightFunction)) {
            return null;
        }
        HighlightFunction unresolved = (HighlightFunction)delegated;
        Expression field = this.expressionAnalyzer.analyze(unresolved.getHighlightField(), context);
        return new LogicalHighlight(this.child, field, unresolved.getArguments());
    }

    @Generated
    public HighlightAnalyzer(ExpressionAnalyzer expressionAnalyzer, LogicalPlan child) {
        this.expressionAnalyzer = expressionAnalyzer;
        this.child = child;
    }
}

