/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.query;

import com.o19s.es.ltr.LtrQueryContext;
import com.o19s.es.ltr.feature.FeatureSet;
import com.o19s.es.ltr.feature.store.CompiledLtrModel;
import com.o19s.es.ltr.feature.store.FeatureStore;
import com.o19s.es.ltr.feature.store.index.IndexFeatureStore;
import com.o19s.es.ltr.query.RankerQuery;
import com.o19s.es.ltr.ranker.linear.LinearRanker;
import com.o19s.es.ltr.utils.FeatureStoreLoader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.ltr.stats.LTRStats;
import org.opensearch.ltr.stats.StatName;

public class StoredLtrQueryBuilder
extends AbstractQueryBuilder<StoredLtrQueryBuilder>
implements NamedWriteable {
    public static final String NAME = "sltr";
    public static final ParseField MODEL_NAME = new ParseField("model", new String[0]);
    public static final ParseField FEATURE_CACHE_FLAG = new ParseField("cache", new String[0]);
    public static final ParseField FEATURESET_NAME = new ParseField("featureset", new String[0]);
    public static final ParseField STORE_NAME = new ParseField("store", new String[0]);
    public static final ParseField PARAMS = new ParseField("params", new String[0]);
    public static final ParseField ACTIVE_FEATURES = new ParseField("active_features", new String[0]);
    private static final ObjectParser<StoredLtrQueryBuilder, Void> PARSER = new ObjectParser("sltr");
    private final transient FeatureStoreLoader storeLoader;
    private String modelName;
    private Boolean featureScoreCacheFlag;
    private String featureSetName;
    private String storeName;
    private Map<String, Object> params;
    private List<String> activeFeatures;
    private LTRStats ltrStats;

    public StoredLtrQueryBuilder(FeatureStoreLoader storeLoader) {
        this.storeLoader = storeLoader;
    }

    public StoredLtrQueryBuilder(FeatureStoreLoader storeLoader, StreamInput input, LTRStats ltrStats) throws IOException {
        super(input);
        this.storeLoader = Objects.requireNonNull(storeLoader);
        this.modelName = input.readOptionalString();
        this.featureScoreCacheFlag = input.readOptionalBoolean();
        this.featureSetName = input.readOptionalString();
        this.params = input.readMap();
        String[] activeFeat = input.readOptionalStringArray();
        this.activeFeatures = activeFeat == null ? null : Arrays.asList(activeFeat);
        this.storeName = input.readOptionalString();
        this.ltrStats = ltrStats;
    }

    public static StoredLtrQueryBuilder fromXContent(FeatureStoreLoader storeLoader, XContentParser parser, LTRStats ltrStats) throws IOException {
        storeLoader = Objects.requireNonNull(storeLoader);
        StoredLtrQueryBuilder builder = new StoredLtrQueryBuilder(storeLoader);
        try {
            PARSER.parse(parser, (Object)builder, null);
        }
        catch (IllegalArgumentException iae) {
            throw new ParsingException(parser.getTokenLocation(), iae.getMessage(), (Throwable)iae, new Object[0]);
        }
        if (builder.modelName() == null && builder.featureSetName() == null) {
            throw new ParsingException(parser.getTokenLocation(), "Either [" + String.valueOf(MODEL_NAME) + "] or [" + String.valueOf(FEATURESET_NAME) + "] must be set.", new Object[0]);
        }
        if (builder.params() == null) {
            throw new ParsingException(parser.getTokenLocation(), "Field [" + String.valueOf(PARAMS) + "] is mandatory.", new Object[0]);
        }
        builder.ltrStats(ltrStats);
        return builder;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.modelName);
        out.writeOptionalBoolean(this.featureScoreCacheFlag);
        out.writeOptionalString(this.featureSetName);
        out.writeMap(this.params);
        out.writeOptionalStringArray(this.activeFeatures != null ? this.activeFeatures.toArray(new String[0]) : null);
        out.writeOptionalString(this.storeName);
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params p) throws IOException {
        builder.startObject(NAME);
        if (this.modelName != null) {
            builder.field(MODEL_NAME.getPreferredName(), this.modelName);
        }
        if (this.featureScoreCacheFlag != null) {
            builder.field(FEATURE_CACHE_FLAG.getPreferredName(), this.featureScoreCacheFlag);
        }
        if (this.featureSetName != null) {
            builder.field(FEATURESET_NAME.getPreferredName(), this.featureSetName);
        }
        if (this.storeName != null) {
            builder.field(STORE_NAME.getPreferredName(), this.storeName);
        }
        if (this.params != null && !this.params.isEmpty()) {
            builder.field(PARAMS.getPreferredName(), this.params);
        }
        if (this.activeFeatures != null && !this.activeFeatures.isEmpty()) {
            builder.field(ACTIVE_FEATURES.getPreferredName(), this.activeFeatures);
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    private static void validateActiveFeatures(FeatureSet features, LtrQueryContext context) {
        for (String featureName : context.getActiveFeatures()) {
            if (features.hasFeature(featureName)) continue;
            throw new IllegalArgumentException("Feature: [" + featureName + "] provided in active_features does not exist");
        }
    }

    protected RankerQuery doToQuery(QueryShardContext context) throws IOException {
        this.ltrStats.getStat(StatName.LTR_REQUEST_TOTAL_COUNT.getName()).increment();
        try {
            return this.doToQueryInternal(context);
        }
        catch (Exception e) {
            this.ltrStats.getStat(StatName.LTR_REQUEST_ERROR_COUNT.getName()).increment();
            throw e;
        }
    }

    private RankerQuery doToQueryInternal(QueryShardContext context) throws IOException {
        String indexName = this.storeName != null ? IndexFeatureStore.indexName(this.storeName) : ".ltrstore";
        FeatureStore store = this.storeLoader.load(indexName, () -> ((QueryShardContext)context).getClient());
        LtrQueryContext ltrQueryContext = new LtrQueryContext(context, (Set<String>)(this.activeFeatures == null ? Collections.emptySet() : new HashSet<String>(this.activeFeatures)));
        if (this.modelName != null) {
            CompiledLtrModel model = store.loadModel(this.modelName);
            StoredLtrQueryBuilder.validateActiveFeatures(model.featureSet(), ltrQueryContext);
            return RankerQuery.build(model, ltrQueryContext, this.params, this.featureScoreCacheFlag, this.ltrStats);
        }
        assert (this.featureSetName != null);
        FeatureSet set = store.loadSet(this.featureSetName);
        float[] weights = new float[set.size()];
        Arrays.fill(weights, 1.0f);
        LinearRanker ranker = new LinearRanker(weights);
        CompiledLtrModel model = new CompiledLtrModel("linear", set, ranker);
        StoredLtrQueryBuilder.validateActiveFeatures(model.featureSet(), ltrQueryContext);
        return RankerQuery.build(model, ltrQueryContext, this.params, this.featureScoreCacheFlag, this.ltrStats);
    }

    protected boolean doEquals(StoredLtrQueryBuilder other) {
        return Objects.equals(this.modelName, other.modelName) && Objects.equals(this.featureScoreCacheFlag, other.featureScoreCacheFlag) && Objects.equals(this.featureSetName, other.featureSetName) && Objects.equals(this.storeName, other.storeName) && Objects.equals(this.params, other.params) && Objects.equals(this.activeFeatures, other.activeFeatures);
    }

    protected int doHashCode() {
        return Objects.hash(this.modelName, this.featureScoreCacheFlag, this.featureSetName, this.storeName, this.params, this.activeFeatures);
    }

    public String getWriteableName() {
        return NAME;
    }

    public String modelName() {
        return this.modelName;
    }

    public StoredLtrQueryBuilder modelName(String modelName) {
        this.modelName = Objects.requireNonNull(modelName);
        return this;
    }

    public StoredLtrQueryBuilder featureScoreCacheFlag(Boolean featureScoreCacheFlag) {
        this.featureScoreCacheFlag = featureScoreCacheFlag;
        return this;
    }

    public String featureSetName() {
        return this.featureSetName;
    }

    public StoredLtrQueryBuilder featureSetName(String featureSetName) {
        this.featureSetName = featureSetName;
        return this;
    }

    public StoredLtrQueryBuilder ltrStats(LTRStats ltrStats) {
        this.ltrStats = ltrStats;
        return this;
    }

    public String storeName() {
        return this.storeName;
    }

    public StoredLtrQueryBuilder storeName(String storeName) {
        this.storeName = storeName;
        return this;
    }

    public Map<String, Object> params() {
        return this.params;
    }

    public StoredLtrQueryBuilder params(Map<String, Object> params) {
        this.params = Objects.requireNonNull(params);
        return this;
    }

    public List<String> activeFeatures() {
        return this.activeFeatures;
    }

    public StoredLtrQueryBuilder activeFeatures(List<String> activeFeatures) {
        this.activeFeatures = Objects.requireNonNull(activeFeatures);
        return this;
    }

    static {
        PARSER.declareString(StoredLtrQueryBuilder::modelName, MODEL_NAME);
        PARSER.declareBoolean(StoredLtrQueryBuilder::featureScoreCacheFlag, FEATURE_CACHE_FLAG);
        PARSER.declareString(StoredLtrQueryBuilder::featureSetName, FEATURESET_NAME);
        PARSER.declareString(StoredLtrQueryBuilder::storeName, STORE_NAME);
        PARSER.declareField(StoredLtrQueryBuilder::params, XContentParser::map, PARAMS, ObjectParser.ValueType.OBJECT);
        PARSER.declareStringArray(StoredLtrQueryBuilder::activeFeatures, ACTIVE_FEATURES);
        StoredLtrQueryBuilder.declareStandardFields(PARSER);
    }
}

