/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.DBEAlgorithmSuiteId;
import software.amazon.cryptography.materialproviders.model.ESDKAlgorithmSuiteId;

public class AlgorithmSuiteId {
    private final ESDKAlgorithmSuiteId ESDK;
    private final DBEAlgorithmSuiteId DBE;

    protected AlgorithmSuiteId(BuilderImpl builder) {
        this.ESDK = builder.ESDK();
        this.DBE = builder.DBE();
    }

    public ESDKAlgorithmSuiteId ESDK() {
        return this.ESDK;
    }

    public DBEAlgorithmSuiteId DBE() {
        return this.DBE;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ESDKAlgorithmSuiteId ESDK;
        protected DBEAlgorithmSuiteId DBE;

        protected BuilderImpl() {
        }

        protected BuilderImpl(AlgorithmSuiteId model) {
            this.ESDK = model.ESDK();
            this.DBE = model.DBE();
        }

        @Override
        public Builder ESDK(ESDKAlgorithmSuiteId ESDK) {
            this.ESDK = ESDK;
            return this;
        }

        @Override
        public ESDKAlgorithmSuiteId ESDK() {
            return this.ESDK;
        }

        @Override
        public Builder DBE(DBEAlgorithmSuiteId DBE) {
            this.DBE = DBE;
            return this;
        }

        @Override
        public DBEAlgorithmSuiteId DBE() {
            return this.DBE;
        }

        @Override
        public AlgorithmSuiteId build() {
            if (!this.onlyOneNonNull()) {
                throw new IllegalArgumentException("`AlgorithmSuiteId` is a Union. A Union MUST have one and only one value set.");
            }
            return new AlgorithmSuiteId(this);
        }

        private boolean onlyOneNonNull() {
            Object[] allValues = new Object[]{this.ESDK, this.DBE};
            boolean haveOneNonNull = false;
            for (Object o : allValues) {
                if (!Objects.nonNull(o)) continue;
                if (haveOneNonNull) {
                    return false;
                }
                haveOneNonNull = true;
            }
            return haveOneNonNull;
        }
    }

    public static interface Builder {
        public Builder ESDK(ESDKAlgorithmSuiteId var1);

        public ESDKAlgorithmSuiteId ESDK();

        public Builder DBE(DBEAlgorithmSuiteId var1);

        public DBEAlgorithmSuiteId DBE();

        public AlgorithmSuiteId build();
    }
}

