/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.keystore.model;

import java.util.List;
import java.util.Objects;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.cryptography.keystore.model.KMSConfiguration;

public class KeyStoreConfig {
    private final String ddbTableName;
    private final KMSConfiguration kmsConfiguration;
    private final String logicalKeyStoreName;
    private final String id;
    private final List<String> grantTokens;
    private final DynamoDbClient ddbClient;
    private final KmsClient kmsClient;

    protected KeyStoreConfig(BuilderImpl builder) {
        this.ddbTableName = builder.ddbTableName();
        this.kmsConfiguration = builder.kmsConfiguration();
        this.logicalKeyStoreName = builder.logicalKeyStoreName();
        this.id = builder.id();
        this.grantTokens = builder.grantTokens();
        this.ddbClient = builder.ddbClient();
        this.kmsClient = builder.kmsClient();
    }

    public String ddbTableName() {
        return this.ddbTableName;
    }

    public KMSConfiguration kmsConfiguration() {
        return this.kmsConfiguration;
    }

    public String logicalKeyStoreName() {
        return this.logicalKeyStoreName;
    }

    public String id() {
        return this.id;
    }

    public List<String> grantTokens() {
        return this.grantTokens;
    }

    public DynamoDbClient ddbClient() {
        return this.ddbClient;
    }

    public KmsClient kmsClient() {
        return this.kmsClient;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String ddbTableName;
        protected KMSConfiguration kmsConfiguration;
        protected String logicalKeyStoreName;
        protected String id;
        protected List<String> grantTokens;
        protected DynamoDbClient ddbClient;
        protected KmsClient kmsClient;

        protected BuilderImpl() {
        }

        protected BuilderImpl(KeyStoreConfig model) {
            this.ddbTableName = model.ddbTableName();
            this.kmsConfiguration = model.kmsConfiguration();
            this.logicalKeyStoreName = model.logicalKeyStoreName();
            this.id = model.id();
            this.grantTokens = model.grantTokens();
            this.ddbClient = model.ddbClient();
            this.kmsClient = model.kmsClient();
        }

        @Override
        public Builder ddbTableName(String ddbTableName) {
            this.ddbTableName = ddbTableName;
            return this;
        }

        @Override
        public String ddbTableName() {
            return this.ddbTableName;
        }

        @Override
        public Builder kmsConfiguration(KMSConfiguration kmsConfiguration) {
            this.kmsConfiguration = kmsConfiguration;
            return this;
        }

        @Override
        public KMSConfiguration kmsConfiguration() {
            return this.kmsConfiguration;
        }

        @Override
        public Builder logicalKeyStoreName(String logicalKeyStoreName) {
            this.logicalKeyStoreName = logicalKeyStoreName;
            return this;
        }

        @Override
        public String logicalKeyStoreName() {
            return this.logicalKeyStoreName;
        }

        @Override
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public Builder grantTokens(List<String> grantTokens) {
            this.grantTokens = grantTokens;
            return this;
        }

        @Override
        public List<String> grantTokens() {
            return this.grantTokens;
        }

        @Override
        public Builder ddbClient(DynamoDbClient ddbClient) {
            this.ddbClient = ddbClient;
            return this;
        }

        @Override
        public DynamoDbClient ddbClient() {
            return this.ddbClient;
        }

        @Override
        public Builder kmsClient(KmsClient kmsClient) {
            this.kmsClient = kmsClient;
            return this;
        }

        @Override
        public KmsClient kmsClient() {
            return this.kmsClient;
        }

        @Override
        public KeyStoreConfig build() {
            if (Objects.isNull(this.ddbTableName())) {
                throw new IllegalArgumentException("Missing value for required field `ddbTableName`");
            }
            if (Objects.nonNull(this.ddbTableName()) && this.ddbTableName().length() < 3) {
                throw new IllegalArgumentException("The size of `ddbTableName` must be greater than or equal to 3");
            }
            if (Objects.nonNull(this.ddbTableName()) && this.ddbTableName().length() > 255) {
                throw new IllegalArgumentException("The size of `ddbTableName` must be less than or equal to 255");
            }
            if (Objects.isNull(this.kmsConfiguration())) {
                throw new IllegalArgumentException("Missing value for required field `kmsConfiguration`");
            }
            if (Objects.isNull(this.logicalKeyStoreName())) {
                throw new IllegalArgumentException("Missing value for required field `logicalKeyStoreName`");
            }
            return new KeyStoreConfig(this);
        }
    }

    public static interface Builder {
        public Builder ddbTableName(String var1);

        public String ddbTableName();

        public Builder kmsConfiguration(KMSConfiguration var1);

        public KMSConfiguration kmsConfiguration();

        public Builder logicalKeyStoreName(String var1);

        public String logicalKeyStoreName();

        public Builder id(String var1);

        public String id();

        public Builder grantTokens(List<String> var1);

        public List<String> grantTokens();

        public Builder ddbClient(DynamoDbClient var1);

        public DynamoDbClient ddbClient();

        public Builder kmsClient(KmsClient var1);

        public KmsClient kmsClient();

        public KeyStoreConfig build();
    }
}

