/*
 * Decompiled with CFR 0.152.
 */
package RawAESKeyring_Compile;

import BoundedInts_Compile.uint8;
import EdkWrapping_Compile.UnwrapEdkMaterialOutput;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import RawAESKeyring_Compile.AesGenerateAndWrapKeyMaterial;
import RawAESKeyring_Compile.AesUnwrapInfo;
import RawAESKeyring_Compile.AesUnwrapKeyMaterial;
import RawAESKeyring_Compile.AesWrapInfo;
import RawAESKeyring_Compile.AesWrapKeyMaterial;
import RawAESKeyring_Compile.__default;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.AES__GCM;

public class RawAESKeyring
implements VerifiableInterface,
IKeyring {
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public DafnySequence<? extends Byte> _wrappingKey = DafnySequence.empty(uint8._typeDescriptor());
    public AES__GCM _wrappingAlgorithm = null;
    public DafnySequence<? extends Byte> _keyNamespace = ValidUTF8Bytes.defaultValue();
    public DafnySequence<? extends Byte> _keyName = ValidUTF8Bytes.defaultValue();
    private static final TypeDescriptor<RawAESKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(RawAESKeyring.class, () -> null);

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out10 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out10;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out10 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out10;
    }

    public void __ctor(DafnySequence<? extends Byte> namespace, DafnySequence<? extends Byte> name, DafnySequence<? extends Byte> key, AES__GCM wrappingAlgorithm, AtomicPrimitivesClient cryptoPrimitives) {
        this._keyNamespace = namespace;
        this._keyName = name;
        this._wrappingKey = key;
        this._wrappingAlgorithm = wrappingAlgorithm;
        this._cryptoPrimitives = cryptoPrimitives;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> output = null;
        EncryptionMaterials _0_materials = input.dtor_materials();
        AlgorithmSuiteInfo _1_suite = _0_materials.dtor_algorithmSuite();
        AesWrapKeyMaterial _nw0 = new AesWrapKeyMaterial();
        _nw0.__ctor(this.wrappingKey(), this.wrappingAlgorithm(), this.cryptoPrimitives());
        AesWrapKeyMaterial _2_wrap = _nw0;
        AesGenerateAndWrapKeyMaterial _nw1 = new AesGenerateAndWrapKeyMaterial();
        _nw1.__ctor(_2_wrap);
        AesGenerateAndWrapKeyMaterial _3_generateAndWrap = _nw1;
        Result<WrapEdkMaterialOutput<AesWrapInfo>, Error> _4_valueOrError0 = Result.Default(WrapEdkMaterialOutput._typeDescriptor(AesWrapInfo._typeDescriptor()), Error._typeDescriptor(), WrapEdkMaterialOutput.Default(AesWrapInfo._typeDescriptor(), AesWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<AesWrapInfo>, Error> _out0 = EdkWrapping_Compile.__default.WrapEdkMaterial(AesWrapInfo._typeDescriptor(), _0_materials, _2_wrap, _3_generateAndWrap);
        _4_valueOrError0 = _out0;
        if (_4_valueOrError0.IsFailure(WrapEdkMaterialOutput._typeDescriptor(AesWrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            output = _4_valueOrError0.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(AesWrapInfo._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return output;
        }
        WrapEdkMaterialOutput<AesWrapInfo> _5_wrapOutput = _4_valueOrError0.Extract(WrapEdkMaterialOutput._typeDescriptor(AesWrapInfo._typeDescriptor()), Error._typeDescriptor());
        Option<Object> _6_symmetricSigningKeyList = _5_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor())), DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_5_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor())));
        EncryptedDataKey _7_edk = EncryptedDataKey.create(this.keyNamespace(), this.SerializeProviderInfo(_5_wrapOutput.dtor_wrapInfo().dtor_iv()), _5_wrapOutput.dtor_wrappedMaterial());
        if (_5_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _8_valueOrError1 = null;
            _8_valueOrError1 = Materials_Compile.__default.EncryptionMaterialAddDataKey(_0_materials, _5_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_7_edk}), _6_symmetricSigningKeyList);
            if (_8_valueOrError1.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                output = _8_valueOrError1.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return output;
            }
            EncryptionMaterials _9_result = _8_valueOrError1.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            output = Result.create_Success(OnEncryptOutput._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput.create(_9_result));
            return output;
        }
        if (_5_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _10_valueOrError2 = null;
            _10_valueOrError2 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(_0_materials, (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_7_edk}), _6_symmetricSigningKeyList);
            if (_10_valueOrError2.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                output = _10_valueOrError2.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return output;
            }
            EncryptionMaterials _11_result = _10_valueOrError2.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            output = Result.create_Success(OnEncryptOutput._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput.create(_11_result));
            return output;
        }
        return output;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> output = null;
        DecryptionMaterials _0_materials = input.dtor_materials();
        Outcome<Error> _1_valueOrError0 = Outcome.Default(Error._typeDescriptor());
        _1_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_0_materials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_1_valueOrError0.IsFailure(Error._typeDescriptor())) {
            output = _1_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        Result<DafnySequence, Error> _2_valueOrError1 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        _2_valueOrError1 = CanonicalEncryptionContext_Compile.__default.EncryptionContextToAAD(input.dtor_materials().dtor_encryptionContext());
        if (_2_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            output = _2_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        DafnySequence _3_aad = _2_valueOrError1.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        Outcome<Error> _4_valueOrError2 = Outcome.Default(Error._typeDescriptor());
        _4_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Objects.equals(BigInteger.valueOf(this.wrappingKey().length()), BigInteger.valueOf(this.wrappingAlgorithm().dtor_keyLength())), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"The wrapping key does not match the wrapping algorithm")));
        if (_4_valueOrError2.IsFailure(Error._typeDescriptor())) {
            output = _4_valueOrError2.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        DafnySequence _5_errors = DafnySequence.empty(Error._typeDescriptor());
        BigInteger _hi0 = BigInteger.valueOf(input.dtor_encryptedDataKeys().length());
        BigInteger _6_i = BigInteger.ZERO;
        while (_6_i.compareTo(_hi0) < 0) {
            if (this.ShouldDecryptEDK((EncryptedDataKey)input.dtor_encryptedDataKeys().select(Helpers.toInt((BigInteger)_6_i)))) {
                Result<UnwrapEdkMaterialOutput<AesUnwrapInfo>, Error> _out0;
                EncryptedDataKey _7_edk = (EncryptedDataKey)input.dtor_encryptedDataKeys().select(Helpers.toInt((BigInteger)_6_i));
                DafnySequence<? extends Byte> _8_iv = this.GetIvFromProvInfo(_7_edk.dtor_keyProviderInfo());
                AesUnwrapKeyMaterial _nw0 = new AesUnwrapKeyMaterial();
                _nw0.__ctor(this.wrappingKey(), this.wrappingAlgorithm(), _8_iv, this.cryptoPrimitives());
                AesUnwrapKeyMaterial _9_unwrap = _nw0;
                Result<UnwrapEdkMaterialOutput<AesUnwrapInfo>, Error> _10_unwrapOutput = _out0 = EdkWrapping_Compile.__default.UnwrapEdkMaterial(AesUnwrapInfo._typeDescriptor(), _7_edk.dtor_ciphertext(), _0_materials, _9_unwrap);
                if (_10_unwrapOutput.is_Success()) {
                    Result<DecryptionMaterials, Error> _11_valueOrError3 = null;
                    _11_valueOrError3 = Materials_Compile.__default.DecryptionMaterialsAddDataKey(_0_materials, _10_unwrapOutput.dtor_value().dtor_plaintextDataKey(), _10_unwrapOutput.dtor_value().dtor_symmetricSigningKey());
                    if (_11_valueOrError3.IsFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                        output = _11_valueOrError3.PropagateFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                        return output;
                    }
                    DecryptionMaterials _12_result = _11_valueOrError3.Extract(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
                    OnDecryptOutput _13_value = OnDecryptOutput.create(_12_result);
                    output = Result.create_Success(OnDecryptOutput._typeDescriptor(), Error._typeDescriptor(), _13_value);
                    return output;
                }
                _5_errors = DafnySequence.concatenate((DafnySequence)_5_errors, (DafnySequence)DafnySequence.of(Error._typeDescriptor(), (Object[])new Error[]{_10_unwrapOutput.dtor_error()}));
            } else {
                Result<DafnySequence, Error> _14_valueOrError4 = Result.Default(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
                _14_valueOrError4 = UTF8.__default.Decode(((EncryptedDataKey)input.dtor_encryptedDataKeys().select(Helpers.toInt((BigInteger)_6_i))).dtor_keyProviderId()).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _15_e_boxed0 -> {
                    DafnySequence _15_e = _15_e_boxed0;
                    return Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_15_e);
                });
                if (_14_valueOrError4.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                    output = _14_valueOrError4.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                    return output;
                }
                DafnySequence _16_extractedKeyProviderId = _14_valueOrError4.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
                _5_errors = DafnySequence.concatenate((DafnySequence)_5_errors, (DafnySequence)DafnySequence.of(Error._typeDescriptor(), (Object[])new Error[]{Error.create_AwsCryptographicMaterialProvidersException(ErrorMessages_Compile.__default.IncorrectRawDataKeys(StandardLibrary_mString_Compile.__default.Base10Int2String(_6_i), (DafnySequence<? extends Character>)DafnySequence.asString((String)"AESKeyring"), (DafnySequence<? extends Character>)_16_extractedKeyProviderId))}));
            }
            _6_i = _6_i.add(BigInteger.ONE);
        }
        output = Result.create_Failure(OnDecryptOutput._typeDescriptor(), Error._typeDescriptor(), Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_5_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"Raw AES Keyring was unable to decrypt any encrypted data key. The list of encountered Exceptions is avaible via `list`.")));
        return output;
    }

    public DafnySequence<? extends Byte> SerializeProviderInfo(DafnySequence<? extends Byte> iv) {
        return DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(this.keyName(), StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(this.wrappingAlgorithm().dtor_tagLength() * 8)), StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(this.wrappingAlgorithm().dtor_ivLength())), iv);
    }

    public boolean ShouldDecryptEDK(EncryptedDataKey edk) {
        return edk.dtor_keyProviderId().equals(this.keyNamespace()) && this.ValidProviderInfo(edk.dtor_keyProviderInfo());
    }

    public boolean ValidProviderInfo(DafnySequence<? extends Byte> info) {
        return Objects.equals(BigInteger.valueOf(info.length()), BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN()).add(__default.IV__LEN__LEN()).add(BigInteger.valueOf(this.wrappingAlgorithm().dtor_ivLength()))) && info.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()))).equals(this.keyName()) && StandardLibrary_mUInt_Compile.__default.SeqToUInt32((DafnySequence<? extends Byte>)info.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length())), Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN())))) == 128 && StandardLibrary_mUInt_Compile.__default.SeqToUInt32((DafnySequence<? extends Byte>)info.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length())), Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN())))) == this.wrappingAlgorithm().dtor_tagLength() * 8 && StandardLibrary_mUInt_Compile.__default.SeqToUInt32((DafnySequence<? extends Byte>)info.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN())), Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN()).add(__default.IV__LEN__LEN())))) == this.wrappingAlgorithm().dtor_ivLength() && StandardLibrary_mUInt_Compile.__default.SeqToUInt32((DafnySequence<? extends Byte>)info.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN())), Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN()).add(__default.IV__LEN__LEN())))) == 12;
    }

    public DafnySequence<? extends Byte> GetIvFromProvInfo(DafnySequence<? extends Byte> info) {
        return info.drop(BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN()).add(__default.IV__LEN__LEN()));
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public DafnySequence<? extends Byte> wrappingKey() {
        return this._wrappingKey;
    }

    public AES__GCM wrappingAlgorithm() {
        return this._wrappingAlgorithm;
    }

    public DafnySequence<? extends Byte> keyNamespace() {
        return this._keyNamespace;
    }

    public DafnySequence<? extends Byte> keyName() {
        return this._keyName;
    }

    public static TypeDescriptor<RawAESKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "RawAESKeyring.RawAESKeyring";
    }
}

